/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.ext.ffi.MemoryIO;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends RubyObject {
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fields;
    private final int size;

    public static RubyClass createStructLayoutClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = ruby.defineClassUnder(CLASS_NAME, ruby.getObject(), Allocator.INSTANCE, rubyModule);
        rubyClass.defineAnnotatedMethods(StructLayout.class);
        rubyClass.defineAnnotatedConstants(StructLayout.class);
        return rubyClass;
    }

    StructLayout(Ruby ruby) {
        this(ruby, FFIProvider.getModule(ruby).fastGetClass(CLASS_NAME));
    }

    StructLayout(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.size = 0;
        this.fields = Collections.emptyMap();
    }

    StructLayout(Ruby ruby, Map<IRubyObject, Member> map, int n) {
        super(ruby, FFIProvider.getModule(ruby).fastGetClass(CLASS_NAME));
        this.fields = StructLayout.immutableMap(map);
        this.size = n;
    }

    private static Map<IRubyObject, Member> immutableMap(Map<IRubyObject, Member> map) {
        LinkedHashMap<IRubyObject, Member> linkedHashMap = new LinkedHashMap<IRubyObject, Member>(map.size());
        for (Map.Entry<IRubyObject, Member> entry : map.entrySet()) {
            linkedHashMap.put(StructLayout.convertKey(entry.getKey().getRuntime(), entry.getKey()), entry.getValue());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static IRubyObject convertKey(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubySymbol) {
            return iRubyObject;
        }
        return ruby.getSymbolTable().getSymbol(iRubyObject.asJavaString());
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.getMember(threadContext.getRuntime(), iRubyObject2).get(threadContext.getRuntime(), iRubyObject);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.getMember(threadContext.getRuntime(), iRubyObject2).put(threadContext.getRuntime(), iRubyObject, iRubyObject3);
        return iRubyObject3;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext threadContext) {
        return RubyArray.newArray(threadContext.getRuntime(), this.fields.keySet());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext threadContext) {
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.size);
    }

    private Member getMember(Ruby ruby, IRubyObject iRubyObject) {
        Member member = this.fields.get(StructLayout.convertKey(ruby, iRubyObject));
        if (member != null) {
            return member;
        }
        throw ruby.newArgumentError("Unknown field: " + iRubyObject);
    }

    static abstract class Member {
        protected final long offset;

        protected Member(long l) {
            this.offset = l;
        }

        static final MemoryIO getMemoryIO(IRubyObject iRubyObject) {
            return ((AbstractMemory)iRubyObject).getMemoryIO();
        }

        public abstract void put(Ruby var1, IRubyObject var2, IRubyObject var3);

        public abstract IRubyObject get(Ruby var1, IRubyObject var2);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new StructLayout(ruby, rubyClass);
        }
    }
}

