/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ext.ffi;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.ext.ffi.FFIProvider;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Invoker"}, parent="Object")
public abstract class Invoker
extends RubyObject {
    static final String CLASS_NAME = "Invoker";
    protected final Arity arity;

    public static RubyClass createInvokerClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(CLASS_NAME, ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(Invoker.class);
        rubyClass.defineAnnotatedConstants(Invoker.class);
        return rubyClass;
    }

    protected Invoker(Ruby ruby, int n) {
        super(ruby, FFIProvider.getModule(ruby).fastGetClass(CLASS_NAME));
        this.arity = Arity.fixed(n);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        DynamicMethod dynamicMethod = this.createDynamicMethod((RubyModule)iRubyObject);
        ((RubyModule)iRubyObject).addMethod(iRubyObject2.asJavaString(), dynamicMethod);
        return threadContext.getRuntime().getNil();
    }

    protected DynamicMethod createDynamicMethod(RubyModule rubyModule) {
        return new DynamicMethod(rubyModule, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                Invoker.this.arity.checkArity(threadContext.getRuntime(), iRubyObjectArray);
                return Invoker.this.invoke(threadContext.getRuntime(), iRubyObjectArray);
            }

            public DynamicMethod dup() {
                return this;
            }

            public Arity getArity() {
                return Invoker.this.getArity();
            }

            public boolean isNative() {
                return true;
            }
        };
    }

    @JRubyMethod(name={"invoke", "call"}, rest=true)
    public IRubyObject invoke(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.invoke(threadContext.getRuntime(), ((RubyArray)iRubyObjectArray[0]).toJavaArrayMaybeUnsafe());
    }

    public abstract IRubyObject invoke(Ruby var1, IRubyObject[] var2);

    public final Arity getArity() {
        return this.arity;
    }
}

