/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.compiler.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.compiler.ASTInspector;
import org.jruby.nb.nb.compiler.CacheCompiler;
import org.jruby.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.BlockBody;
import org.jruby.nb.nb.runtime.CallSite;
import org.jruby.nb.nb.runtime.CallType;
import org.jruby.nb.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.util.CodegenUtils;
import org.jruby.nb.nb.util.JavaNameMangler;
import org.jruby.util.ByteList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;

public class FieldBasedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    Map<String, String> sourcePositions = new HashMap<String, String>();
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    Map<String, String> symbols = new HashMap<String, String>();
    Map<Long, String> fixnums = new HashMap<Long, String>();

    public FieldBasedCacheCompiler(StandardASMCompiler standardASMCompiler) {
        this.scriptCompiler = standardASMCompiler;
    }

    public void cacheCallSite(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string, CallType callType) {
        String string2 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CallSite.class), JavaNameMangler.mangleStringForCleanJavaIdentifier(string));
        SkinnyMethodAdapter skinnyMethodAdapter = this.scriptCompiler.getInitMethod();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.ldc(string);
        if (callType.equals(CallType.NORMAL)) {
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        skinnyMethodAdapter.putfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CallSite.class));
        abstractMethodCompiler.method.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CallSite.class));
    }

    @Deprecated
    public void cachePosition(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string, int n) {
        String string2 = JavaNameMangler.mangleStringForCleanJavaIdentifier(string + "$" + n);
        String string3 = this.sourcePositions.get(string2);
        if (string3 == null) {
            SkinnyMethodAdapter skinnyMethodAdapter = this.scriptCompiler.getClassInitMethod();
            string3 = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ISourcePosition.class), string2);
            this.sourcePositions.put(JavaNameMangler.mangleStringForCleanJavaIdentifier(string + "$" + n), string3);
            skinnyMethodAdapter.ldc(string);
            skinnyMethodAdapter.ldc(n);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructPosition", CodegenUtils.sig(ISourcePosition.class, String.class, Integer.TYPE));
            skinnyMethodAdapter.putstatic(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(ISourcePosition.class));
        }
        abstractMethodCompiler.method.getstatic(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(ISourcePosition.class));
    }

    public void cacheByteList(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string) {
        String string2 = this.byteLists.get(string);
        if (string2 == null) {
            SkinnyMethodAdapter skinnyMethodAdapter = this.scriptCompiler.getClassInitMethod();
            string2 = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ByteList.class), "byteList");
            this.byteLists.put(string, string2);
            skinnyMethodAdapter.ldc(string);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            skinnyMethodAdapter.putstatic(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(ByteList.class));
        }
        abstractMethodCompiler.method.getstatic(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(ByteList.class));
    }

    public void cacheBigInteger(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, BigInteger bigInteger) {
        String string = this.bigIntegers.get(bigInteger);
        if (string == null) {
            SkinnyMethodAdapter skinnyMethodAdapter = this.scriptCompiler.getClassInitMethod();
            string = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(BigInteger.class), "bigInt");
            this.bigIntegers.put(bigInteger, string);
            skinnyMethodAdapter.newobj(CodegenUtils.p(BigInteger.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.ldc(bigInteger.toString());
            skinnyMethodAdapter.invokespecial(CodegenUtils.p(BigInteger.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
            skinnyMethodAdapter.putstatic(this.scriptCompiler.getClassname(), string, CodegenUtils.ci(BigInteger.class));
        }
        abstractMethodCompiler.method.getstatic(this.scriptCompiler.getClassname(), string, CodegenUtils.ci(BigInteger.class));
    }

    public void cacheSymbol(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string) {
        String string2 = this.symbols.get(string);
        if (string2 == null) {
            String string3 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubySymbol.class), "symbol");
            string2 = "getSymbol" + string3;
            this.symbols.put(string, string2);
            ClassVisitor classVisitor = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(4098, string2, CodegenUtils.sig(RubySymbol.class, Ruby.class), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(RubySymbol.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.astore(2);
            Label label = new Label();
            skinnyMethodAdapter.ifnull(label);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.label(label);
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.ldc(string);
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "fastNewSymbol", CodegenUtils.sig(RubySymbol.class, String.class));
            skinnyMethodAdapter.dup_x1();
            skinnyMethodAdapter.putfield(this.scriptCompiler.getClassname(), string3, CodegenUtils.ci(RubySymbol.class));
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.end();
        }
        abstractMethodCompiler.loadThis();
        abstractMethodCompiler.loadRuntime();
        abstractMethodCompiler.method.invokevirtual(this.scriptCompiler.getClassname(), string2, CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(Ruby.class)));
    }

    public void cacheFixnum(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, long l) {
        String string = this.fixnums.get(l);
        if (string == null) {
            String string2 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubyFixnum.class), "symbol");
            string = "getFixnum" + string2;
            this.fixnums.put(l, string);
            ClassVisitor classVisitor = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(4098, string, CodegenUtils.sig(RubyFixnum.class, Ruby.class), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(RubyFixnum.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.astore(2);
            Label label = new Label();
            skinnyMethodAdapter.ifnull(label);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.label(label);
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.ldc(l);
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
            skinnyMethodAdapter.dup_x1();
            skinnyMethodAdapter.putfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(RubyFixnum.class));
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.end();
        }
        abstractMethodCompiler.loadThis();
        abstractMethodCompiler.loadRuntime();
        abstractMethodCompiler.method.invokevirtual(this.scriptCompiler.getClassname(), string, CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Ruby.class)));
    }

    public void cacheClosure(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string, int n, StaticScope staticScope, boolean bl, NodeType nodeType, ASTInspector aSTInspector) {
        String string2 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(BlockBody.class), "closure");
        String string3 = "getClosure_" + string2;
        ClassVisitor classVisitor = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(4098, string3, CodegenUtils.sig(BlockBody.class, ThreadContext.class), null, null));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(BlockBody.class));
        skinnyMethodAdapter.dup();
        Label label = new Label();
        skinnyMethodAdapter.ifnonnull(label);
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.ldc(string);
        skinnyMethodAdapter.pushInt(n);
        StandardASMCompiler.buildStaticScopeNames(skinnyMethodAdapter, staticScope);
        skinnyMethodAdapter.ldc(bl);
        skinnyMethodAdapter.pushInt(BlockBody.asArgumentType(nodeType));
        skinnyMethodAdapter.ldc(!aSTInspector.hasClosure() && !aSTInspector.hasScopeAwareMethods());
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createCompiledBlockBody", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Object.class, String.class, Integer.TYPE, String[].class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE));
        skinnyMethodAdapter.putfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(BlockBody.class));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(BlockBody.class));
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.areturn();
        skinnyMethodAdapter.end();
        abstractMethodCompiler.loadThis();
        abstractMethodCompiler.loadThreadContext();
        abstractMethodCompiler.method.invokevirtual(this.scriptCompiler.getClassname(), string3, CodegenUtils.sig(BlockBody.class, ThreadContext.class));
    }

    public void cacheClosureOld(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, String string) {
        String string2 = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CompiledBlockCallback.class), "closure");
        String string3 = "getClosure_" + string2;
        ClassVisitor classVisitor = this.scriptCompiler.getClassVisitor();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(4098, string3, CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class), null, null));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CompiledBlockCallback.class));
        skinnyMethodAdapter.dup();
        Label label = new Label();
        skinnyMethodAdapter.ifnonnull(label);
        skinnyMethodAdapter.pop();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.ldc(string);
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "createBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class, Object.class, String.class));
        skinnyMethodAdapter.putfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CompiledBlockCallback.class));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(this.scriptCompiler.getClassname(), string2, CodegenUtils.ci(CompiledBlockCallback.class));
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.areturn();
        skinnyMethodAdapter.end();
        abstractMethodCompiler.loadThis();
        abstractMethodCompiler.loadRuntime();
        abstractMethodCompiler.method.invokevirtual(this.scriptCompiler.getClassname(), string3, CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(Ruby.class)));
    }
}

