/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast.util;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.TypeConverter;

public final class ArgsUtil {
    public static IRubyObject[] convertToJavaArray(IRubyObject iRubyObject) {
        if (iRubyObject == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (iRubyObject instanceof RubyArray) {
            return ((RubyArray)iRubyObject).toJavaArrayMaybeUnsafe();
        }
        return new IRubyObject[]{iRubyObject};
    }

    public static RubyArray convertToRubyArray(Ruby ruby, IRubyObject iRubyObject, boolean bl) {
        if (iRubyObject == null) {
            return RubyArray.newArrayLight(ruby, 0L);
        }
        if (bl) {
            return ArgsUtil.convertToRubyArrayWithCoerce(ruby, iRubyObject);
        }
        return RubyArray.newArrayLight(ruby, iRubyObject);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby ruby, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = TypeConverter.convertToType(iRubyObject, ruby.getArray(), MethodIndex.TO_ARY, "to_ary", false);
        if (iRubyObject2.isNil()) {
            return RubyArray.newArrayLight(ruby, iRubyObject);
        }
        return (RubyArray)iRubyObject2;
    }

    public static IRubyObject[] popArray(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray == null || iRubyObjectArray.length == 0) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length - 1];
        System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray.length - 1);
        return iRubyObjectArray2;
    }

    public static int arrayLength(IRubyObject iRubyObject) {
        return iRubyObject instanceof RubyArray ? ((RubyArray)iRubyObject).getLength() : 0;
    }
}

