/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast.executable;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.ast.executable.RubiniusCMethod;
import org.jruby.nb.nb.ast.executable.RubiniusMachine;
import org.jruby.nb.nb.parser.LocalStaticScope;
import org.jruby.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public class RubiniusRunner
implements Runnable {
    private Ruby runtime;
    public static final int RUBINIUS_BYTECODE_VERSION = 3;
    private Map methods = new HashMap();

    public RubiniusRunner(Ruby ruby, InputStream inputStream, String string) {
        try {
            this.runtime = ruby;
            this.readMagic(inputStream);
            this.readVersion(inputStream);
            this.readRest(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't read script: " + iOException);
        }
    }

    private final void readMagic(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        if (byArray[0] != 82 || byArray[1] != 66 || byArray[2] != 73 || byArray[3] != 88) {
            throw new RuntimeException("File is not a compiled Rubinius file");
        }
    }

    private final void readVersion(InputStream inputStream) throws IOException {
        int n = RubiniusRunner.readInt(inputStream);
        if (n != 3) {
            throw new RuntimeException("Can't run Rubinius code with version " + n);
        }
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = 0;
        n += byArray[0] << 24;
        n += byArray[1] << 16;
        n += byArray[2] << 8;
        return n += byArray[3];
    }

    private final void readRest(InputStream inputStream) throws IOException {
        RubiniusCMethod rubiniusCMethod = null;
        while ((rubiniusCMethod = this.unmarshalCMethod(inputStream)) != null) {
            this.methods.put(rubiniusCMethod.name, rubiniusCMethod);
        }
    }

    private final byte[] unmarshalCharArray(InputStream inputStream) throws IOException {
        int n = RubiniusRunner.readInt(inputStream);
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        return byArray;
    }

    private final String unmarshalString(InputStream inputStream) throws IOException {
        int n = RubiniusRunner.readInt(inputStream);
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        return String.valueOf(byArray);
    }

    private final int unmarshalInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = RubiniusRunner.readInt(inputStream);
        if (n == 110) {
            n2 = -n2;
        }
        return n2;
    }

    private final IRubyObject[] unmarshalTuple(InputStream inputStream) throws IOException {
        int n = RubiniusRunner.readInt(inputStream);
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = this.unmarshal(inputStream);
        }
        return iRubyObjectArray;
    }

    private final RubiniusCMethod unmarshalCMethod(InputStream inputStream) throws IOException {
        RubyArray rubyArray = (RubyArray)this.unmarshal(inputStream);
        if (rubyArray == null) {
            return null;
        }
        return new RubiniusCMethod(rubyArray);
    }

    private final IRubyObject unmarshal(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = -1;
        switch (n) {
            case 105: {
                return this.runtime.newFixnum(this.unmarshalInt(inputStream));
            }
            case 115: {
                return this.runtime.newString(this.unmarshalString(inputStream));
            }
            case 120: {
                return this.runtime.newSymbol(this.unmarshalString(inputStream));
            }
            case 112: {
                return this.runtime.newArray(this.unmarshalTuple(inputStream));
            }
            case 98: {
                return this.runtime.newString(this.unmarshalString(inputStream));
            }
            case 109: {
                return this.runtime.newArray(this.unmarshalTuple(inputStream));
            }
            case 66: {
                System.err.println("B");
                return null;
            }
            case 100: {
                System.err.println("d");
                return null;
            }
            case 114: {
                System.err.println("r");
                return null;
            }
            case 110: {
                return this.runtime.getNil();
            }
            case 116: {
                return this.runtime.getTrue();
            }
            case 102: {
                return this.runtime.getFalse();
            }
        }
        return null;
    }

    public void run() {
        RubiniusCMethod rubiniusCMethod = (RubiniusCMethod)this.methods.get("__script__");
        ThreadContext threadContext = this.runtime.getCurrentContext();
        LocalStaticScope localStaticScope = new LocalStaticScope(null);
        if (localStaticScope.getModule() == null) {
            localStaticScope.setModule(this.runtime.getObject());
        }
        localStaticScope.setVariables(new String[rubiniusCMethod.locals]);
        threadContext.setFile(rubiniusCMethod.file);
        threadContext.setLine(-1);
        threadContext.preScopedBody(DynamicScope.newDynamicScope(localStaticScope, null));
        RubiniusMachine.INSTANCE.exec(threadContext, this.runtime.getObject(), rubiniusCMethod.code, rubiniusCMethod.literals, new IRubyObject[0]);
    }
}

