/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpNode
extends Node
implements ILiteralNode {
    private RubyRegexp pattern;
    private final ByteList value;
    private final int options;

    public RegexpNode(ISourcePosition iSourcePosition, ByteList byteList, int n) {
        super(iSourcePosition, NodeType.REGEXPNODE);
        this.value = byteList;
        this.options = n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitRegexpNode(this);
    }

    public int getOptions() {
        return this.options;
    }

    public ByteList getValue() {
        return this.value;
    }

    public void setPattern(RubyRegexp rubyRegexp) {
        this.pattern = rubyRegexp;
        this.pattern.setLiteral();
    }

    public RubyRegexp getPattern() {
        return this.pattern;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.pattern == null) {
            this.setPattern(RubyRegexp.newRegexp(ruby, this.value, this.options));
        }
        return this.pattern;
    }
}

