/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.nb.nb.ast.NilImplicitNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListNode
extends Node {
    private List<Node> list = new ArrayList<Node>(0);

    public ListNode(ISourcePosition iSourcePosition, NodeType nodeType, Node node) {
        this(iSourcePosition, nodeType);
        this.list = new ArrayList<Node>(4);
        this.list.add(node);
    }

    public ListNode(ISourcePosition iSourcePosition, NodeType nodeType) {
        super(iSourcePosition, nodeType);
    }

    public ListNode(ISourcePosition iSourcePosition) {
        this(iSourcePosition, NodeType.LISTNODE);
    }

    public ListNode add(Node node) {
        if (node == null) {
            this.list.add(NilImplicitNode.NIL);
            return this;
        }
        this.list.add(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        } else {
            this.setPosition(this.getPosition().union(node.getPosition()));
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(0, node);
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public ListNode addAll(ListNode listNode) {
        if (listNode != null && listNode.size() > 0) {
            this.list.addAll(listNode.list);
            this.setPosition(this.getPosition().union(this.getLast().getPosition()));
        }
        return this;
    }

    public ListNode addAll(Node node) {
        return this.add(node);
    }

    public Node getLast() {
        return this.list.size() == 0 ? null : this.list.get(this.list.size() - 1);
    }

    @Override
    public String toString() {
        String string = super.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            stringBuilder.append(this.list.get(i));
            if (i + 1 >= this.list.size()) continue;
            stringBuilder.append(", ");
        }
        return string + ": {" + stringBuilder.toString() + "}";
    }

    @Override
    public List<Node> childNodes() {
        return this.list;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int n) {
        return this.list.get(n);
    }
}

