/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.ast.DStrNode;
import org.jruby.nb.nb.ast.ListNode;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.StrNode;
import org.jruby.nb.nb.ast.types.ILiteralNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DXStrNode
extends ListNode
implements ILiteralNode {
    public DXStrNode(ISourcePosition iSourcePosition, DStrNode dStrNode) {
        super(iSourcePosition, NodeType.DXSTRNODE);
        this.addAll(dStrNode);
    }

    public DXStrNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.DXSTRNODE);
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDXStrNode(this);
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyString rubyString = ruby.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node node = this.get(i);
            if (node instanceof StrNode) {
                rubyString.getByteList().append(((StrNode)node).getValue());
                continue;
            }
            rubyString.append(node.interpret(ruby, threadContext, iRubyObject, block));
        }
        return iRubyObject.callMethod(threadContext, "`", rubyString);
    }
}

