/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.types.INameNode;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colon3Node
extends Node
implements INameNode {
    protected String name;

    public Colon3Node(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.COLON3NODE);
        this.name = string;
    }

    public Colon3Node(ISourcePosition iSourcePosition, NodeType nodeType, String string) {
        super(iSourcePosition, nodeType);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String string) {
        this.name = string;
    }

    public RubyModule getEnclosingModule(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return ruby.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return ruby.getObject().fastGetConstantFrom(this.name);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            RubyClass rubyClass = ruby.getObject();
            if (rubyClass.fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (rubyClass.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException jumpException) {
            // empty catch block
        }
        return null;
    }
}

