/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.ast;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyMatchData;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.ast.Node;
import org.jruby.nb.nb.ast.NodeType;
import org.jruby.nb.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.nb.evaluator.Instruction;
import org.jruby.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackRefNode
extends Node {
    private final char type;

    public BackRefNode(ISourcePosition iSourcePosition, int n) {
        super(iSourcePosition, NodeType.BACKREFNODE);
        this.type = (char)n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitBackRefNode(this);
    }

    public char getType() {
        return this.type;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = threadContext.getCurrentFrame().getBackRef();
        switch (this.type) {
            case '&': {
                return RubyRegexp.last_match(iRubyObject2);
            }
            case '`': {
                return RubyRegexp.match_pre(iRubyObject2);
            }
            case '\'': {
                return RubyRegexp.match_post(iRubyObject2);
            }
            case '+': {
                return RubyRegexp.match_last(iRubyObject2);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = threadContext.getCurrentFrame().getBackRef();
        return iRubyObject2 instanceof RubyMatchData ? "$" + this.type : null;
    }
}

