/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyException;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ObjectMarshal;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.runtime.component.VariableEntry;
import org.jruby.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"SystemCallError"}, parent="StandardError")
public class RubySystemCallError
extends RubyException {
    private IRubyObject errno = this.getRuntime().getNil();
    private static final Map<String, String> defaultMessages = new HashMap<String, String>();
    private static ObjectAllocator SYSTEM_CALL_ERROR_ALLOCATOR;
    private static final ObjectMarshal SYSTEM_CALL_ERROR_MARSHAL;

    protected RubySystemCallError(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass, null);
    }

    public RubySystemCallError(Ruby ruby, RubyClass rubyClass, String string, int n) {
        super(ruby, rubyClass, string);
        this.errno = ruby.newFixnum(n);
    }

    public static RubyClass createSystemCallErrorClass(Ruby ruby, RubyClass rubyClass) {
        RubyClass rubyClass2 = ruby.defineClass("SystemCallError", rubyClass, SYSTEM_CALL_ERROR_ALLOCATOR);
        rubyClass2.setMarshal(SYSTEM_CALL_ERROR_MARSHAL);
        ruby.callbackFactory(RubyClass.class);
        rubyClass2.defineAnnotatedMethods(RubySystemCallError.class);
        return rubyClass2;
    }

    @JRubyMethod(optional=2, required=0, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        String string;
        boolean bl;
        RubyClass rubyClass = this.getRuntime().getSystemCallError();
        RubyClass rubyClass2 = this.getMetaClass().getRealClass();
        IRubyObject iRubyObject = this.getRuntime().getNil();
        IRubyObject iRubyObject2 = this.getRuntime().getNil();
        boolean bl2 = bl = !rubyClass2.equals(rubyClass);
        if (!bl) {
            Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 1, 2);
            iRubyObject = iRubyObjectArray[0];
            if (iRubyObjectArray.length == 2) {
                iRubyObject2 = iRubyObjectArray[1];
            }
            if (iRubyObjectArray.length == 1 && iRubyObject instanceof RubyFixnum) {
                iRubyObject2 = iRubyObject;
                iRubyObject = this.getRuntime().getNil();
            }
        } else {
            Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 0, 1);
            if (iRubyObjectArray.length == 1) {
                iRubyObject = iRubyObjectArray[0];
            }
            iRubyObject2 = rubyClass2.fastGetConstant("Errno");
        }
        if (!iRubyObject2.isNil()) {
            this.errno = iRubyObject2.convertToInteger();
        }
        if ((string = defaultMessages.get(rubyClass2.getName())) == null) {
            string = "Unknown error";
        }
        if (!this.errno.isNil() && !bl) {
            string = string + " " + this.errno.toString();
        }
        if (!iRubyObject.isNil()) {
            string = string + " - " + iRubyObject.convertToString();
        }
        this.message = this.getRuntime().newString(string);
        return this;
    }

    @JRubyMethod
    public IRubyObject errno() {
        return this.errno;
    }

    static {
        defaultMessages.put("Errno::EPERM", "Operation not permitted");
        defaultMessages.put("Errno::ENOENT", "No such file or directory");
        defaultMessages.put("Errno::ESRCH", "No such process");
        defaultMessages.put("Errno::EINTR", "Interrupted system call");
        defaultMessages.put("Errno::EIO", "Input/output error");
        defaultMessages.put("Errno::ENXIO", "Device not configured");
        defaultMessages.put("Errno::E2BIG", "Argument list too long");
        defaultMessages.put("Errno::ENOEXEC", "Exec format error");
        defaultMessages.put("Errno::EBADF", "Bad file descriptor");
        defaultMessages.put("Errno::ECHILD", "No child processes");
        defaultMessages.put("Errno::EDEADLK", "Resource deadlock avoided");
        defaultMessages.put("Errno::ENOMEM", "Cannot allocate memory");
        defaultMessages.put("Errno::EACCES", "Permission denied");
        defaultMessages.put("Errno::EFAULT", "Bad address");
        defaultMessages.put("Errno::ENOTBLK", "Block device required");
        defaultMessages.put("Errno::EBUSY", "Resource busy");
        defaultMessages.put("Errno::EEXIST", "File exists");
        defaultMessages.put("Errno::EXDEV", "Cross-device link");
        defaultMessages.put("Errno::ENODEV", "Operation not supported by device");
        defaultMessages.put("Errno::ENOTDIR", "Not a directory");
        defaultMessages.put("Errno::EISDIR", "Is a directory");
        defaultMessages.put("Errno::EINVAL", "Invalid argument");
        defaultMessages.put("Errno::ENFILE", "Too many open files in system");
        defaultMessages.put("Errno::EMFILE", "Too many open files");
        defaultMessages.put("Errno::ENOTTY", "Inappropriate ioctl for device");
        defaultMessages.put("Errno::ETXTBSY", "Text file busy");
        defaultMessages.put("Errno::EFBIG", "File too large");
        defaultMessages.put("Errno::ENOSPC", "No space left on device");
        defaultMessages.put("Errno::ESPIPE", "Illegal seek");
        defaultMessages.put("Errno::EROFS", "Read-only file system");
        defaultMessages.put("Errno::EMLINK", "Too many links");
        defaultMessages.put("Errno::EPIPE", "Broken pipe");
        defaultMessages.put("Errno::EDOM", "Numerical argument out of domain");
        defaultMessages.put("Errno::ERANGE", "Result too large");
        defaultMessages.put("Errno::EAGAIN", "Resource temporarily unavailable");
        defaultMessages.put("Errno::EWOULDBLOCK", "Resource temporarily unavailable");
        defaultMessages.put("Errno::EINPROGRESS", "Operation now in progress");
        defaultMessages.put("Errno::EALREADY", "Operation already in progress");
        defaultMessages.put("Errno::ENOTSOCK", "Socket operation on non-socket");
        defaultMessages.put("Errno::EDESTADDRREQ", "Destination address required");
        defaultMessages.put("Errno::EMSGSIZE", "Message too long");
        defaultMessages.put("Errno::EPROTOTYPE", "Protocol wrong type for socket");
        defaultMessages.put("Errno::ENOPROTOOPT", "Protocol not available");
        defaultMessages.put("Errno::EPROTONOSUPPORT", "Protocol not supported");
        defaultMessages.put("Errno::ESOCKTNOSUPPORT", "Socket type not supported");
        defaultMessages.put("Errno::EPFNOSUPPORT", "Protocol family not supported");
        defaultMessages.put("Errno::EAFNOSUPPORT", "Address family not supported by protocol family");
        defaultMessages.put("Errno::EADDRINUSE", "Address already in use");
        defaultMessages.put("Errno::EADDRNOTAVAIL", "Can't assign requested address");
        defaultMessages.put("Errno::ENETDOWN", "Network is down");
        defaultMessages.put("Errno::ENETUNREACH", "Network is unreachable");
        defaultMessages.put("Errno::ENETRESET", "Network dropped connection on reset");
        defaultMessages.put("Errno::ECONNABORTED", "Software caused connection abort");
        defaultMessages.put("Errno::ECONNRESET", "Connection reset by peer");
        defaultMessages.put("Errno::ENOBUFS", "No buffer space available");
        defaultMessages.put("Errno::EISCONN", "Socket is already connected");
        defaultMessages.put("Errno::ENOTCONN", "Socket is not connected");
        defaultMessages.put("Errno::ESHUTDOWN", "Can't send after socket shutdown");
        defaultMessages.put("Errno::ETOOMANYREFS", "Too many references: can't splice");
        defaultMessages.put("Errno::ETIMEDOUT", "Operation timed out");
        defaultMessages.put("Errno::ECONNREFUSED", "Connection refused");
        defaultMessages.put("Errno::ELOOP", "Too many levels of symbolic links");
        defaultMessages.put("Errno::ENAMETOOLONG", "File name too long");
        defaultMessages.put("Errno::EHOSTDOWN", "Host is down");
        defaultMessages.put("Errno::EHOSTUNREACH", "No route to host");
        defaultMessages.put("Errno::ENOTEMPTY", "Directory not empty");
        defaultMessages.put("Errno::EUSERS", "Too many users");
        defaultMessages.put("Errno::EDQUOT", "Disc quota exceeded");
        defaultMessages.put("Errno::ESTALE", "Stale NFS file handle");
        defaultMessages.put("Errno::EREMOTE", "Too many levels of remote in path");
        defaultMessages.put("Errno::ENOLCK", "No locks available");
        defaultMessages.put("Errno::ENOSYS", "Function not implemented");
        defaultMessages.put("Errno::EOVERFLOW", "Value too large to be stored in data type");
        defaultMessages.put("Errno::EIDRM", "Identifier removed");
        defaultMessages.put("Errno::ENOMSG", "No message of desired type");
        defaultMessages.put("Errno::EILSEQ", "Illegal byte sequence");
        defaultMessages.put("Errno::EBADMSG", "Bad message");
        defaultMessages.put("Errno::EMULTIHOP", "EMULTIHOP (Reserved)");
        defaultMessages.put("Errno::ENODATA", "No message available on STREAM");
        defaultMessages.put("Errno::ENOLINK", "ENOLINK (Reserved)");
        defaultMessages.put("Errno::ENOSR", "No STREAM resources");
        defaultMessages.put("Errno::ENOSTR", "Not a STREAM");
        defaultMessages.put("Errno::EPROTO", "Protocol error");
        defaultMessages.put("Errno::ETIME", "STREAM ioctl timeout");
        defaultMessages.put("Errno::EOPNOTSUPP", "Operation not supported");
        defaultMessages.put("Errno::EOPNOTSUPP_DARWIN", "Operation not supported");
        SYSTEM_CALL_ERROR_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                RubySystemCallError rubySystemCallError = new RubySystemCallError(ruby, rubyClass);
                rubySystemCallError.setMetaClass(rubyClass);
                return rubySystemCallError;
            }
        };
        SYSTEM_CALL_ERROR_MARSHAL = new ObjectMarshal(){

            public void marshalTo(Ruby ruby, Object object, RubyClass rubyClass, MarshalStream marshalStream) throws IOException {
                RubySystemCallError rubySystemCallError = (RubySystemCallError)object;
                marshalStream.registerLinkTarget(rubySystemCallError);
                List<Variable<IRubyObject>> list = rubySystemCallError.getVariableList();
                list.add(new VariableEntry<IRubyObject>("mesg", rubySystemCallError.message == null ? ruby.getNil() : rubySystemCallError.message));
                list.add(new VariableEntry<IRubyObject>("errno", rubySystemCallError.errno));
                list.add(new VariableEntry<IRubyObject>("bt", rubySystemCallError.getBacktrace()));
                marshalStream.dumpVariables(list);
            }

            public Object unmarshalFrom(Ruby ruby, RubyClass rubyClass, UnmarshalStream unmarshalStream) throws IOException {
                RubySystemCallError rubySystemCallError = (RubySystemCallError)rubyClass.allocate();
                unmarshalStream.registerLinkTarget(rubySystemCallError);
                unmarshalStream.defaultVariablesUnmarshal(rubySystemCallError);
                rubySystemCallError.message = rubySystemCallError.removeInternalVariable("mesg");
                rubySystemCallError.errno = rubySystemCallError.removeInternalVariable("errno");
                rubySystemCallError.set_backtrace(rubySystemCallError.removeInternalVariable("bt"));
                return rubySystemCallError;
            }
        };
    }
}

