/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.NoFunctionalitySignalFacade;
import org.jruby.nb.nb.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    public static final String[] NAMES = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> clazz = Class.forName("org.jruby.nb.nb.util.SunSignalFacade");
            return (SignalFacade)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Signal");
        rubyModule.defineAnnotatedMethods(RubySignal.class);
    }

    @JRubyMethod(name={"trap"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject trap(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        ruby.getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)ruby.getKernel(), "__jtrap", iRubyObjectArray, block);
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyHash rubyHash = RubyHash.newHash(ruby);
        for (int i = 0; i < NAMES.length; ++i) {
            rubyHash.op_aset(threadContext, ruby.newString(NAMES[i]), ruby.newFixnum(i));
        }
        rubyHash.op_aset(threadContext, ruby.newString("IOT"), ruby.newFixnum(6));
        rubyHash.op_aset(threadContext, ruby.newString("CLD"), ruby.newFixnum(20));
        return rubyHash;
    }

    @JRubyMethod(name={"__jtrap_kernel"}, required=3, meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return SIGNALS.trap(iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
    }
}

