/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jruby.nb.nb.CompatVersion;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArgsFile;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyBinding;
import org.jruby.nb.nb.RubyBoolean;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyException;
import org.jruby.nb.nb.RubyFile;
import org.jruby.nb.nb.RubyFileTest;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyIO;
import org.jruby.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.RubyInteger;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNameError;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyProc;
import org.jruby.nb.nb.RubyProcess;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.RubySystemExit;
import org.jruby.nb.nb.RubyThread;
import org.jruby.nb.nb.anno.FrameField;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.ast.util.ArgsUtil;
import org.jruby.nb.nb.common.IRubyWarnings;
import org.jruby.nb.nb.evaluator.ASTInterpreter;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.exceptions.MainExitException;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.CallType;
import org.jruby.nb.nb.runtime.Frame;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.load.IAutoloadMethod;
import org.jruby.nb.nb.runtime.load.LoadService;
import org.jruby.nb.nb.util.IdUtil;
import org.jruby.nb.nb.util.ShellLauncher;
import org.jruby.nb.nb.util.TypeConverter;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Kernel");
        ruby.setKernel(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyKernel.class);
        rubyModule.defineAnnotatedMethods(RubyObject.class);
        ruby.setRespondToMethod(rubyModule.searchMethod("respond_to?"));
        rubyModule.setFlag(2048, false);
        return rubyModule;
    }

    @JRubyMethod(name={"at_exit"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getRuntime().pushExitBlock(threadContext.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : ruby.getObject();
        String string = rubyModule.getName() + "::" + iRubyObject2.asJavaString();
        IAutoloadMethod iAutoloadMethod = ruby.getLoadService().autoloadFor(string);
        if (iAutoloadMethod == null) {
            return ruby.getNil();
        }
        return ruby.newString(iAutoloadMethod.file());
    }

    @JRubyMethod(name={"autoload"}, required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject iRubyObject, IRubyObject iRubyObject2, final IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        final LoadService loadService = ruby.getLoadService();
        String string = iRubyObject2.asJavaString();
        if (!IdUtil.isValidConstantName(string)) {
            throw ruby.newNameError("autoload must be constant name", string);
        }
        RubyString rubyString = iRubyObject3.convertToString();
        if (rubyString.isEmpty()) {
            throw ruby.newArgumentError("empty file name");
        }
        final String string2 = iRubyObject2.asJavaString().intern();
        final RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : ruby.getObject();
        String string3 = rubyModule.getName() + "::" + string2;
        IRubyObject iRubyObject4 = rubyModule.fastFetchConstant(string2);
        if (iRubyObject4 != null && iRubyObject4 != RubyObject.UNDEF) {
            return ruby.getNil();
        }
        rubyModule.fastStoreConstant(string2, RubyObject.UNDEF);
        loadService.addAutoload(string3, new IAutoloadMethod(){

            public String file() {
                return iRubyObject3.toString();
            }

            public IRubyObject load(Ruby ruby, String string) {
                boolean bl = loadService.require(this.file());
                if (!bl) {
                    return null;
                }
                return rubyModule.fastGetConstant(string2);
            }
        });
        return ruby.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject[] iRubyObjectArray2;
        RubyClass rubyClass;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length == 0 || !(iRubyObjectArray[0] instanceof RubySymbol)) {
            throw ruby.newArgumentError("no id given");
        }
        Visibility visibility = threadContext.getLastVisibility();
        CallType callType = threadContext.getLastCallType();
        RubyNameError.RubyNameErrorMessage rubyNameErrorMessage = new RubyNameError.RubyNameErrorMessage(ruby, iRubyObject, iRubyObjectArray[0], visibility, callType);
        if (callType != CallType.VARIABLE) {
            rubyClass = ruby.getNoMethodError();
            iRubyObjectArray2 = new IRubyObject[]{rubyNameErrorMessage, iRubyObjectArray[0], RubyArray.newArrayNoCopy(ruby, iRubyObjectArray, 1)};
        } else {
            rubyClass = ruby.getNameError();
            iRubyObjectArray2 = new IRubyObject[]{rubyNameErrorMessage, iRubyObjectArray[0]};
        }
        throw new RaiseException((RubyException)rubyClass.newInstance(threadContext, iRubyObjectArray2, Block.NULL_BLOCK));
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string = iRubyObjectArray[0].convertToString().toString();
        Ruby ruby = threadContext.getRuntime();
        if (string.startsWith("|")) {
            String string2 = string.substring(1);
            return RubyIO.popen(threadContext, ruby.getIO(), new IRubyObject[]{ruby.newString(string2)}, block);
        }
        return RubyFile.open(threadContext, ruby.getFile(), iRubyObjectArray, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext threadContext, IRubyObject iRubyObject) {
        threadContext.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead", "getc", "STDIN.getc");
        IRubyObject iRubyObject2 = threadContext.getRuntime().getGlobalVariables().get("$stdin");
        return iRubyObject2.callMethod(threadContext, "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyArgsFile.gets(threadContext, threadContext.getRuntime().getGlobalVariables().get("$<"), iRubyObjectArray);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 1) {
            threadContext.getRuntime().getGlobalVariables().get("$stderr").callMethod(threadContext, "puts", iRubyObjectArray[0]);
        }
        throw new MainExitException(1, true);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = iRubyObject2.checkArrayType();
        if (iRubyObject3.isNil()) {
            if (iRubyObject2.getMetaClass().searchMethod("to_a").getImplementationClass() != threadContext.getRuntime().getKernel()) {
                iRubyObject3 = iRubyObject2.callMethod(threadContext, MethodIndex.TO_A, "to_a");
                if (!(iRubyObject3 instanceof RubyArray)) {
                    throw threadContext.getRuntime().newTypeError("`to_a' did not return Array");
                }
                return iRubyObject3;
            }
            return threadContext.getRuntime().newArray(iRubyObject2);
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, threadContext.getRuntime().getComplex(), "convert");
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getComplex(), "convert", iRubyObject2);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getComplex(), "convert", iRubyObject2, iRubyObject3);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, threadContext.getRuntime().getRational(), "convert");
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getRational(), "convert", iRubyObject2);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)threadContext.getRuntime().getRational(), "convert", iRubyObject2, iRubyObject3);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum) {
            return RubyFloat.newFloat(iRubyObject2.getRuntime(), ((RubyFixnum)iRubyObject2).getDoubleValue());
        }
        if (iRubyObject2 instanceof RubyFloat) {
            return iRubyObject2;
        }
        if (iRubyObject2 instanceof RubyBignum) {
            return RubyFloat.newFloat(iRubyObject2.getRuntime(), RubyBignum.big2dbl((RubyBignum)iRubyObject2));
        }
        if (iRubyObject2 instanceof RubyString) {
            if (((RubyString)iRubyObject2).getByteList().realSize == 0) {
                throw iRubyObject.getRuntime().newArgumentError("invalid value for Float(): " + iRubyObject2.inspect());
            }
            return RubyNumeric.str2fnum(iRubyObject.getRuntime(), (RubyString)iRubyObject2, true);
        }
        if (iRubyObject2.isNil()) {
            throw iRubyObject.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rubyFloat = (RubyFloat)TypeConverter.convertToType(iRubyObject2, iRubyObject.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
        if (Double.isNaN(rubyFloat.getDoubleValue())) {
            throw iRubyObject.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rubyFloat;
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3;
        if (iRubyObject2 instanceof RubyFloat) {
            double d = ((RubyFloat)iRubyObject2).getDoubleValue();
            if (d > 9.223372036854776E18 && d < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(threadContext.getRuntime(), ((RubyFloat)iRubyObject2).getDoubleValue());
            }
        } else {
            if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) {
                return iRubyObject2;
            }
            if (iRubyObject2 instanceof RubyString) {
                return RubyNumeric.str2inum(threadContext.getRuntime(), (RubyString)iRubyObject2, 0, true);
            }
        }
        if ((iRubyObject3 = TypeConverter.convertToType(iRubyObject2, threadContext.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", false)).isNil()) {
            return iRubyObject2.convertToInteger(MethodIndex.TO_I, "to_i");
        }
        return iRubyObject3;
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return TypeConverter.convertToType(iRubyObject2, threadContext.getRuntime().getString(), MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$>");
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (iRubyObjectArray[i] == null) continue;
            iRubyObject2.callMethod(threadContext, "write", RubyObject.inspect(threadContext, iRubyObjectArray[i]));
            iRubyObject2.callMethod(threadContext, "write", ruby.newString("\n"));
        }
        if (iRubyObject2 instanceof RubyFile) {
            ((RubyFile)iRubyObject2).flush();
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = threadContext.getRuntime().getGlobalVariables().get("$>");
        return iRubyObject3.callMethod(threadContext, "putc", iRubyObject2);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = threadContext.getRuntime().getGlobalVariables().get("$>");
        iRubyObject2.callMethod(threadContext, "puts", iRubyObjectArray);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = threadContext.getRuntime().getGlobalVariables().get("$>");
        iRubyObject2.callMethod(threadContext, "print", iRubyObjectArray);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length != 0) {
            IRubyObject iRubyObject2 = threadContext.getRuntime().getGlobalVariables().get("$>");
            if (!(iRubyObjectArray[0] instanceof RubyString)) {
                iRubyObject2 = iRubyObjectArray[0];
                iRubyObjectArray = ArgsUtil.popArray(iRubyObjectArray);
            }
            iRubyObject2.callMethod(threadContext, "write", RubyKernel.sprintf(iRubyObject, iRubyObjectArray));
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = RubyKernel.gets(threadContext, iRubyObject, iRubyObjectArray);
        if (iRubyObject2.isNil()) {
            throw threadContext.getRuntime().newEOFError();
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyArgsFile.readlines(threadContext, threadContext.getRuntime().getGlobalVariables().get("$<"), iRubyObjectArray);
    }

    private static RubyString getLastlineString(ThreadContext threadContext, Ruby ruby) {
        IRubyObject iRubyObject = threadContext.getPreviousFrame().getLastLine();
        if (iRubyObject.isNil()) {
            throw ruby.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(iRubyObject instanceof RubyString)) {
            throw ruby.newTypeError("$_ value need to be String (" + iRubyObject.getMetaClass().getName() + " given).");
        }
        return (RubyString)iRubyObject;
    }

    public static IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).sub_bang(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).sub_bang(threadContext, iRubyObject2, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject sub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).sub_bang(threadContext, iRubyObject2, iRubyObject3, block);
    }

    public static IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.sub_bang(threadContext, iRubyObjectArray, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.sub_bang(threadContext, iRubyObject2, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject sub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.sub_bang(threadContext, iRubyObject2, iRubyObject3, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    public static IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).gsub_bang(threadContext, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).gsub_bang(threadContext, iRubyObject2, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).gsub_bang(threadContext, iRubyObject2, iRubyObject3, block);
    }

    public static IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.gsub_bang(threadContext, iRubyObjectArray, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.gsub_bang(threadContext, iRubyObject2, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        RubyString rubyString = (RubyString)RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).dup();
        if (!rubyString.gsub_bang(threadContext, iRubyObject2, iRubyObject3, block).isNil()) {
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    @JRubyMethod(name={"chop!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chop_bang(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).chop_bang();
    }

    @JRubyMethod(name={"chop"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chop(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, threadContext.getRuntime());
        if (rubyString.getByteList().realSize > 0) {
            rubyString = (RubyString)rubyString.dup();
            rubyString.chop_bang();
            threadContext.getPreviousFrame().setLastLine(rubyString);
        }
        return rubyString;
    }

    public static IRubyObject chomp_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).chomp_bang(iRubyObjectArray);
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp_bang(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).chomp_bang();
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp_bang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).chomp_bang(iRubyObject2);
    }

    public static IRubyObject chomp(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, threadContext.getRuntime());
        RubyString rubyString2 = (RubyString)rubyString.dup();
        if (rubyString2.chomp_bang(iRubyObjectArray).isNil()) {
            return rubyString;
        }
        threadContext.getPreviousFrame().setLastLine(rubyString2);
        return rubyString2;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, threadContext.getRuntime());
        RubyString rubyString2 = (RubyString)rubyString.dup();
        if (rubyString2.chomp_bang().isNil()) {
            return rubyString;
        }
        threadContext.getPreviousFrame().setLastLine(rubyString2);
        return rubyString2;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = RubyKernel.getLastlineString(threadContext, threadContext.getRuntime());
        RubyString rubyString2 = (RubyString)rubyString.dup();
        if (rubyString2.chomp_bang(iRubyObject2).isNil()) {
            return rubyString;
        }
        threadContext.getPreviousFrame().setLastLine(rubyString2);
        return rubyString2;
    }

    public static IRubyObject split(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).split(threadContext, iRubyObjectArray);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).split(threadContext);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).split(threadContext, iRubyObject2);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).split(threadContext, iRubyObject2, iRubyObject3);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject scan(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyKernel.getLastlineString(threadContext, threadContext.getRuntime()).scan(threadContext, iRubyObject2, block);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyIO.select_static(threadContext, threadContext.getRuntime(), iRubyObjectArray);
    }

    @JRubyMethod(name={"sleep"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        long l2;
        if (iRubyObjectArray.length == 0) {
            l2 = 0L;
        } else {
            if (!(iRubyObjectArray[0] instanceof RubyNumeric)) {
                throw threadContext.getRuntime().newTypeError("can't convert " + iRubyObjectArray[0].getMetaClass().getName() + "into time interval");
            }
            l2 = (long)(iRubyObjectArray[0].convertToFloat().getDoubleValue() * 1000.0);
            if (l2 < 0L) {
                throw threadContext.getRuntime().newArgumentError("time interval must be positive");
            }
            if (l2 == 0L) {
                return threadContext.getRuntime().newFixnum(0);
            }
        }
        long l3 = System.currentTimeMillis();
        RubyThread rubyThread = threadContext.getThread();
        do {
            l = System.currentTimeMillis();
            try {
                rubyThread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
        return threadContext.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - l3) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyKernel.exit(iRubyObject.getRuntime(), iRubyObjectArray, false);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyKernel.exit(iRubyObject.getRuntime(), iRubyObjectArray, true);
        return iRubyObject.getRuntime().getNil();
    }

    private static void exit(Ruby ruby, IRubyObject[] iRubyObjectArray, boolean bl) {
        ruby.secure(4);
        int n = 1;
        if (iRubyObjectArray.length > 0) {
            RubyObject rubyObject = (RubyObject)iRubyObjectArray[0];
            if (rubyObject instanceof RubyFixnum) {
                n = RubyNumeric.fix2int(rubyObject);
            } else {
                int n2 = n = rubyObject.isFalse() ? 1 : 0;
            }
        }
        if (bl) {
            throw new MainExitException(n, true);
        }
        throw ruby.newSystemExit(n);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        for (String string : ruby.getGlobalVariables().getNames()) {
            rubyArray.append(ruby.newString(string));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        for (String string : threadContext.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(string)) continue;
            rubyArray.append(ruby.newString(string));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"binding"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBinding binding(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RubyBinding.newBinding(threadContext.getRuntime());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getRuntime().newBoolean(threadContext.getPreviousFrame().getBlock().isGiven());
    }

    @Deprecated
    public static IRubyObject sprintf(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyKernel.sprintf(iRubyObject.getRuntime().getCurrentContext(), iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString rubyString = RubyString.stringValue(iRubyObjectArray[0]);
        RubyArray rubyArray = threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray);
        rubyArray.shift();
        return rubyString.op_format(threadContext, rubyArray);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject raise(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length == 0) {
            IRubyObject iRubyObject3 = ruby.getGlobalVariables().get("$!");
            if (iRubyObject3.isNil()) {
                throw new RaiseException(ruby, ruby.getRuntimeError(), "", false);
            }
            throw new RaiseException((RubyException)iRubyObject3);
        }
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyString) {
                throw new RaiseException((RubyException)ruby.getRuntimeError().newInstance(threadContext, iRubyObjectArray, block));
            }
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                throw ruby.newTypeError("exception class/object expected");
            }
            iRubyObject2 = iRubyObjectArray[0].callMethod(threadContext, "exception");
        } else {
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                throw ruby.newTypeError("exception class/object expected");
            }
            iRubyObject2 = iRubyObjectArray[0].callMethod(threadContext, "exception", iRubyObjectArray[1]);
        }
        if (!ruby.fastGetClass("Exception").isInstance(iRubyObject2)) {
            throw ruby.newTypeError("exception object expected");
        }
        if (iRubyObjectArray.length == 3) {
            ((RubyException)iRubyObject2).set_backtrace(iRubyObjectArray[2]);
        }
        if (ruby.getDebug().isTrue()) {
            RubyKernel.printExceptionSummary(threadContext, ruby, (RubyException)iRubyObject2);
        }
        throw new RaiseException((RubyException)iRubyObject2);
    }

    private static void printExceptionSummary(ThreadContext threadContext, Ruby ruby, RubyException rubyException) {
        Frame frame = threadContext.getCurrentFrame();
        String string = String.format("Exception `%s' at %s:%s - %s\n", rubyException.getMetaClass(), frame.getFile(), frame.getLine() + 1, rubyException.to_s());
        IRubyObject iRubyObject = ruby.getGlobalVariables().get("$stderr");
        iRubyObject.callMethod(threadContext, "write", ruby.newString(string));
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        if (ruby.getLoadService().require(iRubyObject2.convertToString().toString())) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        boolean bl = iRubyObjectArray.length == 2 ? iRubyObjectArray[1].isTrue() : false;
        ruby.getLoadService().load(rubyString.getByteList().toString(), bl);
        return ruby.getTrue();
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject eval(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        Ruby ruby = threadContext.getRuntime();
        RubyString rubyString = iRubyObjectArray[0].convertToString();
        ruby.checkSafeString(rubyString);
        IRubyObject iRubyObject3 = iRubyObject2 = iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil() ? iRubyObjectArray[1] : null;
        String string = iRubyObjectArray.length > 2 ? iRubyObjectArray[2].convertToString().toString() : (iRubyObject2 == null ? "(eval)" : null);
        int n = iRubyObjectArray.length > 3 ? (int)iRubyObjectArray[3].convertToInteger().getLongValue() : (iRubyObject2 == null ? 0 : -1);
        if (iRubyObject2 == null) {
            iRubyObject2 = RubyBinding.newBindingForEval(threadContext);
        }
        return ASTInterpreter.evalWithBinding(threadContext, rubyString, iRubyObject2, string, n);
    }

    @JRubyMethod(name={"callcc"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = threadContext.getRuntime();
        ruby.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "Kernel#callcc: Continuations are not implemented in JRuby and will not work", "Kernel#callcc");
        IRubyObject iRubyObject2 = ruby.getContinuation().callMethod(threadContext, "new");
        iRubyObject2.dataWrapStruct(block);
        return block.yield(threadContext, iRubyObject2);
    }

    @JRubyMethod(name={"caller"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject caller(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        int n;
        int n2 = n = iRubyObjectArray.length > 0 ? RubyNumeric.fix2int(iRubyObjectArray[0]) : 1;
        if (n < 0) {
            throw threadContext.getRuntime().newArgumentError("negative level(" + n + ')');
        }
        return threadContext.createCallerBacktrace(threadContext.getRuntime(), n);
    }

    @JRubyMethod(name={"catch"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        IRubyObject iRubyObject3;
        CatchTarget catchTarget = new CatchTarget(iRubyObject2.asJavaString());
        try {
            threadContext.pushCatch(catchTarget);
            iRubyObject3 = block.yield(threadContext, iRubyObject2);
            Object var8_7 = null;
        }
        catch (JumpException.ThrowJump throwJump) {
            block5: {
                try {
                    if (throwJump.getTarget() != catchTarget) break block5;
                    IRubyObject iRubyObject4 = (IRubyObject)throwJump.getValue();
                    Object var8_8 = null;
                    threadContext.popCatch();
                    return iRubyObject4;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    threadContext.popCatch();
                    throw throwable;
                }
            }
            throw throwJump;
        }
        threadContext.popCatch();
        return iRubyObject3;
    }

    @JRubyMethod(name={"throw"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = threadContext.getRuntime();
        String string = iRubyObjectArray[0].asJavaString();
        CatchTarget[] catchTargetArray = threadContext.getActiveCatches();
        String string2 = "uncaught throw `" + string + "'";
        for (int i = catchTargetArray.length - 1; i >= 0; --i) {
            if (!string.equals(catchTargetArray[i].getTag())) continue;
            throw new JumpException.ThrowJump(catchTargetArray[i], iRubyObjectArray.length > 1 ? iRubyObjectArray[1] : ruby.getNil());
        }
        RubyThread rubyThread = threadContext.getThread();
        if (rubyThread == ruby.getThreadService().getMainThread()) {
            throw ruby.newNameError(string2, string);
        }
        throw ruby.newThreadError(string2 + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(rubyThread.id())));
    }

    @JRubyMethod(name={"trap"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        threadContext.getRuntime().getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "__jtrap", iRubyObjectArray, block);
    }

    @JRubyMethod(name={"warn"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (!ruby.getVerbose().isNil()) {
            IRubyObject iRubyObject3 = ruby.getGlobalVariables().get("$stderr");
            RuntimeHelpers.invoke(threadContext, iRubyObject3, "puts", iRubyObject2);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"set_trace_func"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2.isNil()) {
            threadContext.getRuntime().setTraceFunction(null);
        } else {
            if (!(iRubyObject2 instanceof RubyProc)) {
                throw threadContext.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            threadContext.getRuntime().setTraceFunction((RubyProc)iRubyObject2);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"trace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string;
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newArgumentError(0, 1);
        }
        RubyProc rubyProc = null;
        String string2 = string = iRubyObjectArray.length > 1 ? iRubyObjectArray[0].toString() : null;
        if (string.charAt(0) != '$') {
            return threadContext.getRuntime().getNil();
        }
        if (iRubyObjectArray.length == 1) {
            rubyProc = RubyProc.newProc(threadContext.getRuntime(), block, Block.Type.PROC);
        }
        if (iRubyObjectArray.length == 2) {
            rubyProc = (RubyProc)TypeConverter.convertToType(iRubyObjectArray[1], threadContext.getRuntime().getProc(), 0, "to_proc", true);
        }
        threadContext.getRuntime().getGlobalVariables().setTraceVar(string, rubyProc);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"untrace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string;
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newArgumentError(0, 1);
        }
        String string2 = string = iRubyObjectArray.length >= 1 ? iRubyObjectArray[0].toString() : null;
        if (string.charAt(0) != '$') {
            return threadContext.getRuntime().getNil();
        }
        if (iRubyObjectArray.length > 1) {
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            for (int i = 1; i < iRubyObjectArray.length; ++i) {
                if (!threadContext.getRuntime().getGlobalVariables().untraceVar(string, iRubyObjectArray[i])) continue;
                arrayList.add(iRubyObjectArray[i]);
            }
            return RubyArray.newArray(threadContext.getRuntime(), arrayList);
        }
        threadContext.getRuntime().getGlobalVariables().untraceVar(string);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"proc", "lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @Deprecated
    public static RubyProc proc(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        while (true) {
            block.yield(threadContext, threadContext.getRuntime().getNil());
            threadContext.pollThreadEvents();
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newArgumentError("wrong number of arguments");
        }
        int n = iRubyObjectArray[0] instanceof RubyFixnum ? (int)((RubyFixnum)iRubyObjectArray[0]).getLongValue() : (iRubyObjectArray[0] instanceof RubyString && ((RubyString)iRubyObjectArray[0]).getByteList().length() > 0 ? (int)((RubyString)iRubyObjectArray[0]).getByteList().charAt(0) : (int)iRubyObjectArray[0].convertToInteger().getLongValue());
        switch (n) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw threadContext.getRuntime().newArgumentError("unknown command ?" + (char)n);
            }
        }
        switch (n) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (iRubyObjectArray.length == 3) break;
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            default: {
                if (iRubyObjectArray.length == 2) break;
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
        }
        switch (n) {
            case 65: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 67: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 102: {
                return RubyFileTest.file_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 77: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 115: {
                return RubyFileTest.size_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(iRubyObject, iRubyObjectArray[1]);
            }
            case 61: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeEquals(iRubyObjectArray[2]);
            }
            case 60: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeLessThan(iRubyObjectArray[2]);
            }
            case 62: {
                return threadContext.getRuntime().newFileStat(iRubyObjectArray[1].convertToString().toString(), false).mtimeGreaterThan(iRubyObjectArray[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(iRubyObject, iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RubyString rubyString = iRubyObject2.convertToString();
        int n = ShellLauncher.runAndWait(ruby, new IRubyObject[]{rubyString}, byteArrayOutputStream);
        ruby.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, n));
        return RubyString.newString(ruby, byteArrayOutputStream.toByteArray());
    }

    @JRubyMethod(name={"srand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        long l = ruby.getRandomSeed();
        if (iRubyObjectArray.length > 0) {
            RubyInteger rubyInteger = iRubyObjectArray[0].convertToInteger(MethodIndex.TO_INT, "to_int");
            ruby.setRandomSeed(rubyInteger.getLongValue());
        } else {
            ruby.setRandomSeed(System.currentTimeMillis() ^ (long)iRubyObject.hashCode() ^ ruby.incrementRandomSeedSequence() ^ (long)ruby.getRandom().nextInt(Math.max(1, Math.abs((int)ruby.getRandomSeed()))));
        }
        ruby.getRandom().setSeed(ruby.getRandomSeed());
        return ruby.newFixnum(l);
    }

    @JRubyMethod(name={"rand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray.length == 0) {
            l = 0L;
        } else if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyBignum) {
                byte[] byArray = ((RubyBignum)iRubyObjectArray[0]).getValue().toByteArray();
                BigInteger bigInteger = new BigInteger(byArray).abs();
                byte[] byArray2 = new byte[byArray.length];
                ruby.getRandom().nextBytes(byArray2);
                BigInteger bigInteger2 = new BigInteger(byArray2).abs().mod(bigInteger);
                return new RubyBignum(ruby, bigInteger2);
            }
            RubyInteger rubyInteger = (RubyInteger)RubyKernel.new_integer(threadContext, iRubyObject, iRubyObjectArray[0]);
            l = Math.abs(rubyInteger.getLongValue());
        } else {
            throw ruby.newArgumentError("wrong # of arguments(" + iRubyObjectArray.length + " for 1)");
        }
        if (l == 0L) {
            return RubyFloat.newFloat(ruby, ruby.getRandom().nextDouble());
        }
        if (l > Integer.MAX_VALUE) {
            return ruby.newFixnum(Math.abs(ruby.getRandom().nextLong()) % l);
        }
        return ruby.newFixnum(ruby.getRandom().nextInt((int)l));
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        throw threadContext.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean system(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = threadContext.getRuntime();
        try {
            n = ShellLauncher.runAndWait(ruby, iRubyObjectArray);
        }
        catch (Exception exception) {
            n = 127;
        }
        ruby.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(ruby, n));
        return ruby.newBoolean(n == 0);
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = threadContext.getRuntime();
        try {
            n = ShellLauncher.execAndWait(ruby, iRubyObjectArray);
        }
        catch (Exception exception) {
            throw ruby.newErrnoENOENTError("cannot execute");
        }
        return RubyKernel.exit(iRubyObject, new IRubyObject[]{ruby.newFixnum(n)});
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (!RubyInstanceConfig.FORK_ENABLED) {
            throw ruby.newNotImplementedError("fork is unsafe and disabled by default on JRuby");
        }
        if (block.isGiven()) {
            int n = ruby.getPosix().fork();
            if (n == 0) {
                try {
                    block.yield(threadContext, ruby.getNil());
                }
                catch (RaiseException raiseException) {
                    if (raiseException.getException() instanceof RubySystemExit) {
                        throw raiseException;
                    }
                    return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.minus_one(ruby)});
                }
                catch (Throwable throwable) {
                    return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.minus_one(ruby)});
                }
                return RubyKernel.exit_bang(iRubyObject, new IRubyObject[]{RubyFixnum.zero(ruby)});
            }
            return ruby.newFixnum(n);
        }
        int n = ruby.getPosix().fork();
        if (n == -1) {
            return ruby.getNil();
        }
        return ruby.newFixnum(n);
    }

    @JRubyMethod(frame=true, module=true)
    public static IRubyObject tap(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        block.yield(threadContext, iRubyObject);
        return iRubyObject;
    }

    public static class CatchTarget
    implements JumpTarget {
        private final String tag;

        public CatchTarget(String string) {
            this.tag = string;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

