/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyComparable;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.BlockCallback;
import org.jruby.nb.nb.runtime.CallBlock;
import org.jruby.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.TypeConverter;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Enumerable");
        ruby.setEnumerable(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyEnumerable.class);
        return rubyModule;
    }

    public static IRubyObject callEach(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, BlockCallback blockCallback) {
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "each", CallBlock.newCallClosure(iRubyObject, ruby.getEnumerable(), Arity.noArguments(), blockCallback, threadContext));
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first_0(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        final ThreadContext threadContext2 = threadContext;
        final IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.getNil()};
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block) {
                    if (threadContext2 != threadContext) {
                        throw threadContext.getRuntime().newThreadError("Enumerable#first cannot be parallelized");
                    }
                    iRubyObjectArray[0] = iRubyObjectArray2[0];
                    throw new ExitIteration();
                }
            });
        }
        catch (ExitIteration exitIteration) {
            // empty catch block
        }
        return iRubyObjectArray[0];
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first_1(ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject iRubyObject2) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        final ThreadContext threadContext2 = threadContext;
        if (RubyNumeric.fix2int(iRubyObject2) < 0) {
            throw ruby.newArgumentError("negative index");
        }
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
                private int iter;
                {
                    this.iter = RubyNumeric.fix2int(iRubyObject2);
                }

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                    if (threadContext2 != threadContext) {
                        throw ruby.newThreadError("Enumerable#first cannot be parallelized");
                    }
                    if (this.iter-- == 0) {
                        throw new ExitIteration();
                    }
                    rubyArray.append(iRubyObjectArray[0]);
                    return ruby.getNil();
                }
            });
        }
        catch (ExitIteration exitIteration) {
            // empty catch block
        }
        return rubyArray;
    }

    @JRubyMethod(name={"to_a", "entries"})
    public static IRubyObject to_a(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        return rubyArray;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public static IRubyObject sort(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        rubyArray.sort_bang(block);
        return rubyArray;
    }

    @JRubyMethod(name={"sort_by"}, frame=true)
    public static IRubyObject sort_by(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        int n;
        final Ruby ruby = iRubyObject.getRuntime();
        final ThreadContext threadContext2 = threadContext;
        if (iRubyObject instanceof RubyArray) {
            RubyArray rubyArray = (RubyArray)iRubyObject;
            final IRubyObject[][] iRubyObjectArray = new IRubyObject[rubyArray.size()][2];
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
                AtomicInteger i = new AtomicInteger(0);

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray3, Block block2) {
                    IRubyObject[] iRubyObjectArray2 = iRubyObjectArray[this.i.getAndIncrement()];
                    iRubyObjectArray2[0] = iRubyObjectArray3[0];
                    iRubyObjectArray2[1] = block.yield(threadContext, iRubyObjectArray3[0]);
                    return ruby.getNil();
                }
            });
            Arrays.sort(iRubyObjectArray, new Comparator<IRubyObject[]>(){

                @Override
                public int compare(IRubyObject[] iRubyObjectArray, IRubyObject[] iRubyObjectArray2) {
                    return RubyFixnum.fix2int(iRubyObjectArray[1].callMethod(threadContext2, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray2[1]));
                }
            });
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[rubyArray.size()];
            for (int i = 0; i < iRubyObjectArray2.length; ++i) {
                iRubyObjectArray2[i] = iRubyObjectArray[i][0];
            }
            return ruby.newArrayNoCopy(iRubyObjectArray2);
        }
        RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        IRubyObject[][] iRubyObjectArray = new IRubyObject[rubyArray.size()][2];
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            IRubyObject iRubyObject2;
            iRubyObjectArray[n][0] = iRubyObject2 = rubyArray.eltInternal(n);
            iRubyObjectArray[n][1] = block.yield(threadContext, iRubyObject2);
        }
        Arrays.sort(iRubyObjectArray, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] iRubyObjectArray, IRubyObject[] iRubyObjectArray2) {
                return RubyFixnum.fix2int(iRubyObjectArray[1].callMethod(threadContext2, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray2[1]));
            }
        });
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            rubyArray.eltInternalSet(n, iRubyObjectArray[n][0]);
        }
        return rubyArray;
    }

    @JRubyMethod(name={"grep"}, required=1, frame=true)
    public static IRubyObject grep(ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject iRubyObject2, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                    threadContext.setRubyFrameDelta(threadContext.getRubyFrameDelta() + 2);
                    if (iRubyObject2.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObjectArray[0]).isTrue()) {
                        IRubyObject iRubyObject = block.yield(threadContext, iRubyObjectArray[0]);
                        RubyArray rubyArray2 = rubyArray;
                        synchronized (rubyArray2) {
                            rubyArray.append(iRubyObject);
                        }
                    }
                    threadContext.setRubyFrameDelta(threadContext.getRubyFrameDelta() - 2);
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                    if (iRubyObject2.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObjectArray[0]).isTrue()) {
                        RubyArray rubyArray2 = rubyArray;
                        synchronized (rubyArray2) {
                            rubyArray.append(iRubyObjectArray[0]);
                        }
                    }
                    return ruby.getNil();
                }
            });
        }
        return rubyArray;
    }

    @JRubyMethod(name={"detect", "find"}, optional=1, frame=true)
    public static IRubyObject detect(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{null};
        final ThreadContext threadContext2 = threadContext;
        IRubyObject iRubyObject2 = null;
        if (iRubyObjectArray.length == 1) {
            iRubyObject2 = iRubyObjectArray[0];
        }
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                    if (threadContext2 != threadContext) {
                        throw ruby.newThreadError("Enumerable#detect/find cannot be parallelized");
                    }
                    if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                        iRubyObjectArray2[0] = iRubyObjectArray[0];
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ruby.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            return iRubyObjectArray2[0];
        }
        return iRubyObject2 != null ? iRubyObject2.callMethod(threadContext, "call") : ruby.getNil();
    }

    @JRubyMethod(name={"select", "find_all"}, frame=true)
    public static IRubyObject select(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    RubyArray rubyArray2 = rubyArray;
                    synchronized (rubyArray2) {
                        rubyArray.append(iRubyObjectArray[0]);
                    }
                }
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public static IRubyObject reject(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                if (!block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    RubyArray rubyArray2 = rubyArray;
                    synchronized (rubyArray2) {
                        rubyArray.append(iRubyObjectArray[0]);
                    }
                }
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"collect", "map"}, frame=true)
    public static IRubyObject collect(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                    IRubyObject iRubyObject = block.yield(threadContext, iRubyObjectArray[0]);
                    RubyArray rubyArray2 = rubyArray;
                    synchronized (rubyArray2) {
                        rubyArray.append(iRubyObject);
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new AppendBlockCallback(ruby, rubyArray));
        }
        return rubyArray;
    }

    @JRubyMethod(name={"inject"}, optional=1, frame=true)
    public static IRubyObject inject(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{null};
        final ThreadContext threadContext2 = threadContext;
        if (iRubyObjectArray.length == 1) {
            iRubyObjectArray2[0] = iRubyObjectArray[0];
        }
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                if (threadContext2 != threadContext) {
                    throw ruby.newThreadError("Enumerable#inject cannot be parallelized");
                }
                iRubyObjectArray2[0] = iRubyObjectArray2[0] == null ? iRubyObjectArray[0] : block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0]), null, null, true);
                return ruby.getNil();
            }
        });
        return iRubyObjectArray2[0] == null ? ruby.getNil() : iRubyObjectArray2[0];
    }

    @JRubyMethod(name={"partition"}, frame=true)
    public static IRubyObject partition(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyArray rubyArray = ruby.newArray();
        final RubyArray rubyArray2 = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                    RubyArray rubyArray3 = rubyArray;
                    synchronized (rubyArray3) {
                        rubyArray.append(iRubyObjectArray[0]);
                    }
                }
                RubyArray rubyArray4 = rubyArray2;
                synchronized (rubyArray4) {
                    rubyArray2.append(iRubyObjectArray[0]);
                }
                return ruby.getNil();
            }
        });
        return ruby.newArray(rubyArray, rubyArray2);
    }

    @JRubyMethod(name={"each_with_index"}, frame=true)
    public static IRubyObject each_with_index(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RuntimeHelpers.invoke(threadContext, iRubyObject, "each", CallBlock.newCallClosure(iRubyObject, iRubyObject.getRuntime().getEnumerable(), Arity.noArguments(), new EachWithIndex(threadContext, block), threadContext));
        return iRubyObject;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1, frame=true)
    public static IRubyObject include_p(ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject iRubyObject2) {
        final Ruby ruby = threadContext.getRuntime();
        final ThreadContext threadContext2 = threadContext;
        try {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                    if (threadContext2 != threadContext) {
                        throw ruby.newThreadError("Enumerable#include?/member? cannot be parallelized");
                    }
                    if (RubyObject.equalInternal(threadContext, iRubyObjectArray[0], iRubyObject2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ruby.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"max"}, frame=true)
    public static IRubyObject max(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray = new IRubyObject[]{null};
        final ThreadContext threadContext2 = threadContext;
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    if (threadContext2 != threadContext) {
                        throw ruby.newThreadError("Enumerable#max{} cannot be parallelized");
                    }
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0])), iRubyObjectArray2[0], iRubyObjectArray[0]) > 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray3, Block block) {
                    IRubyObject[] iRubyObjectArray2 = iRubyObjectArray;
                    synchronized (iRubyObjectArray) {
                        if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, iRubyObjectArray3[0].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray[0]), iRubyObjectArray3[0], iRubyObjectArray[0]) > 0) {
                            iRubyObjectArray[0] = iRubyObjectArray3[0];
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return ruby.getNil();
                    }
                }
            });
        }
        return iRubyObjectArray[0] == null ? ruby.getNil() : iRubyObjectArray[0];
    }

    @JRubyMethod(name={"min"}, frame=true)
    public static IRubyObject min(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final IRubyObject[] iRubyObjectArray = new IRubyObject[]{null};
        final ThreadContext threadContext2 = threadContext;
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    if (threadContext2 != threadContext) {
                        throw ruby.newThreadError("Enumerable#min{} cannot be parallelized");
                    }
                    if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, block.yield(threadContext, ruby.newArray(iRubyObjectArray2[0], iRubyObjectArray[0])), iRubyObjectArray2[0], iRubyObjectArray[0]) < 0) {
                        iRubyObjectArray[0] = iRubyObjectArray2[0];
                    }
                    return ruby.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray3, Block block) {
                    IRubyObject[] iRubyObjectArray2 = iRubyObjectArray;
                    synchronized (iRubyObjectArray) {
                        if (iRubyObjectArray[0] == null || RubyComparable.cmpint(threadContext, iRubyObjectArray3[0].callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObjectArray[0]), iRubyObjectArray3[0], iRubyObjectArray[0]) < 0) {
                            iRubyObjectArray[0] = iRubyObjectArray3[0];
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return ruby.getNil();
                    }
                }
            });
        }
        return iRubyObjectArray[0] == null ? ruby.getNil() : iRubyObjectArray[0];
    }

    @JRubyMethod(name={"all?"}, frame=true)
    public static IRubyObject all_p(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final ThreadContext threadContext2 = threadContext;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                        if (threadContext2 != threadContext) {
                            throw ruby.newThreadError("Enumerable#all? cannot be parallelized");
                        }
                        if (!block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                        if (threadContext2 != threadContext) {
                            throw ruby.newThreadError("Enumerable#all? cannot be parallelized");
                        }
                        if (!iRubyObjectArray[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod(name={"any?"}, frame=true)
    public static IRubyObject any_p(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final ThreadContext threadContext2 = threadContext;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                        if (threadContext2 != threadContext) {
                            throw ruby.newThreadError("Enumerable#any? cannot be parallelized");
                        }
                        if (block.yield(threadContext, iRubyObjectArray[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

                    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                        if (threadContext2 != threadContext) {
                            throw ruby.newThreadError("Enumerable#any? cannot be parallelized");
                        }
                        if (iRubyObjectArray[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ruby.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump specialJump) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"zip"}, rest=true, frame=true)
    public static IRubyObject zip(ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray, final Block block) {
        int n;
        final Ruby ruby = iRubyObject.getRuntime();
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            iRubyObjectArray[n] = TypeConverter.convertToType(iRubyObjectArray[n], ruby.getArray(), MethodIndex.TO_A, "to_a");
        }
        n = iRubyObjectArray.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block2) {
                    RubyArray rubyArray = ruby.newArray(n);
                    int n3 = this.ix.getAndIncrement();
                    rubyArray.append(iRubyObjectArray2[0]);
                    int n2 = iRubyObjectArray.length;
                    for (int i = 0; i < n2; ++i) {
                        rubyArray.append(((RubyArray)iRubyObjectArray[i]).entry(n3));
                    }
                    block.yield(threadContext, rubyArray);
                    return ruby.getNil();
                }
            });
            return ruby.getNil();
        }
        final RubyArray rubyArray = ruby.newArray();
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray2, Block block) {
                RubyArray rubyArray3 = ruby.newArray(n);
                rubyArray3.append(iRubyObjectArray2[0]);
                int n3 = this.ix.getAndIncrement();
                int n2 = iRubyObjectArray.length;
                for (int i = 0; i < n2; ++i) {
                    rubyArray3.append(((RubyArray)iRubyObjectArray[i]).entry(n3));
                }
                RubyArray rubyArray2 = rubyArray;
                synchronized (rubyArray2) {
                    rubyArray.append(rubyArray3);
                }
                return ruby.getNil();
            }
        });
        return rubyArray;
    }

    @JRubyMethod(name={"group_by"}, frame=true)
    public static IRubyObject group_by(ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
        final Ruby ruby = iRubyObject.getRuntime();
        final RubyHash rubyHash = new RubyHash(ruby);
        RubyEnumerable.callEach(ruby, threadContext, iRubyObject, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block2) {
                IRubyObject iRubyObject = block.yield(threadContext, iRubyObjectArray[0]);
                RubyHash rubyHash2 = rubyHash;
                synchronized (rubyHash2) {
                    IRubyObject iRubyObject2 = rubyHash.fastARef(iRubyObject);
                    if (iRubyObject2 == null) {
                        iRubyObject2 = ruby.newArray();
                        rubyHash.fastASet(iRubyObject, iRubyObject2);
                    }
                    iRubyObject2.callMethod(threadContext, MethodIndex.OP_LSHIFT, "<<", iRubyObjectArray[0]);
                }
                return ruby.getNil();
            }
        });
        return rubyHash;
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyArray result;

        public AppendBlockCallback(Ruby ruby, RubyArray rubyArray) {
            this.runtime = ruby;
            this.result = rubyArray;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.result.append(iRubyObjectArray[0]);
            return this.runtime.getNil();
        }
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext threadContext, Block block) {
            this.block = block;
            this.runtime = threadContext.getRuntime();
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
            this.block.call(threadContext, new IRubyObject[]{this.runtime.newArray(iRubyObjectArray[0], this.runtime.newFixnum(this.index++))});
            return this.runtime.getNil();
        }
    }

    private static class ExitIteration
    extends RuntimeException {
        private ExitIteration() {
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

