/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyInteger;
import org.jruby.nb.nb.RubyMatchData;
import org.jruby.nb.nb.RubyMath;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyRational;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Frame;
import org.jruby.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Complex"}, parent="Numeric")
public class RubyComplex
extends RubyNumeric {
    private static ObjectAllocator COMPLEX_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyComplex(ruby, rubyClass, RubyFixnum.zero(ruby), RubyFixnum.zero(ruby));
        }
    };
    private IRubyObject real;
    private IRubyObject image;
    private static final boolean CL_CANNON = true;

    public static RubyClass createComplexClass(Ruby ruby) {
        String[] stringArray;
        RubyClass rubyClass = ruby.defineClass("Complex", ruby.getNumeric(), COMPLEX_ALLOCATOR);
        ruby.setComplex(rubyClass);
        rubyClass.index = 20;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyComplex;
            }
        };
        ThreadContext threadContext = ruby.getCurrentContext();
        rubyClass.callMethod(threadContext, "private_class_method", ruby.newSymbol("allocate"));
        rubyClass.defineAnnotatedMethods(RubyComplex.class);
        for (String string : stringArray = new String[]{"<", "<=", "<=>", ">", ">=", "between?", "divmod", "floor", "ceil", "modulo", "round", "step", "truncate"}) {
            rubyClass.undefineMethod(string);
        }
        rubyClass.defineConstant("I", RubyComplex.newComplexConvert(threadContext, RubyFixnum.zero(ruby), RubyFixnum.one(ruby)));
        return rubyClass;
    }

    private RubyComplex(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        super(ruby, (RubyClass)iRubyObject);
        this.real = iRubyObject2;
        this.image = iRubyObject3;
    }

    static RubyComplex newComplexRaw(Ruby ruby, IRubyObject iRubyObject, RubyObject rubyObject) {
        return new RubyComplex(ruby, ruby.getComplex(), iRubyObject, rubyObject);
    }

    static RubyComplex newComplexRaw(Ruby ruby, IRubyObject iRubyObject) {
        return new RubyComplex(ruby, ruby.getComplex(), iRubyObject, RubyFixnum.zero(ruby));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyComplex.newComplexCanonicalize(threadContext, iRubyObject, RubyFixnum.zero(threadContext.getRuntime()));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyComplex.canonicalizeInternal(threadContext, threadContext.getRuntime().getComplex(), iRubyObject, iRubyObject2);
    }

    static IRubyObject newComplexPolar(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyComplex.polar(threadContext, threadContext.getRuntime().getComplex(), iRubyObject, iRubyObject2);
    }

    static IRubyObject newComplex(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyComplex.newComplex(threadContext, iRubyObject, iRubyObject2, RubyFixnum.zero(threadContext.getRuntime()));
    }

    static IRubyObject newComplex(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (!(iRubyObject2 instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    static RubyComplex newComplexBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (iRubyObject2 instanceof RubyComplex && iRubyObject3 instanceof RubyComplex);
        return new RubyComplex(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
    }

    public static RubyComplex newComplexBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        assert (iRubyObject2 instanceof RubyComplex);
        return RubyComplex.newComplexBang(threadContext, iRubyObject, iRubyObject2, RubyFixnum.zero(threadContext.getRuntime()));
    }

    IRubyObject getImage() {
        return this.image;
    }

    IRubyObject getReal() {
        return this.real;
    }

    private static IRubyObject m_cos(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyMath.cos(iRubyObject, iRubyObject);
        }
        RubyComplex rubyComplex = (RubyComplex)iRubyObject;
        return RubyComplex.newComplex(threadContext, threadContext.getRuntime().getComplex(), Numeric.f_mul(threadContext, RubyMath.cos(iRubyObject, rubyComplex.real), RubyMath.cosh(iRubyObject, rubyComplex.image)), Numeric.f_mul(threadContext, Numeric.f_negate(threadContext, RubyMath.sin(iRubyObject, rubyComplex.real)), RubyMath.sinh(iRubyObject, rubyComplex.image)));
    }

    private static IRubyObject m_sin(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyMath.sin(iRubyObject, iRubyObject);
        }
        RubyComplex rubyComplex = (RubyComplex)iRubyObject;
        return RubyComplex.newComplex(threadContext, threadContext.getRuntime().getComplex(), Numeric.f_mul(threadContext, RubyMath.sin(iRubyObject, rubyComplex.real), RubyMath.cosh(iRubyObject, rubyComplex.image)), Numeric.f_mul(threadContext, RubyMath.cos(iRubyObject, rubyComplex.real), RubyMath.sinh(iRubyObject, rubyComplex.image)));
    }

    private static IRubyObject m_sqrt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            if (!Numeric.f_negative_p(threadContext, iRubyObject)) {
                return RubyMath.sqrt(iRubyObject, iRubyObject);
            }
            return RubyComplex.newComplex(threadContext, threadContext.getRuntime().getComplex(), RubyFixnum.zero(threadContext.getRuntime()), RubyMath.sqrt(iRubyObject, Numeric.f_negate(threadContext, iRubyObject)));
        }
        RubyComplex rubyComplex = (RubyComplex)iRubyObject;
        if (Numeric.f_negative_p(threadContext, rubyComplex.image)) {
            return Numeric.f_conjugate(threadContext, RubyComplex.m_sqrt(threadContext, Numeric.f_conjugate(threadContext, iRubyObject)));
        }
        IRubyObject iRubyObject2 = Numeric.f_abs(threadContext, iRubyObject);
        RubyFixnum rubyFixnum = RubyFixnum.two(threadContext.getRuntime());
        return RubyComplex.newComplex(threadContext, threadContext.getRuntime().getComplex(), RubyMath.sqrt(iRubyObject, Numeric.f_div(threadContext, Numeric.f_add(threadContext, iRubyObject2, rubyComplex.real), rubyFixnum)), RubyMath.sqrt(iRubyObject, Numeric.f_div(threadContext, Numeric.f_sub(threadContext, iRubyObject2, rubyComplex.real), rubyFixnum)));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return RubyComplex.newInstanceBang(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyComplex.newInstanceBang(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!(iRubyObject2 instanceof RubyNumeric)) {
            iRubyObject2 = Numeric.f_to_i(threadContext, iRubyObject2);
        }
        return new RubyComplex(threadContext.getRuntime(), iRubyObject, iRubyObject2, RubyFixnum.zero(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (!(iRubyObject2 instanceof RubyNumeric)) {
            iRubyObject2 = Numeric.f_to_i(threadContext, iRubyObject2);
        }
        if (!(iRubyObject3 instanceof RubyNumeric)) {
            iRubyObject3 = Numeric.f_to_i(threadContext, iRubyObject3);
        }
        return new RubyComplex(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static void realCheck(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: 
            case 21: {
                break;
            }
            default: {
                if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) break;
                throw threadContext.getRuntime().newArgumentError("not a real");
            }
        }
    }

    private static IRubyObject canonicalizeInternal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (Numeric.f_zero_p(threadContext, iRubyObject3) && ((RubyModule)iRubyObject).fastHasConstant("Unify") && !(iRubyObject2 instanceof RubyFloat) && !(iRubyObject3 instanceof RubyFloat)) {
            return iRubyObject2;
        }
        if (Numeric.f_scalar_p(threadContext, iRubyObject2).isTrue() && Numeric.f_scalar_p(threadContext, iRubyObject3).isTrue()) {
            return new RubyComplex(threadContext.getRuntime(), iRubyObject, iRubyObject2, iRubyObject3);
        }
        if (Numeric.f_scalar_p(threadContext, iRubyObject2).isTrue()) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject3;
            return new RubyComplex(threadContext.getRuntime(), iRubyObject, Numeric.f_sub(threadContext, iRubyObject2, rubyComplex.image), Numeric.f_add(threadContext, RubyFixnum.zero(threadContext.getRuntime()), rubyComplex.real));
        }
        if (Numeric.f_scalar_p(threadContext, iRubyObject3).isTrue()) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject2;
            return new RubyComplex(threadContext.getRuntime(), iRubyObject, rubyComplex.real, Numeric.f_add(threadContext, rubyComplex.image, iRubyObject3));
        }
        RubyComplex rubyComplex = (RubyComplex)iRubyObject2;
        RubyComplex rubyComplex2 = (RubyComplex)iRubyObject3;
        return new RubyComplex(threadContext.getRuntime(), iRubyObject, Numeric.f_sub(threadContext, rubyComplex.real, rubyComplex2.image), Numeric.f_add(threadContext, rubyComplex.image, rubyComplex2.real));
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return RubyComplex.newInstance(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyComplex.newInstance(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new", "rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyComplex.realCheck(threadContext, iRubyObject2);
        return RubyComplex.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, RubyFixnum.zero(threadContext.getRuntime()));
    }

    @JRubyMethod(name={"new", "rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyComplex.realCheck(threadContext, iRubyObject2);
        RubyComplex.realCheck(threadContext, iRubyObject3);
        return RubyComplex.canonicalizeInternal(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject f_complex_polar(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        assert (!(iRubyObject2 instanceof RubyComplex) && !(iRubyObject3 instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(threadContext, iRubyObject, Numeric.f_mul(threadContext, iRubyObject2, RubyComplex.m_cos(threadContext, iRubyObject3)), Numeric.f_mul(threadContext, iRubyObject2, RubyComplex.m_sin(threadContext, iRubyObject3)));
    }

    @JRubyMethod(name={"polar"}, meta=true)
    public static IRubyObject polar(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RubyComplex.f_complex_polar(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    public static IRubyObject newComplexConvert(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyComplex.newComplexConvert(threadContext, iRubyObject, RubyFixnum.zero(threadContext.getRuntime()));
    }

    public static IRubyObject newComplexConvert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyComplex.convert(threadContext, threadContext.getRuntime().getComplex(), iRubyObject, iRubyObject2);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return RubyComplex.convert(threadContext, iRubyObject);
            }
            case 1: {
                return RubyComplex.convert(threadContext, iRubyObject, iRubyObjectArray[0]);
            }
            case 2: {
                return RubyComplex.convert(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
        }
        Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = threadContext.getRuntime().getNil();
        return RubyComplex.convertCommon(threadContext, iRubyObject, iRubyObject2, iRubyObject2);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyComplex.convertCommon(threadContext, iRubyObject, iRubyObject2, threadContext.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return RubyComplex.convertCommon(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private static IRubyObject convertCommon(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyComplex rubyComplex;
        Frame frame = threadContext.getCurrentFrame();
        IRubyObject iRubyObject4 = frame.getBackRef();
        if (iRubyObject4 != null && iRubyObject4 instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject4).use();
        }
        if (iRubyObject2 instanceof RubyString) {
            iRubyObject2 = RubyComplex.str_to_c_strict(threadContext, iRubyObject2);
        }
        if (iRubyObject3 instanceof RubyString) {
            iRubyObject3 = RubyComplex.str_to_c_strict(threadContext, iRubyObject3);
        }
        frame.setBackRef(iRubyObject4);
        if (iRubyObject2 instanceof RubyComplex) {
            rubyComplex = (RubyComplex)iRubyObject2;
            if (!(rubyComplex.image instanceof RubyFloat) && Numeric.f_zero_p(threadContext, rubyComplex.image)) {
                iRubyObject2 = rubyComplex.real;
            }
        }
        if (iRubyObject3 instanceof RubyComplex) {
            rubyComplex = (RubyComplex)iRubyObject3;
            if (!(rubyComplex.image instanceof RubyFloat) && Numeric.f_zero_p(threadContext, rubyComplex.image)) {
                iRubyObject3 = rubyComplex.real;
            }
        }
        if (iRubyObject2 instanceof RubyComplex && (iRubyObject3.isNil() || Numeric.f_zero_p(threadContext, iRubyObject3))) {
            return iRubyObject2;
        }
        return iRubyObject3.isNil() ? RubyComplex.newInstance(threadContext, iRubyObject, iRubyObject2) : RubyComplex.newInstance(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
    }

    @JRubyMethod(name={"real"})
    public IRubyObject real() {
        return this.real;
    }

    @JRubyMethod(name={"image", "imag"})
    public IRubyObject image() {
        return this.image;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyComplex) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_add(threadContext, this.real, rubyComplex.real), Numeric.f_add(threadContext, this.image, rubyComplex.image));
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_add(threadContext, this.real, iRubyObject), this.image);
        }
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyComplex) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_sub(threadContext, this.real, rubyComplex.real), Numeric.f_sub(threadContext, this.image, rubyComplex.image));
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_sub(threadContext, this.real, iRubyObject), this.image);
        }
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyComplex) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            IRubyObject iRubyObject2 = Numeric.f_sub(threadContext, Numeric.f_mul(threadContext, this.real, rubyComplex.real), Numeric.f_mul(threadContext, this.image, rubyComplex.image));
            IRubyObject iRubyObject3 = Numeric.f_add(threadContext, Numeric.f_mul(threadContext, this.real, rubyComplex.image), Numeric.f_mul(threadContext, this.image, rubyComplex.real));
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), iRubyObject2, iRubyObject3);
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_mul(threadContext, this.real, iRubyObject), Numeric.f_mul(threadContext, this.image, iRubyObject));
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyComplex) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            if (this.real instanceof RubyFloat || this.image instanceof RubyFloat || rubyComplex.real instanceof RubyFloat || rubyComplex.image instanceof RubyFloat) {
                RubyFloat rubyFloat = RubyMath.hypot(this, rubyComplex.real, rubyComplex.image);
                RubyComplex rubyComplex2 = RubyComplex.newComplexBang(threadContext, this.getMetaClass(), Numeric.f_quo(threadContext, rubyComplex.real, rubyFloat), Numeric.f_quo(threadContext, rubyComplex.image, rubyFloat));
                return Numeric.f_quo(threadContext, Numeric.f_mul(threadContext, this, Numeric.f_conjugate(threadContext, rubyComplex2)), rubyFloat);
            }
            return Numeric.f_quo(threadContext, Numeric.f_mul(threadContext, this, Numeric.f_conjugate(threadContext, iRubyObject)), Numeric.f_abs2(threadContext, iRubyObject));
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_quo(threadContext, this.real, iRubyObject), Numeric.f_quo(threadContext, this.image, iRubyObject));
        }
        return this.coerceBin(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"fdiv", "quo"})
    public IRubyObject fdiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_to_f(threadContext, this.real), Numeric.f_to_f(threadContext, this.image));
        return Numeric.f_div(threadContext, iRubyObject2, iRubyObject);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (Numeric.f_zero_p(threadContext, iRubyObject)) {
            return RubyComplex.newComplexBang(threadContext, this.getMetaClass(), RubyFixnum.one(threadContext.getRuntime()));
        }
        if (iRubyObject instanceof RubyRational && Numeric.f_one_p(threadContext, Numeric.f_denominator(threadContext, iRubyObject))) {
            iRubyObject = Numeric.f_numerator(threadContext, iRubyObject);
        }
        if (iRubyObject instanceof RubyComplex) {
            RubyArray rubyArray = Numeric.f_polar(threadContext, this).convertToArray();
            IRubyObject iRubyObject2 = rubyArray.eltInternal(0);
            IRubyObject iRubyObject3 = rubyArray.eltInternal(1);
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            RubyFloat rubyFloat = RubyMath.exp(this, Numeric.f_sub(threadContext, Numeric.f_mul(threadContext, rubyComplex.real, RubyMath.log(this, iRubyObject2)), Numeric.f_mul(threadContext, rubyComplex.image, iRubyObject3)));
            IRubyObject iRubyObject4 = Numeric.f_add(threadContext, Numeric.f_mul(threadContext, iRubyObject3, rubyComplex.real), Numeric.f_mul(threadContext, rubyComplex.image, RubyMath.log(this, iRubyObject2)));
            return RubyComplex.polar(threadContext, this.getMetaClass(), rubyFloat, iRubyObject4);
        }
        if (iRubyObject instanceof RubyInteger) {
            RubyFixnum rubyFixnum = RubyFixnum.one(threadContext.getRuntime());
            if (Numeric.f_gt_p(threadContext, iRubyObject, RubyFixnum.zero(threadContext.getRuntime())).isTrue()) {
                IRubyObject iRubyObject5;
                IRubyObject iRubyObject6 = iRubyObject5 = this;
                IRubyObject iRubyObject7 = Numeric.f_sub(threadContext, iRubyObject, rubyFixnum);
                RubyFixnum rubyFixnum2 = RubyFixnum.two(threadContext.getRuntime());
                while (!Numeric.f_zero_p(threadContext, iRubyObject7)) {
                    RubyArray rubyArray = Numeric.f_divmod(threadContext, iRubyObject7, rubyFixnum2).convertToArray();
                    while (Numeric.f_zero_p(threadContext, rubyArray.eltInternal(1))) {
                        RubyComplex rubyComplex = iRubyObject5;
                        iRubyObject5 = RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_sub(threadContext, Numeric.f_mul(threadContext, rubyComplex.real, rubyComplex.real), Numeric.f_mul(threadContext, rubyComplex.image, rubyComplex.image)), Numeric.f_mul(threadContext, Numeric.f_mul(threadContext, rubyFixnum2, rubyComplex.real), rubyComplex.image));
                        iRubyObject7 = rubyArray.eltInternal(0);
                        rubyArray = Numeric.f_divmod(threadContext, iRubyObject7, rubyFixnum2).convertToArray();
                    }
                    iRubyObject6 = Numeric.f_mul(threadContext, iRubyObject6, iRubyObject5);
                    iRubyObject7 = Numeric.f_sub(threadContext, iRubyObject7, rubyFixnum);
                }
                return iRubyObject6;
            }
            return Numeric.f_expt(threadContext, Numeric.f_div(threadContext, Numeric.f_to_r(threadContext, rubyFixnum), this), Numeric.f_negate(threadContext, iRubyObject));
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            RubyArray rubyArray = Numeric.f_polar(threadContext, this).convertToArray();
            IRubyObject iRubyObject8 = rubyArray.eltInternal(0);
            IRubyObject iRubyObject9 = rubyArray.eltInternal(1);
            return RubyComplex.f_complex_polar(threadContext, this.getMetaClass(), Numeric.f_expt(threadContext, iRubyObject8, iRubyObject), Numeric.f_mul(threadContext, iRubyObject9, iRubyObject));
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyComplex) {
            RubyComplex rubyComplex = (RubyComplex)iRubyObject;
            if (Numeric.f_equal_p(threadContext, this.real, rubyComplex.real) && Numeric.f_equal_p(threadContext, this.image, rubyComplex.image)) {
                return threadContext.getRuntime().getTrue();
            }
            return threadContext.getRuntime().getFalse();
        }
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            if (Numeric.f_equal_p(threadContext, this.real, iRubyObject) && Numeric.f_zero_p(threadContext, this.image)) {
                return threadContext.getRuntime().getTrue();
            }
            return threadContext.getRuntime().getFalse();
        }
        return Numeric.f_equal_p(threadContext, iRubyObject, this) ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNumeric && Numeric.f_scalar_p(threadContext, iRubyObject).isTrue()) {
            return threadContext.getRuntime().newArray(RubyComplex.newComplexBang(threadContext, this.getMetaClass(), iRubyObject), this);
        }
        throw threadContext.getRuntime().newTypeError(iRubyObject.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
    }

    @JRubyMethod(name={"abs", "magnitude"})
    public IRubyObject abs(ThreadContext threadContext) {
        return RubyMath.hypot(this, this.real, this.image);
    }

    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext threadContext) {
        return Numeric.f_add(threadContext, Numeric.f_mul(threadContext, this.real, this.real), Numeric.f_mul(threadContext, this.image, this.image));
    }

    @JRubyMethod(name={"arg", "angle"})
    public IRubyObject arg(ThreadContext threadContext) {
        return RubyMath.atan2(this, this.image, this.real);
    }

    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext threadContext) {
        return threadContext.getRuntime().newArray(Numeric.f_abs(threadContext, this), Numeric.f_arg(threadContext, this));
    }

    @JRubyMethod(name={"conjugate", "conj", "~"})
    public IRubyObject conjugate(ThreadContext threadContext) {
        return RubyComplex.newComplex(threadContext, this.getMetaClass(), this.real, Numeric.f_negate(threadContext, this.image));
    }

    public IRubyObject real_p(ThreadContext threadContext) {
        return threadContext.getRuntime().getFalse();
    }

    public IRubyObject complex_p(ThreadContext threadContext) {
        return threadContext.getRuntime().getTrue();
    }

    public IRubyObject exact_p(ThreadContext threadContext) {
        return Numeric.f_exact_p(threadContext, this.real).isTrue() && Numeric.f_exact_p(threadContext, this.image).isTrue() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    public IRubyObject inexact_p(ThreadContext threadContext) {
        return this.exact_p(threadContext).isTrue() ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject demoninator(ThreadContext threadContext) {
        return Numeric.f_lcm(threadContext, Numeric.f_denominator(threadContext, this.real), Numeric.f_denominator(threadContext, this.image));
    }

    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext threadContext) {
        IRubyObject iRubyObject = this.callMethod(threadContext, "denominator");
        return RubyComplex.newComplex(threadContext, this.getMetaClass(), Numeric.f_mul(threadContext, Numeric.f_numerator(threadContext, this.real), Numeric.f_div(threadContext, iRubyObject, Numeric.f_denominator(threadContext, this.real))), Numeric.f_mul(threadContext, Numeric.f_numerator(threadContext, this.image), Numeric.f_div(threadContext, iRubyObject, Numeric.f_denominator(threadContext, this.image))));
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext threadContext) {
        return Numeric.f_xor(threadContext, this.real, this.image);
    }

    private static boolean signbit(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFloat) {
            return Double.doubleToLongBits(((RubyFloat)iRubyObject).getDoubleValue()) < 0L;
        }
        return Numeric.f_negative_p(threadContext, iRubyObject);
    }

    private static boolean tpositive_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        return !RubyComplex.signbit(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext threadContext) {
        boolean bl = RubyComplex.tpositive_p(threadContext, this.image);
        RubyString rubyString = Numeric.f_to_s(threadContext, this.real).convertToString();
        rubyString.cat(bl ? (byte)43 : 45);
        rubyString.cat(Numeric.f_to_s(threadContext, Numeric.f_abs(threadContext, this.image)).convertToString().getByteList());
        rubyString.cat((byte)105);
        return rubyString;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext threadContext) {
        boolean bl = RubyComplex.tpositive_p(threadContext, this.image);
        RubyString rubyString = threadContext.getRuntime().newString();
        rubyString.cat((byte)40);
        rubyString.cat(Numeric.f_inspect(threadContext, this.real).convertToString().getByteList());
        rubyString.cat(bl ? (byte)43 : 45);
        rubyString.cat(Numeric.f_inspect(threadContext, Numeric.f_abs(threadContext, this.image)).convertToString().getByteList());
        rubyString.cat((byte)105);
        rubyString.cat((byte)41);
        return rubyString;
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext threadContext) {
        return threadContext.getRuntime().newArray(this.real, this.image);
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.convertToArray();
        this.real = rubyArray.size() > 0 ? rubyArray.eltInternal(0) : threadContext.getRuntime().getNil();
        this.image = rubyArray.size() > 1 ? rubyArray.eltInternal(1) : threadContext.getRuntime().getNil();
        return this;
    }

    @JRubyMethod(name={"scalar?"})
    public IRubyObject scalar_p(ThreadContext threadContext) {
        return threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext threadContext) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(threadContext, this.image)) {
            throw threadContext.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(threadContext, this).convertToString() + " into Integer");
        }
        return Numeric.f_to_i(threadContext, this.real);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext threadContext) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(threadContext, this.image)) {
            throw threadContext.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(threadContext, this).convertToString() + " into Float");
        }
        return Numeric.f_to_f(threadContext, this.real);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext threadContext) {
        if (this.image instanceof RubyFloat || !Numeric.f_zero_p(threadContext, this.image)) {
            throw threadContext.getRuntime().newRangeError("can't convert " + Numeric.f_to_s(threadContext, this).convertToString() + " into Rational");
        }
        return Numeric.f_to_r(threadContext, this.real);
    }

    static RubyArray str_to_c_internal(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        IRubyObject iRubyObject3;
        RubyString rubyString = iRubyObject.callMethod(threadContext, "strip").convertToString();
        ByteList byteList = rubyString.getByteList();
        Ruby ruby = threadContext.getRuntime();
        if (byteList.realSize == 0) {
            return ruby.newArray(ruby.getNil(), iRubyObject);
        }
        IRubyObject iRubyObject4 = iRubyObject3 = ruby.getNil();
        IRubyObject iRubyObject5 = iRubyObject3;
        boolean bl = false;
        IRubyObject iRubyObject6 = RubyRegexp.newRegexp(ruby, Numeric.ComplexPatterns.comp_pat0).callMethod(threadContext, "match", rubyString);
        if (!iRubyObject6.isNil()) {
            iRubyObject5 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.one(ruby));
            iRubyObject4 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.two(ruby));
            iRubyObject3 = iRubyObject6.callMethod(threadContext, "post_match");
            bl = true;
        }
        if (iRubyObject6.isNil() && !(iRubyObject6 = RubyRegexp.newRegexp(ruby, Numeric.ComplexPatterns.comp_pat1).callMethod(threadContext, "match", rubyString)).isNil()) {
            iRubyObject5 = ruby.getNil();
            iRubyObject4 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.one(ruby));
            if (iRubyObject4.isNil()) {
                iRubyObject4 = ruby.newString();
            }
            if ((iRubyObject2 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.two(ruby))).isNil()) {
                iRubyObject2 = ruby.newString(new ByteList(new byte[]{49}));
            }
            iRubyObject4.convertToString().cat(iRubyObject2.convertToString().getByteList());
            iRubyObject3 = iRubyObject6.callMethod(threadContext, "post_match");
            bl = false;
        }
        if (iRubyObject6.isNil()) {
            iRubyObject6 = RubyRegexp.newRegexp(ruby, Numeric.ComplexPatterns.comp_pat2).callMethod(threadContext, "match", rubyString);
            if (iRubyObject6.isNil()) {
                return ruby.newArray(ruby.getNil(), iRubyObject);
            }
            iRubyObject5 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.one(ruby));
            if (iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.two(ruby)).isNil()) {
                iRubyObject4 = ruby.getNil();
            } else {
                iRubyObject4 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.three(ruby));
                iRubyObject2 = iRubyObject6.callMethod(threadContext, "[]", RubyFixnum.four(ruby));
                if (iRubyObject2.isNil()) {
                    iRubyObject2 = ruby.newString(new ByteList(new byte[]{49}));
                }
                iRubyObject4.convertToString().cat(iRubyObject2.convertToString().getByteList());
            }
            iRubyObject3 = iRubyObject6.callMethod(threadContext, "post_match");
            bl = false;
        }
        iRubyObject2 = RubyFixnum.zero(ruby);
        IRubyObject iRubyObject7 = iRubyObject2;
        if (!iRubyObject5.isNil()) {
            iRubyObject2 = iRubyObject5.callMethod(threadContext, "include?", ruby.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(threadContext, iRubyObject5) : (Numeric.f_gt_p(threadContext, iRubyObject5.callMethod(threadContext, "count", ruby.newString(".eE")), RubyFixnum.zero(ruby)).isTrue() ? Numeric.f_to_f(threadContext, iRubyObject5) : Numeric.f_to_i(threadContext, iRubyObject5));
        }
        if (!iRubyObject4.isNil()) {
            iRubyObject7 = iRubyObject4.callMethod(threadContext, "include?", ruby.newString(new ByteList(new byte[]{47}))).isTrue() ? Numeric.f_to_r(threadContext, iRubyObject4) : (Numeric.f_gt_p(threadContext, iRubyObject4.callMethod(threadContext, "count", ruby.newString(".eE")), RubyFixnum.zero(ruby)).isTrue() ? Numeric.f_to_f(threadContext, iRubyObject4) : Numeric.f_to_i(threadContext, iRubyObject4));
        }
        return ruby.newArray(bl ? RubyComplex.newComplexPolar(threadContext, iRubyObject2, iRubyObject7) : RubyComplex.newComplexCanonicalize(threadContext, iRubyObject2, iRubyObject7), iRubyObject3);
    }

    private static IRubyObject str_to_c_strict(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyArray rubyArray = RubyComplex.str_to_c_internal(threadContext, iRubyObject);
        if (rubyArray.eltInternal(0).isNil() || rubyArray.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "inspect");
            throw threadContext.getRuntime().newArgumentError("invalid value for Complex: " + iRubyObject2.convertToString());
        }
        return rubyArray.eltInternal(0);
    }
}

