/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import java.io.Serializable;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyThread;
import org.jruby.nb.RubyThreadGroup;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.exceptions.ThreadKill;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame currentFrame;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] iRubyObjectArray, Block block) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext threadContext = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, block);
        this.currentFrame = threadContext.getCurrentFrame();
        this.arguments = iRubyObjectArray;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block39: {
            ClassLoader classLoader;
            ThreadContext threadContext;
            block37: {
                this.javaThread = Thread.currentThread();
                threadContext = this.runtime.getThreadService().registerNewThread(this.rubyThread);
                classLoader = null;
                try {
                    classLoader = this.javaThread.getContextClassLoader();
                    this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
                }
                catch (SecurityException securityException) {
                    if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block37;
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
            }
            threadContext.preRunThread(this.currentFrame);
            IRubyObject iRubyObject = this.proc.call(threadContext, this.arguments);
            this.rubyThread.cleanTerminate(iRubyObject);
            Object var7_9 = null;
            this.runtime.getThreadService().setCritical(false);
            this.runtime.getThreadService().unregisterThread(this.rubyThread);
            Serializable serializable2222 = this.rubyThread;
            synchronized (serializable2222) {
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
            }
            try {
                this.javaThread.setContextClassLoader(classLoader);
            }
            catch (SecurityException serializable2222) {
                if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
                break block39;
            }
            {
                catch (ThreadKill threadKill) {
                    Object object = this.rubyThread.killLock;
                    synchronized (object) {
                        this.rubyThread.killLock.notifyAll();
                    }
                    Object var7_10 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    Serializable serializable32222 = this.rubyThread;
                    synchronized (serializable32222) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(classLoader);
                    }
                    catch (SecurityException serializable32222) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (JumpException.ReturnJump returnJump) {
                    this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
                    Object var7_11 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    Serializable serializable42222 = this.rubyThread;
                    synchronized (serializable42222) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(classLoader);
                    }
                    catch (SecurityException serializable42222) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (RaiseException raiseException) {
                    this.rubyThread.exceptionRaised(raiseException);
                    Object var7_12 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    Serializable serializable52222 = this.rubyThread;
                    synchronized (serializable52222) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(classLoader);
                    }
                    catch (SecurityException serializable52222) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (MainExitException mainExitException) {
                    this.runtime.getThreadService().getMainThread().kill();
                    Object var7_13 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    Serializable serializable62222 = this.rubyThread;
                    synchronized (serializable62222) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(classLoader);
                    }
                    catch (SecurityException serializable62222) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block44: {
                    Object var7_14 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    Serializable serializable72222 = this.rubyThread;
                    synchronized (serializable72222) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(classLoader);
                    }
                    catch (SecurityException serializable72222) {
                        if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block44;
                        System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                    }
                }
                throw throwable;
            }
        }
    }
}

