/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.ChannelStream;

@JRubyClass(name={"Net::BufferedIO"})
public class NetProtocolBufferedIO {
    public static void create(Ruby ruby) {
        RubyModule rubyModule = ruby.getModule("Net");
        RubyClass rubyClass = (RubyClass)rubyModule.getConstant("BufferedIO");
        rubyClass.defineAnnotatedMethods(NetProtocolBufferedIO.class);
        RubyModule rubyModule2 = rubyClass.defineModuleUnder("NativeImplementation");
        rubyModule2.defineAnnotatedMethods(NativeImpl.class);
    }

    @JRubyMethod(required=1)
    public static IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyIO && ((RubyIO)iRubyObject2).getOpenFile().getMainStream() instanceof ChannelStream && ((ChannelStream)((RubyIO)iRubyObject2).getOpenFile().getMainStream()).getDescriptor().getChannel() instanceof SelectableChannel) {
            ((RubyObject)iRubyObject).extend(new IRubyObject[]{((RubyModule)iRubyObject.getRuntime().getModule("Net").getConstant("BufferedIO")).getConstant("NativeImplementation")});
            SelectableChannel selectableChannel = (SelectableChannel)((ChannelStream)((RubyIO)iRubyObject2).getOpenFile().getMainStream()).getDescriptor().getChannel();
            iRubyObject.dataWrapStruct(new NativeImpl(selectableChannel));
        }
        iRubyObject.getInstanceVariables().setInstanceVariable("@io", iRubyObject2);
        iRubyObject.getInstanceVariables().setInstanceVariable("@read_timeout", iRubyObject.getRuntime().newFixnum(60));
        iRubyObject.getInstanceVariables().setInstanceVariable("@debug_output", iRubyObject.getRuntime().getNil());
        iRubyObject.getInstanceVariables().setInstanceVariable("@rbuf", RubyString.newEmptyString(iRubyObject.getRuntime()));
        return iRubyObject;
    }

    @JRubyModule(name={"Net::BufferedIO::NativeImplementation"})
    public static class NativeImpl {
        private SelectableChannel channel;

        public NativeImpl(SelectableChannel selectableChannel) {
            this.channel = selectableChannel;
        }

        @JRubyMethod
        public static IRubyObject rbuf_fill(IRubyObject iRubyObject) {
            RubyString rubyString = (RubyString)iRubyObject.getInstanceVariables().getInstanceVariable("@rbuf");
            RubyIO rubyIO = (RubyIO)iRubyObject.getInstanceVariables().getInstanceVariable("@io");
            int n = RubyNumeric.fix2int(iRubyObject.getInstanceVariables().getInstanceVariable("@read_timeout")) * 1000;
            NativeImpl nativeImpl = (NativeImpl)iRubyObject.dataGetStruct();
            Selector selector = null;
            try {
                selector = Selector.open();
                nativeImpl.channel.configureBlocking(false);
                SelectionKey selectionKey = nativeImpl.channel.register(selector, 1);
                int n2 = selector.select(n);
                if (n2 > 0) {
                    IRubyObject iRubyObject2 = rubyIO.read(new IRubyObject[]{iRubyObject.getRuntime().newFixnum(16384)});
                    RubyString rubyString2 = rubyString.concat(iRubyObject2);
                    return rubyString2;
                }
                try {
                    RubyClass rubyClass = (RubyClass)iRubyObject.getRuntime().getModule("Timeout").getConstant("Error");
                    throw new RaiseException(RubyException.newException(iRubyObject.getRuntime(), rubyClass, "execution expired"), false);
                }
                catch (IOException iOException) {
                    throw iRubyObject.getRuntime().newIOErrorFromException(iOException);
                }
            }
            finally {
                if (selector != null) {
                    try {
                        selector.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

