/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewlineNode
extends Node {
    private final Node nextNode;

    public NewlineNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.NEWLINENODE);
        assert (node != null) : "nextNode is not null";
        this.nextNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitNewlineNode(this);
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    @Override
    public List<Node> childNodes() {
        return NewlineNode.createList(this.nextNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        ISourcePosition iSourcePosition = this.getPosition();
        threadContext.setFile(iSourcePosition.getFile());
        threadContext.setLine(iSourcePosition.getStartLine());
        if (ruby.hasEventHooks()) {
            ASTInterpreter.callTraceFunction(ruby, threadContext, RubyEvent.LINE);
        }
        return this.nextNode.interpret(ruby, threadContext, iRubyObject, block);
    }

    @Override
    public String toString() {
        return "NewlineNode\n  " + this.getNextNode().toString();
    }
}

