/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAnalyzer
extends JsAnalyzer {
    @Override
    public List<? extends StructureItem> scan(CompilationInfo compilationInfo) {
        Node node;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        JsAnalyzer.AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<StructureItem> arrayList = new ArrayList<StructureItem>(list.size());
        if (JsUtils.isJsonFile(compilationInfo.getFileObject()) && jsParseResult.getRootNode() != null && (node = jsParseResult.getRootNode().getFirstChild()) != null && node.getType() == 64) {
            assert (jsParseResult.getTranslatedSource() == null);
            this.addJsonItems(false, node, arrayList, compilationInfo);
            return arrayList;
        }
        return super.scan(compilationInfo);
    }

    private void addJsonItems(boolean bl, Node node, List<StructureItem> list, CompilationInfo compilationInfo) {
        String string;
        if (bl && (node.getType() == 64 || node.getType() == 63)) {
            return;
        }
        if (node.getType() == 157) {
            string = node.getString();
            Node node2 = AstUtilities.getLabelledNode(node);
            boolean bl2 = false;
            if (node2 != null && (node2.getType() == 64 || node2.getType() == 63)) {
                bl2 = true;
            }
            JsAnalyzer.JsFakeStructureItem jsFakeStructureItem = new JsAnalyzer.JsFakeStructureItem(string, bl2 ? ElementKind.METHOD : ElementKind.PROPERTY, null, compilationInfo);
            list.add(jsFakeStructureItem);
            jsFakeStructureItem.begin = node.getSourceStart();
            jsFakeStructureItem.end = node.getSourceEnd();
            if (bl2) {
                jsFakeStructureItem.children = new ArrayList<StructureItem>();
                list = jsFakeStructureItem.children;
                this.addJsonItems(false, node2, jsFakeStructureItem.children, compilationInfo);
            }
        }
        if (node.hasChildren()) {
            for (string = node.getFirstChild(); string != null; string = string.getNext()) {
                this.addJsonItems(true, (Node)string, list, compilationInfo);
            }
        }
    }

    private void addJsonFolds(boolean bl, Node node, List<OffsetRange> list) {
        OffsetRange offsetRange;
        if (node.getType() == 64) {
            if (bl) {
                bl = false;
            } else {
                offsetRange = AstUtilities.getRange(node);
                list.add(offsetRange);
            }
        }
        if (node.hasChildren()) {
            for (offsetRange = node.getFirstChild(); offsetRange != null; offsetRange = offsetRange.getNext()) {
                this.addJsonFolds(bl, (Node)offsetRange, list);
            }
        }
    }

    @Override
    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        TranslatedSource translatedSource = jsParseResult.getTranslatedSource();
        assert (translatedSource == null);
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        Node node = AstUtilities.getRoot(jsParseResult);
        if (node != null) {
            this.addJsonFolds(true, node, arrayList);
        }
        return hashMap;
    }

    @Override
    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false);
    }
}

