/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(CompilationInfo compilationInfo, int n, String[] stringArray) {
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            if (stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"NoRenameWithErrors");
            }
            return false;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (baseDocument == null) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            TokenSequence tokenSequence2 = tokenSequence.embedded(JsCommentTokenId.language());
            boolean bl = false;
            if (tokenSequence2 != null) {
                boolean bl2 = bl = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)tokenSequence2, n) != null;
            }
            if (!bl && stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"RenameOnlyParams");
            }
            return bl;
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return false;
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        switch (node2.getType()) {
            case 38: 
            case 48: 
            case 155: 
            case 156: {
                return true;
            }
            case 157: {
                return AstUtilities.isLabelledFunction(node2);
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(CompilationInfo compilationInfo, int n) {
        OffsetRange offsetRange;
        Object node;
        List<Node> list;
        JsTokenId jsTokenId;
        Object object2;
        int n2;
        Object object3;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return Collections.emptySet();
        }
        Node node2 = jsParseResult.getRootNode();
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (node2 == null || baseDocument == null) {
            return Collections.emptySet();
        }
        Object object4 = null;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            object3 = tokenSequence.embedded(JsCommentTokenId.language());
            if (object3 != null) {
                object4 = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)object3, n);
            } else {
                return Collections.emptySet();
            }
        }
        if ((object3 = object4) != null) {
            assert (tokenSequence != null);
            n2 = 0;
            boolean bl = false;
            while (tokenSequence.moveNext()) {
                object2 = tokenSequence.token();
                jsTokenId = (JsTokenId)object2.id();
                if (jsTokenId == JsTokenId.FUNCTION) {
                    n2 = 1;
                    continue;
                }
                if (jsTokenId == JsTokenId.LPAREN) {
                    assert (n2 != 0);
                    bl = true;
                    n = tokenSequence.offset() + 1;
                    break;
                }
                if (jsTokenId != JsTokenId.BLOCK_COMMENT) continue;
                break;
            }
            if (!bl) {
                return Collections.emptySet();
            }
        }
        if ((n2 = AstUtilities.getAstOffset(compilationInfo, n)) == -1) {
            return Collections.emptySet();
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        object2 = new AstPath(node2, n2);
        jsTokenId = ((AstPath)object2).leaf();
        if (object3 == null) {
            if (!(jsTokenId instanceof Node.StringNode)) {
                return Collections.emptySet();
            }
            object3 = jsTokenId.getString();
        }
        if (!object3.equals(jsTokenId.getString()) && object4 != null) {
            list = new ArrayList<Node>();
            node = AstUtilities.findLocalScope((Node)jsTokenId, (AstPath)object2);
            AstUtilities.addNodesByType(node, new int[]{155}, list);
            for (Node object5 : list) {
                if (!object5.getString().equals(object4)) continue;
                jsTokenId = object5;
                break;
            }
        }
        list = variableVisitor.getVarOccurrences((Node)jsTokenId);
        node = new HashSet();
        Object object6 = null;
        if (list != null) {
            for (Object object : list) {
                node.add(AstUtilities.getNameRange((Node)object));
                if (object.getType() != 155) continue;
                object6 = object;
            }
        }
        if (node.size() > 0 && jsParseResult.getTranslatedSource() != null) {
            HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>(2 * node.size());
            for (OffsetRange offsetRange2 : node) {
                OffsetRange offsetRange3 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange2);
                if (offsetRange3 == OffsetRange.NONE) continue;
                hashSet.add(offsetRange3);
            }
            node = hashSet;
        }
        if (object6 != null && (offsetRange = this.findParameterDoc(compilationInfo, (Node)object6, (String)object3)) != OffsetRange.NONE) {
            node.add(offsetRange);
        }
        return node;
    }

    @NonNull
    private OffsetRange findParameterDoc(CompilationInfo compilationInfo, Node node, String string) {
        TokenSequence<? extends JsCommentTokenId> tokenSequence;
        Node node2;
        for (node2 = node.getParentNode(); node2 != null && node2.getType() != 105; node2 = node2.getParentNode()) {
        }
        if (node2 == null) {
            return OffsetRange.NONE;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (baseDocument != null && (tokenSequence = AstUtilities.getCommentFor(compilationInfo, baseDocument, node2)) != null) {
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                String string2;
                CharSequence charSequence;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
                int n = tokenSequence.index();
                String string3 = JsCommentLexer.nextType(tokenSequence);
                if (string3 == null) {
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                }
                if ((string2 = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                    if (!string.equals(string2)) continue;
                    int n2 = tokenSequence.offset();
                    return new OffsetRange(n2, n2 + string.length());
                }
                tokenSequence.moveIndex(n);
                tokenSequence.moveNext();
            }
        }
        return OffsetRange.NONE;
    }

    @CheckForNull
    private String getParameterName(TokenSequence<? extends JsCommentTokenId> tokenSequence, int n) {
        assert (tokenSequence != null);
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JsCommentTokenId.IDENT) {
            return null;
        }
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            String string;
            CharSequence charSequence;
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
            int n2 = tokenSequence.index() + 1;
            String string2 = JsCommentLexer.nextType(tokenSequence);
            if (string2 == null) {
                tokenSequence.moveIndex(n2);
                tokenSequence.moveNext();
            }
            if ((string = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                int n3 = tokenSequence.offset();
                if (n < n3 || n > n3 + string.length()) continue;
                return string;
            }
            tokenSequence.moveIndex(n2);
            tokenSequence.moveNext();
        }
        return null;
    }
}

