/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;

public class JsPositionManager
implements PositionManager {
    public OffsetRange getOffsetRange(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        AstElement astElement;
        Element element = JsParser.resolveHandle(compilationInfo, elementHandle);
        if (element instanceof AstElement) {
            Node node = ((AstElement)element).getNode();
            if (node != null) {
                return LexUtilities.getLexerOffsets(compilationInfo, new OffsetRange(node.getSourceStart(), node.getSourceEnd()));
            }
            return OffsetRange.NONE;
        }
        if (element != null) {
            Logger.global.log(Level.WARNING, "Foreign element: " + element + " of type " + (element != null ? element.getClass().getName() : "null"));
        } else if (elementHandle instanceof AstElement && (astElement = (AstElement)elementHandle).getNode() != null) {
            OffsetRange offsetRange = AstUtilities.getRange(astElement.getNode());
            if (offsetRange != OffsetRange.NONE) {
                CompilationInfo compilationInfo2 = astElement.getInfo();
                if (compilationInfo2 == null) {
                    compilationInfo2 = compilationInfo;
                }
                return LexUtilities.getLexerOffsets(compilationInfo2, offsetRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }
}

