/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.text.Document;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.DuplicateElementSet;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.JsCodeCompletion;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsTypeAnalyzer;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.Call;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDeclarationFinder
implements DeclarationFinder {
    private static final boolean CHOOSE_ONE_DECLARATION = Boolean.getBoolean("javascript.choose_one_decl");

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (tokenSequence == null) {
            return OffsetRange.NONE;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == tokenSequence.offset();
        OffsetRange offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && tokenSequence.movePrevious()) {
            offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    @CheckForNull
    IndexedFunction findMethodDeclaration(CompilationInfo compilationInfo, Node node, AstPath astPath, Set<IndexedFunction>[] setArray) {
        Object object;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        JsIndex jsIndex = JsIndex.get(compilationInfo.getIndex("text/javascript"));
        Object object2 = null;
        String string = JsTypeAnalyzer.getCallFqn(compilationInfo, node, true);
        if (string != null && (object2 = jsIndex.getElementsByFqn(string, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult)).size() > 0) {
            object = new DuplicateElementSet(object2.size());
            Iterator<IndexedElement> iterator = object2.iterator();
            while (iterator.hasNext()) {
                IndexedElement indexedElement = iterator.next();
                ElementKind elementKind = indexedElement.getKind();
                if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR) continue;
                object.add(indexedElement);
            }
            if (object.size() > 0) {
                object2 = object;
            }
        }
        if ((object2 == null || object2.size() == 0) && ((String)(object = AstUtilities.getCallName(node, false))).length() > 0) {
            object2 = jsIndex.getAllNames((String)object, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult);
        }
        if (object2 != null && object2.size() > 0 && (object = this.findBestElementMatch(compilationInfo, (Set<IndexedElement>)object2, node, jsIndex)) instanceof IndexedFunction) {
            return (IndexedFunction)object;
        }
        return null;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == JsTokenId.IDENTIFIER && token.length() == 1 && tokenId == JsTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            return OffsetRange.NONE;
        }
        if (tokenId == JsTokenId.IDENTIFIER) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(CompilationInfo compilationInfo, int n) {
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        baseDocument.readLock();
        try {
            Object object;
            Object object2;
            Call call;
            Node node = jsParseResult.getRootNode();
            int n2 = AstUtilities.getAstOffset(compilationInfo, n);
            if (n2 == -1) {
                DeclarationFinder.DeclarationLocation declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
                return declarationLocation;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            AstPath astPath = null;
            Node node2 = null;
            if (node != null) {
                astPath = new AstPath(node, n2);
                node2 = astPath.leaf();
            }
            if ((call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n)).getLhs() == null && AstUtilities.isNameNode(node2) && (object2 = ((VariableVisitor)(object = jsParseResult.getVariableVisitor())).getVarOccurrences(node2)) != null && object2.size() > 0) {
                Node node3;
                HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
                Object object3 = object2.iterator();
                while (object3.hasNext()) {
                    node3 = (Node)object3.next();
                    hashMap.put(node3.getSourceStart(), node3);
                }
                object3 = new ArrayList(hashMap.keySet());
                Collections.sort(object3);
                node3 = (Node)hashMap.get(object3.get(0));
                DeclarationFinder.DeclarationLocation declarationLocation = this.getLocation(compilationInfo, node3);
                return declarationLocation;
            }
            object = new JsCodeCompletion().getPrefix(compilationInfo, n, false);
            if (object != null) {
                object2 = JsIndex.get(compilationInfo.getIndex("text/javascript"));
                Set<IndexedElement> set = ((JsIndex)object2).getAllNames((String)object, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult);
                String string = null;
                DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(compilationInfo, string, set, node2, (JsIndex)object2);
                return declarationLocation;
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation getLocation(CompilationInfo compilationInfo, Node node) {
        AstElement astElement = AstElement.getElement(compilationInfo, node);
        return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), LexUtilities.getLexerOffset(compilationInfo, node.getSourceStart()), (ElementHandle)astElement);
    }

    @NonNull
    DeclarationFinder.DeclarationLocation findLinkedMethod(CompilationInfo compilationInfo, String string) {
        JsParseResult jsParseResult;
        JsIndex jsIndex = JsIndex.get(compilationInfo.getIndex("text/javascript"));
        Set<IndexedElement> set = jsIndex.getAllNames(string, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult = AstUtilities.getParseResult(compilationInfo));
        IndexedElement indexedElement = this.findBestElementMatch(compilationInfo, set, null, null);
        if (indexedElement != null) {
            return new DeclarationFinder.DeclarationLocation(indexedElement.getFileObject(), 0, (ElementHandle)indexedElement);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private IndexedElement findBestElementMatch(CompilationInfo compilationInfo, Set<IndexedElement> set, Node node, JsIndex jsIndex) {
        String string;
        HashSet<IndexedElement> hashSet = new HashSet<IndexedElement>();
        if (node != null && (node.getType() == 37 || node.getType() == 30) && (string = JsTypeAnalyzer.getCallFqn(compilationInfo, node, true)) != null && string.length() > 0 && string.indexOf(46) != -1) {
            while (string != null && string.length() > 0) {
                for (IndexedElement indexedElement : set) {
                    if (!string.equals(indexedElement.getIn() + "." + indexedElement.getName())) continue;
                    hashSet.add(indexedElement);
                }
                if (jsIndex != null && hashSet.size() < set.size()) {
                    string = jsIndex.getExtends(string, JsIndex.ALL_SCOPE);
                    continue;
                }
                string = null;
            }
        }
        if (hashSet.size() == 1) {
            return (IndexedElement)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        hashSet = new HashSet();
        string = compilationInfo.getFileObject();
        for (IndexedElement indexedElement : set) {
            if (string != indexedElement.getFileObject()) continue;
            hashSet.add(indexedElement);
        }
        if (hashSet.size() == 1) {
            return (IndexedElement)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        if (set.size() > 0) {
            IndexedElement indexedElement;
            IndexedElement indexedElement2 = set.iterator().next();
            indexedElement = indexedElement2.findRealFileElement();
            if (indexedElement != null) {
                return indexedElement;
            }
            return indexedElement2;
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(CompilationInfo compilationInfo, String string, Set<IndexedElement> set, Node node, JsIndex jsIndex) {
        IndexedElement indexedElement = this.findBestElementMatch(compilationInfo, set, node, jsIndex);
        if (indexedElement != null) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            int n;
            CompilationInfo[] compilationInfoArray;
            IndexedElement indexedElement2;
            Node node2;
            boolean bl = false;
            if (indexedElement.getFilenameUrl() != null && indexedElement.getFilenameUrl().indexOf("jsstubs") != -1 && indexedElement.getFilenameUrl().indexOf("sdocs.zip") == -1) {
                bl = true;
            }
            if ((node2 = AstUtilities.getForeignNode(indexedElement2 = indexedElement, compilationInfoArray = new CompilationInfo[1])) == null) {
                n = 0;
                declarationLocation = new DeclarationFinder.DeclarationLocation(indexedElement.getFileObject(), n, (ElementHandle)indexedElement2);
            } else {
                n = node2.getSourceStart();
                int n2 = LexUtilities.getLexerOffset(compilationInfoArray[0], n);
                declarationLocation = new DeclarationFinder.DeclarationLocation(indexedElement2.getFile().getFileObject(), n2, (ElementHandle)indexedElement2);
            }
            if (bl) {
                if (indexedElement.isDocOnly()) {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"NoSourceDocOnly", (Object)indexedElement.getName()));
                } else {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"InvalidJsMethod", (Object)indexedElement.getName()));
                }
            }
            if (!CHOOSE_ONE_DECLARATION && set.size() > 1) {
                for (IndexedElement indexedElement3 : set) {
                    declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new JsAltLocation(indexedElement3, indexedElement3 == indexedElement));
                }
            }
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private class JsAltLocation
    implements DeclarationFinder.AlternativeLocation {
        private IndexedElement element;
        private boolean isPreferred;
        private String cachedDisplayItem;

        JsAltLocation(IndexedElement indexedElement, boolean bl) {
            this.element = indexedElement;
            this.isPreferred = bl;
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.setMaxLength(120);
            if (this.cachedDisplayItem == null) {
                Object object;
                Object object2;
                Object object3;
                htmlFormatter.reset();
                boolean bl = this.element.isNoDoc();
                boolean bl2 = this.element.isDocumented();
                if (this.isPreferred) {
                    htmlFormatter.emphasis(true);
                } else if (bl) {
                    htmlFormatter.deprecated(true);
                }
                if (this.element instanceof IndexedFunction) {
                    if (this.element.getIn() != null) {
                        htmlFormatter.appendText(this.element.getIn());
                        htmlFormatter.appendText(".");
                    }
                    htmlFormatter.appendText(this.element.getName());
                    object3 = (IndexedFunction)this.element;
                    object2 = ((IndexedFunction)object3).getParameters();
                    if (object2 != null && object2.size() > 0) {
                        htmlFormatter.appendText("(");
                        object = object2.iterator();
                        while (object.hasNext()) {
                            htmlFormatter.parameters(true);
                            htmlFormatter.appendText((String)object.next());
                            htmlFormatter.parameters(false);
                            if (!object.hasNext()) continue;
                            htmlFormatter.appendText(", ");
                        }
                        htmlFormatter.appendText(")");
                    }
                } else {
                    htmlFormatter.appendText(this.element.getName());
                }
                object3 = null;
                object2 = this.element.getFilenameUrl();
                if (object2 != null) {
                    if (((String)object2).indexOf("jsstubs") != -1) {
                        object3 = NbBundle.getMessage(JsDeclarationFinder.class, (String)"JsLib");
                    } else {
                        object = this.element.getFileObject();
                        if (object != null) {
                            object3 = object.getNameExt();
                        } else {
                            int n = ((String)object2).lastIndexOf(47);
                            if (n != -1) {
                                String string = ((String)object2).substring(0, n);
                                int n2 = string.lastIndexOf(47);
                                if (n2 != -1 && ((String)object2).length() - n2 < 40) {
                                    object3 = ((String)object2).substring(n2 + 1);
                                    if (((String)object3).indexOf(58) != -1) {
                                        object3 = ((String)object2).substring(n + 1);
                                    }
                                } else {
                                    object3 = ((String)object2).substring(n + 1);
                                }
                            }
                        }
                    }
                }
                if (object3 != null) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"In"));
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText((String)object3);
                }
                if (bl2) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"Documented"));
                } else if (bl) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"NoDoced"));
                }
                if (this.isPreferred) {
                    htmlFormatter.emphasis(false);
                } else if (bl) {
                    htmlFormatter.deprecated(false);
                }
                this.cachedDisplayItem = htmlFormatter.getText();
            }
            return this.cachedDisplayItem;
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            CompilationInfo[] compilationInfoArray = new CompilationInfo[1];
            Node node = AstUtilities.getForeignNode(this.element, compilationInfoArray);
            DeclarationFinder.DeclarationLocation declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
            if (node == null) {
                FileObject fileObject;
                if (this.element instanceof IndexedElement && (fileObject = this.element.getFileObject()) != null) {
                    int n = this.element.getNodeOffset();
                    int n2 = LexUtilities.getLexerOffset(compilationInfoArray[0], n);
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    declarationLocation = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), n2, (ElementHandle)this.element);
                }
            } else {
                int n = node.getSourceStart();
                int n3 = LexUtilities.getLexerOffset(compilationInfoArray[0], n);
                if (n3 == -1) {
                    n3 = 0;
                }
                declarationLocation = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), n3, (ElementHandle)this.element);
            }
            if (declarationLocation != null && this.element.getFilenameUrl() != null && this.element.getFilenameUrl().indexOf("jsstubs") != -1 && this.element.getFilenameUrl().indexOf("sdocs.zip") == -1) {
                if (this.element.isDocOnly()) {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"NoSourceDocOnly", (Object)this.element.getName()));
                } else {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"InvalidJsMethod", (Object)this.element.getName()));
                }
            }
            return declarationLocation;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            String string;
            JsAltLocation jsAltLocation = (JsAltLocation)alternativeLocation;
            if (this.isPreferred) {
                return -1;
            }
            if (jsAltLocation.isPreferred) {
                return 1;
            }
            String string2 = this.element.getIn() != null ? this.element.getIn() : "";
            int n = string2.compareTo(string = jsAltLocation.element.getIn() != null ? jsAltLocation.element.getIn() : "");
            if (n != 0) {
                return n;
            }
            String string3 = this.element.getFileObject() != null ? this.element.getFileObject().getNameExt() : "";
            String string4 = jsAltLocation.element.getFileObject() != null ? jsAltLocation.element.getFileObject().getNameExt() : "";
            n = string3.compareTo(string4);
            return n;
        }
    }
}

