/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallChildren;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;

public class FunctionRootNode
extends AbstractNode {
    private Function object;
    private CallGraphState model;
    private boolean isCalls;

    public FunctionRootNode(Function function, CallGraphState callGraphState, boolean bl) {
        super((Children)new CallChildren(function, callGraphState, bl));
        this.object = function;
        this.model = callGraphState;
        this.isCalls = bl;
        this.setName(function.getName());
        callGraphState.addFunctionToScene(function);
    }

    public String getHtmlDisplayName() {
        return this.object.getHtmlDisplayName();
    }

    public Image getIcon(int n) {
        Image image = this.object.getIcon();
        if (image == null) {
            image = super.getIcon(n);
        }
        return this.mergeBadge(image);
    }

    private Image mergeBadge(Image image) {
        if (this.isCalls) {
            return ImageUtilities.mergeImages((Image)image, (Image)CallNode.downBadge, (int)0, (int)0);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action getPreferredAction() {
        return new GoToReferenceAction(this.object, 0);
    }

    public Action[] getActions(boolean bl) {
        Action action = this.getPreferredAction();
        if (action != null) {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(action);
            arrayList.add(null);
            for (Action action2 : this.model.getActions()) {
                arrayList.add(action2);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.model.getActions();
    }

    Function getFunction() {
        return this.object;
    }
}

