/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownPieChartModel;

public class ProjectPieChartModel
extends DrillDownPieChartModel {
    public ProjectPieChartModel(DrillDown drillDown) {
        super(drillDown);
    }

    public String getItemName(int n) {
        return this.getItemNameAt(this.getMappedIndex(n));
    }

    public double getItemValue(int n) {
        double d = this.getItemValueAt(this.getMappedIndex(n));
        System.out.println("Getting value for category n." + n + "  : " + d);
        return d;
    }

    public double getItemValueRel(int n) {
        long l = this.drillDown.getCurrentTime(false);
        if (LOGGER.isLoggable(Level.FINEST)) {
            long l2 = 0L;
            List<Category> list = this.getSubCategories();
            for (int i = 0; i < list.size(); ++i) {
                l2 = (long)((double)l2 + this.getItemValueAt(i));
            }
            if (l2 != l) {
                LOGGER.finest("time mismatch: " + l + " != " + l2);
            }
        }
        if (l == 0L) {
            return 1.0;
        }
        return this.getItemValueAt(this.getMappedIndex(n)) / (double)l;
    }

    public boolean isSelectable(int n) {
        if (this.drillDown.getSubCategories().size() <= n) {
            return false;
        }
        if (n != -1) {
            return this.drillDown.canDrilldown(this.getSubCategories().get(n));
        }
        return false;
    }

    private String getItemNameAt(int n) {
        List<Category> list = this.getSubCategories();
        if (list.size() <= n) {
            return "";
        }
        return list.get(n).getLabel();
    }

    private double getItemValueAt(int n) {
        List<Category> list = this.getSubCategories();
        if (list.size() <= n) {
            return 0.0;
        }
        if (n == -1 || this.drillDown.isCurrent(this.drillDown.getSubCategories().get(n))) {
            return this.drillDown.getCurrentTime(true);
        }
        return this.drillDown.getCategoryTime(list.get(n), false);
    }
}

