/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImagePreviewPanel
extends JPanel {
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_NotAvailableMsg");
    private static final String GENERATING_PREVIEW_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_GeneratingPreviewMsg");
    private static final String NO_IMAGE_MSG = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ImagePreviewPanel_NoImageMsg");
    private static final int PREVIEW_THRESHOLD = 2000000;
    private static int instanceCounter = 0;
    private static final Dimension ZERO_SIZE = new Dimension();
    private RequestProcessor.Task currentTask;
    private JLabel displayer;
    private RequestProcessor processor = new RequestProcessor("ImagePreviewPanel-Processor-" + instanceCounter++, 1, true);

    public ImagePreviewPanel() {
        this.initComponents();
    }

    public void setImage(final ImageProvider imageProvider) {
        this.clearImage();
        this.currentTask = this.processor.post(new Runnable(){

            public void run() {
                try {
                    ImageIcon imageIcon;
                    if (Thread.interrupted()) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    BufferedImage bufferedImage = imageProvider.getImage();
                    if (Thread.interrupted()) {
                        bufferedImage = null;
                    }
                    if (bufferedImage == null) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    Dimension dimension = ImagePreviewPanel.this.getImageFitSize(bufferedImage.getWidth(), bufferedImage.getHeight());
                    int n = dimension.width;
                    int n2 = dimension.height;
                    if (Thread.interrupted()) {
                        bufferedImage = null;
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    if (bufferedImage.getWidth() * bufferedImage.getHeight() > 2000000) {
                        imageIcon = new ImageIcon(bufferedImage.getScaledInstance(Math.max(1, n), Math.max(1, n2), 2));
                        if (Thread.interrupted()) {
                            bufferedImage = null;
                            ImagePreviewPanel.this.displayer.setIcon(null);
                            ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                            return;
                        }
                        ImagePreviewPanel.this.displayer.setText(null);
                        ImagePreviewPanel.this.repaint();
                        ImagePreviewPanel.this.displayer.setIcon(imageIcon);
                    }
                    if (Thread.interrupted()) {
                        bufferedImage = null;
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    imageIcon = new ImageIcon(bufferedImage.getScaledInstance(Math.max(1, n), Math.max(1, n2), 4));
                    bufferedImage = null;
                    if (Thread.interrupted()) {
                        ImagePreviewPanel.this.displayer.setIcon(null);
                        ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                        return;
                    }
                    ImagePreviewPanel.this.displayer.setText(null);
                    ImagePreviewPanel.this.repaint();
                    ImagePreviewPanel.this.displayer.setIcon(imageIcon);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    ImagePreviewPanel.this.displayer.setIcon(null);
                    ImagePreviewPanel.this.displayer.setText(NOT_AVAILABLE_MSG);
                }
            }
        });
    }

    public void clearImage() {
        this.displayer.setIcon(null);
        this.displayer.setText(GENERATING_PREVIEW_MSG);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    public void reset() {
        this.displayer.setIcon(null);
        this.displayer.setText(NO_IMAGE_MSG);
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    private Dimension getClientSize() {
        Insets insets = this.displayer.getInsets();
        Dimension dimension = this.displayer.getSize().equals(ZERO_SIZE) ? this.displayer.getPreferredSize() : this.displayer.getSize();
        return new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
    }

    private Dimension getImageFitSize(int n, int n2) {
        Dimension dimension = this.getClientSize();
        float f = (float)n / (float)n2;
        int n3 = dimension.width;
        int n4 = dimension.height;
        float f2 = (float)n3 / (float)n4;
        if (f > f2) {
            int n5 = n3;
            int n6 = (int)((float)n5 / f);
            return new Dimension(n5, n6);
        }
        if (f < f2) {
            int n7 = n4;
            int n8 = (int)((float)n7 * f);
            return new Dimension(n8, n7);
        }
        return dimension;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.displayer = new JLabel();
        this.displayer.setHorizontalAlignment(0);
        this.displayer.setBackground(UIUtils.getProfilerResultsBackground());
        this.displayer.setOpaque(true);
        this.displayer.setPreferredSize(new Dimension(200, 200));
        this.displayer.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.add((Component)this.displayer, "Center");
    }

    public static interface ImageProvider {
        public BufferedImage getImage();
    }
}

