/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class WizardPanel1UI
extends ValidityAwarePanel
implements HelpCtx.Provider {
    private static final String SELECT_PROJECT_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_SelectProjectString");
    private static final String PP_TYPE_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_PpTypeString");
    private static final String PP_PROJECT_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_PpProjectString");
    private static final String DESCRIPTION_LABEL_TEXT = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_DescriptionLabelText");
    private static final String SUPPORTED_MODES_LABEL_TEXT = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_SupportedModesLabelText");
    private static final String MONITOR_MODE_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_MonitorModeString");
    private static final String CPU_MODE_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_CpuModeString");
    private static final String MEMORY_MODE_STRING = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_MemoryModeString");
    private static final String PP_LIST_ACCESS_NAME = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_PpListAccessName");
    private static final String PROJECTS_LIST_ACCESS_NAME = NbBundle.getMessage(WizardPanel1UI.class, (String)"WizardPanel1UI_ProjectsListAccessName");
    private static final String HELP_CTX_KEY = "PPointsWizardPanel1UI.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("PPointsWizardPanel1UI.HelpCtx");
    private static final Icon MONITOR_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/telemetryWindow.png"));
    private static final Icon CPU_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpu.png"));
    private static final Icon MEMORY_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png"));
    private DefaultTableModel ppointTypeTableModel;
    private Dimension initialMinSize;
    private JComboBox ppointProjectCombo;
    private JExtendedTable ppointTypeTable;
    private JLabel ppointDescriptionCaptionLabel;
    private JLabel ppointEffectiveCPULabel;
    private JLabel ppointEffectiveCaptionLabel;
    private JLabel ppointEffectiveMemoryLabel;
    private JLabel ppointEffectiveMonitorLabel;
    private JLabel ppointProjectLabel;
    private JLabel ppointTypeCaptionLabel;
    private JTextArea ppointDescriptionArea;
    private ProfilingPointFactory[] ppFactories = new ProfilingPointFactory[0];

    public WizardPanel1UI() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public Dimension getMinSize() {
        return this.initialMinSize;
    }

    public void setSelectedIndex(int n) {
        if (n == -1) {
            this.ppointTypeTable.clearSelection();
        } else {
            this.ppointTypeTable.setRowSelectionInterval(n, n);
        }
    }

    public int getSelectedIndex() {
        return this.ppointTypeTable.getSelectedRow();
    }

    public void setSelectedProject(Project project) {
        if (project != null) {
            this.ppointProjectCombo.setSelectedItem(project);
        }
        if (this.ppointProjectCombo.getSelectedItem() != project && this.ppointProjectCombo.getItemAt(0) != SELECT_PROJECT_STRING) {
            this.ppointProjectCombo.insertItemAt(SELECT_PROJECT_STRING, 0);
            this.ppointProjectCombo.setSelectedItem(SELECT_PROJECT_STRING);
        }
    }

    public Project getSelectedProject() {
        if (this.ppointProjectCombo.getSelectedItem() instanceof Project) {
            return (Project)this.ppointProjectCombo.getSelectedItem();
        }
        return null;
    }

    public void init(ProfilingPointFactory[] profilingPointFactoryArray) {
        this.ppFactories = profilingPointFactoryArray;
        this.initProjectsCombo();
        this.ppointTypeTableModel.fireTableDataChanged();
        this.ppointTypeTable.getColumnModel().getColumn(0).setMaxWidth(Math.max(ProfilingPointFactory.SCOPE_CODE_ICON.getIconWidth(), ProfilingPointFactory.SCOPE_GLOBAL_ICON.getIconWidth()) + 25);
        this.refresh();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.ppointTypeCaptionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.ppointTypeCaptionLabel, (String)PP_TYPE_STRING);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointTypeCaptionLabel, gridBagConstraints);
        this.ppointTypeTableModel = new PPointTypeTableModel();
        this.ppointTypeTable = new JExtendedTable((TableModel)this.ppointTypeTableModel);
        this.ppointTypeTable.getAccessibleContext().setAccessibleName(PP_LIST_ACCESS_NAME);
        this.ppointTypeCaptionLabel.setLabelFor((Component)this.ppointTypeTable);
        this.ppointTypeTable.setTableHeader(null);
        this.ppointTypeTable.setRowSelectionAllowed(true);
        this.ppointTypeTable.setSelectionMode(0);
        this.ppointTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WizardPanel1UI.this.refresh();
            }
        });
        this.ppointTypeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.ppointTypeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.ppointTypeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.ppointTypeTable.setShowHorizontalLines(false);
        this.ppointTypeTable.setShowVerticalLines(true);
        this.ppointTypeTable.setRowMargin(0);
        this.ppointTypeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.ppointTypeTable.setDefaultRenderer(Integer.class, (TableCellRenderer)Utils.getScopeRenderer());
        this.ppointTypeTable.setDefaultRenderer(String.class, (TableCellRenderer)Utils.getPresenterRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 12, 10);
        this.add((Component)new JExtendedTablePanel(this.ppointTypeTable), gridBagConstraints);
        this.ppointProjectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.ppointProjectLabel, (String)PP_PROJECT_STRING);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointProjectLabel, gridBagConstraints);
        this.ppointProjectCombo = new JComboBox(new Object[]{SELECT_PROJECT_STRING}){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.ppointProjectLabel.getAccessibleContext().setAccessibleName(PROJECTS_LIST_ACCESS_NAME);
        this.ppointProjectLabel.setLabelFor(this.ppointProjectCombo);
        this.ppointProjectCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardPanel1UI.this.refresh();
            }
        });
        this.ppointProjectCombo.setRenderer(Utils.getProjectListRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 12, 10);
        this.add((Component)this.ppointProjectCombo, gridBagConstraints);
        this.ppointDescriptionCaptionLabel = new JLabel(DESCRIPTION_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointDescriptionCaptionLabel, gridBagConstraints);
        this.ppointDescriptionArea = new JTextArea();
        this.ppointDescriptionArea.setOpaque(false);
        this.ppointDescriptionArea.setWrapStyleWord(true);
        this.ppointDescriptionArea.setLineWrap(true);
        this.ppointDescriptionArea.setEnabled(false);
        this.ppointDescriptionArea.setFont(UIManager.getFont("Label.font"));
        this.ppointDescriptionArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        int n = this.ppointDescriptionArea.getRows();
        this.ppointDescriptionArea.setRows(4);
        final int n2 = this.ppointDescriptionArea.getPreferredSize().height;
        this.ppointDescriptionArea.setRows(n);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 12, 10);
        JScrollPane jScrollPane = new JScrollPane(this.ppointDescriptionArea, 20, 31){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, n2);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, n2);
            }
        };
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        this.add((Component)jScrollPane, gridBagConstraints);
        int n3 = this.ppointDescriptionCaptionLabel.getPreferredSize().height;
        n3 = Math.max(n3, MONITOR_ICON.getIconHeight());
        n3 = Math.max(n3, CPU_ICON.getIconHeight());
        final int n4 = n3 = Math.max(n3, MEMORY_ICON.getIconHeight());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.ppointEffectiveCaptionLabel = new JLabel(SUPPORTED_MODES_LABEL_TEXT){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, n4);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, n4);
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.ppointEffectiveCaptionLabel, gridBagConstraints);
        this.ppointEffectiveMonitorLabel = new JLabel(MONITOR_MODE_STRING, MONITOR_ICON, 2);
        this.ppointEffectiveMonitorLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.ppointEffectiveMonitorLabel, gridBagConstraints);
        this.ppointEffectiveCPULabel = new JLabel(CPU_MODE_STRING, CPU_ICON, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.ppointEffectiveCPULabel, gridBagConstraints);
        this.ppointEffectiveMemoryLabel = new JLabel(MEMORY_MODE_STRING, MEMORY_ICON, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.ppointEffectiveMemoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.initialMinSize = this.getMinimumSize();
    }

    private void initProjectsCombo() {
        Project[] projectArray = ProjectUtilities.getSortedProjects((Project[])ProjectUtilities.getOpenedProjects());
        this.ppointProjectCombo.removeAllItems();
        for (Project project : projectArray) {
            this.ppointProjectCombo.addItem(project);
        }
        this.setSelectedProject(Utils.getCurrentProject());
    }

    private void refresh() {
        boolean bl;
        int n;
        if (this.ppointProjectCombo.getSelectedItem() instanceof Project && this.ppointProjectCombo.getItemAt(0) == SELECT_PROJECT_STRING) {
            this.ppointProjectCombo.removeItem(SELECT_PROJECT_STRING);
        }
        if ((n = this.ppointTypeTable.getSelectedRow()) != -1) {
            ProfilingPointFactory profilingPointFactory = this.ppFactories[n];
            this.ppointDescriptionArea.setText(profilingPointFactory.getDescription());
            this.ppointEffectiveMonitorLabel.setVisible(profilingPointFactory.supportsMonitor());
            this.ppointEffectiveCPULabel.setVisible(profilingPointFactory.supportsCPU());
            this.ppointEffectiveMemoryLabel.setVisible(profilingPointFactory.supportsMemory());
        } else {
            this.ppointDescriptionArea.setText("");
            this.ppointEffectiveMonitorLabel.setVisible(false);
            this.ppointEffectiveCPULabel.setVisible(false);
            this.ppointEffectiveMemoryLabel.setVisible(false);
        }
        boolean bl2 = n != -1;
        boolean bl3 = this.ppointProjectCombo.getSelectedItem() != null && this.ppointProjectCombo.getSelectedItem() instanceof Project;
        boolean bl4 = bl = bl2 && bl3;
        if (bl) {
            if (!this.areSettingsValid()) {
                this.fireValidityChanged(true);
            }
        } else if (this.areSettingsValid()) {
            this.fireValidityChanged(false);
        }
    }

    private class PPointTypeTableModel
    extends DefaultTableModel {
        private PPointTypeTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return WizardPanel1UI.this.ppFactories.length;
        }

        public Object getValueAt(int n, int n2) {
            return WizardPanel1UI.this.ppFactories[n];
        }
    }
}

