/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TakeSnapshotCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TakeSnapshotProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(TakeSnapshotProfilingPointFactory.class, (String)"TakeSnapshotProfilingPointFactory_PpDefaultName");
    public static final Icon TAKE_SNAPSHOT_PP_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/ppoints/ui/resources/takeSnapshotProfilingPoint.png"));
    public static final String TAKE_SNAPSHOT_PP_TYPE = PP_TYPE;
    public static final String TAKE_SNAPSHOT_PP_DESCR = PP_DESCR;
    private static TakeSnapshotProfilingPointFactory defaultInstance;

    public static TakeSnapshotProfilingPointFactory getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TakeSnapshotProfilingPointFactory();
        }
        return defaultInstance;
    }

    public String getDescription() {
        return TAKE_SNAPSHOT_PP_DESCR;
    }

    public Icon getIcon() {
        return TAKE_SNAPSHOT_PP_ICON;
    }

    public int getScope() {
        return 1;
    }

    public String getType() {
        return TAKE_SNAPSHOT_PP_TYPE;
    }

    public TakeSnapshotProfilingPoint create(Project project) {
        CodeProfilingPoint.Location location;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((location = Utils.getCurrentLocation(Integer.MAX_VALUE)).equals(CodeProfilingPoint.Location.EMPTY)) {
            String string = "";
            String string2 = Utils.getUniqueName(this.getType(), "", project);
            return new TakeSnapshotProfilingPoint(string2, location, project);
        }
        String string = FileUtil.toFileObject((File)new File(location.getFile())).getName();
        String string3 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
        return new TakeSnapshotProfilingPoint(string3, location, project);
    }

    public boolean supportsCPU() {
        return true;
    }

    public boolean supportsMemory() {
        return true;
    }

    public boolean supportsMonitor() {
        return false;
    }

    protected Class getProfilingPointsClass() {
        return TakeSnapshotProfilingPoint.class;
    }

    protected String getServerHandlerClassName() {
        throw new UnsupportedOperationException();
    }

    protected TakeSnapshotCustomizer createCustomizer() {
        return new TakeSnapshotCustomizer(this.getType(), this.getIcon());
    }

    protected ProfilingPoint loadProfilingPoint(Project project, Properties properties, int n) {
        String string = properties.getProperty(n + "_" + "p_name", null);
        String string2 = properties.getProperty(n + "_" + "p_enabled", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, n, properties);
        String string3 = properties.getProperty(n + "_" + "p_snapshot", null);
        String string4 = properties.getProperty(n + "_" + "p_target", null);
        String string5 = properties.getProperty(n + "_" + "p_file", null);
        String string6 = properties.getProperty(n + "_" + "p_reset_results", null);
        if (string == null || string2 == null || location == null || string3 == null || string4 == null || string5 == null || string6 == null) {
            return null;
        }
        TakeSnapshotProfilingPoint takeSnapshotProfilingPoint = null;
        try {
            takeSnapshotProfilingPoint = new TakeSnapshotProfilingPoint(string, location, project);
            takeSnapshotProfilingPoint.setEnabled(Boolean.parseBoolean(string2));
            takeSnapshotProfilingPoint.setSnapshotType(string3);
            takeSnapshotProfilingPoint.setSnapshotTarget(string4);
            takeSnapshotProfilingPoint.setSnapshotFile(string5);
            takeSnapshotProfilingPoint.setResetResults(Boolean.parseBoolean(string6));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        return takeSnapshotProfilingPoint;
    }

    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int n, Properties properties) {
        TakeSnapshotProfilingPoint takeSnapshotProfilingPoint = (TakeSnapshotProfilingPoint)profilingPoint;
        properties.put(n + "_" + "p_name", takeSnapshotProfilingPoint.getName());
        properties.put(n + "_" + "p_enabled", Boolean.toString(takeSnapshotProfilingPoint.isEnabled()));
        properties.put(n + "_" + "p_snapshot", takeSnapshotProfilingPoint.getSnapshotType());
        properties.put(n + "_" + "p_target", takeSnapshotProfilingPoint.getSnapshotTarget());
        properties.put(n + "_" + "p_file", takeSnapshotProfilingPoint.getSnapshotFile() == null ? "" : takeSnapshotProfilingPoint.getSnapshotFile());
        properties.put(n + "_" + "p_reset_results", Boolean.toString(takeSnapshotProfilingPoint.getResetResults()));
        takeSnapshotProfilingPoint.getLocation().store(takeSnapshotProfilingPoint.getProject(), n, properties);
    }
}

