/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ResetResultsProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ResetResultsCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ResetResultsProfilingPoint
extends CodeProfilingPoint.Single
implements PropertyChangeListener {
    private static final String ONE_HIT_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HeaderLocationString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HeaderHitsString");
    private static final String HIT_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_HitSuccessString");
    private static final String DATA_STRING = NbBundle.getMessage(ResetResultsProfilingPoint.class, (String)"ResetResultsProfilingPoint_DataString");
    private static final String ANNOTATION_ENABLED = "resetResultsProfilingPoint";
    private static final String ANNOTATION_DISABLED = "resetResultsProfilingPointD";
    private Annotation annotation;
    private List<Result> results = new ArrayList<Result>();
    private WeakReference<Report> reportReference;

    public ResetResultsProfilingPoint(String string, CodeProfilingPoint.Location location, Project project) {
        super(string, location, project);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public ProfilingPointFactory getFactory() {
        return ResetResultsProfilingPointFactory.getDefault();
    }

    public boolean hasResults() {
        return this.results.size() > 0;
    }

    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ResetResultsProfilingPoint.this.hasReport()) {
                    ResetResultsProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.hasReport()) {
            if (propertyChangeEvent.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    public void showResults(URL uRL) {
        Report report = this.getReport();
        report.open();
        report.requestActive();
    }

    protected CodeProfilingPoint.Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new Annotation();
        }
        return this.annotation;
    }

    protected String getResultsText() {
        if (this.hasResults()) {
            return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
        }
        return NO_RESULTS_STRING;
    }

    protected void updateCustomizer(ValidityAwarePanel validityAwarePanel) {
        ResetResultsCustomizer resetResultsCustomizer = (ResetResultsCustomizer)validityAwarePanel;
        resetResultsCustomizer.setPPName(this.getName());
        resetResultsCustomizer.setPPLocation(this.getLocation());
    }

    void setValues(ValidityAwarePanel validityAwarePanel) {
        ResetResultsCustomizer resetResultsCustomizer = (ResetResultsCustomizer)validityAwarePanel;
        this.setName(resetResultsCustomizer.getPPName());
        this.setLocation(resetResultsCustomizer.getPPLocation());
        Utils.checkLocation(this);
    }

    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int n) {
        this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId()));
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    void reset() {
        boolean bl = this.results.size() > 0;
        this.results.clear();
        if (bl) {
            this.getChangeSupport().firePropertyChange("p_results", false, true);
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;

        public Result(long l, int n) {
            this.timestamp = l;
            this.threadId = n;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        void refreshData() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHeaderName());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderType());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderEnabled());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderProject());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderLocation());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(stringBuilder.toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            if (ResetResultsProfilingPoint.this.results.size() == 0) {
                stringBuilder2.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
            } else {
                for (int i = 0; i < ResetResultsProfilingPoint.this.results.size(); ++i) {
                    stringBuilder2.append("&nbsp;&nbsp;");
                    stringBuilder2.append(this.getDataResultItem(i));
                    stringBuilder2.append("<br>");
                }
            }
            this.dataArea.setText(stringBuilder2.toString());
        }

        void refreshProperties() {
            this.setName(ResetResultsProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)ResetResultsProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        private String getDataResultItem(int n) {
            Result result = (Result)ResetResultsProfilingPoint.this.results.get(n);
            return MessageFormat.format(HIT_STRING, n + 1, Utils.formatProfilingPointTimeHiRes(result.getTimestamp()));
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, ResetResultsProfilingPoint.this.isEnabled());
        }

        private String getHeaderHitsCount() {
            return MessageFormat.format(HEADER_HITS_STRING, ResetResultsProfilingPoint.this.results.size());
        }

        private String getHeaderLocation() {
            CodeProfilingPoint.Location location = ResetResultsProfilingPoint.this.getLocation();
            String string = new File(location.getFile()).getName();
            int n = location.getLine();
            return MessageFormat.format(HEADER_LOCATION_STRING, string, n);
        }

        private String getHeaderName() {
            return "<h2><b>" + ResetResultsProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)ResetResultsProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, ResetResultsProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    Utils.openLocation(ResetResultsProfilingPoint.this.getLocation());
                }
            };
            JScrollPane jScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder titledBorder = new TitledBorder(DATA_STRING);
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
            titledBorder.setTitleColor(UIManager.getColor("Label.foreground"));
            jScrollPane2.setBorder(titledBorder);
            jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane2.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.add((Component)jScrollPane2, "Center");
            this.add(jPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private Annotation() {
        }

        public String getAnnotationType() {
            return ResetResultsProfilingPoint.this.isEnabled() ? ResetResultsProfilingPoint.ANNOTATION_ENABLED : ResetResultsProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            return ResetResultsProfilingPoint.this.getName();
        }
    }
}

