/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.LoadGenProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.LoadGeneratorCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LoadGenProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(LoadGenProfilingPointFactory.class, (String)"LoadGenProfilingPointFactory_PpDefaultName");
    private static final Icon LOADGEN_PP_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/ppoints/ui/resources/loadgenProfilingPoint.png"));
    private static final String LOADGEN_PP_TYPE = PP_TYPE;
    private static final String LOADGEN_PP_DESCR = PP_DESCR;
    private static final String START_LOCATION_PREFIX = "start_";
    private static final String END_LOCATION_PREFIX = "end_";
    private static LoadGenProfilingPointFactory defaultInstance = null;
    private final Lookup.Result loadGenResult;
    private final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            LoadGenProfilingPointFactory.this.available = ((Lookup.Result)lookupEvent.getSource()).allInstances().size() > 0;
            LoadGenProfilingPointFactory.this.firePropertyChange(new PropertyChangeEvent(LoadGenProfilingPointFactory.this, ProfilingPointFactory.AVAILABILITY_PROPERTY, false, true));
        }
    };
    private boolean available = false;

    public LoadGenProfilingPointFactory() {
        this.loadGenResult = Lookup.getDefault().lookupResult(LoadGenPlugin.class);
        this.loadGenResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)this.loadGenResult));
        this.available = this.loadGenResult.allInstances().size() > 0;
    }

    public static synchronized LoadGenProfilingPointFactory getDefault() {
        return (LoadGenProfilingPointFactory)Lookup.getDefault().lookup(LoadGenProfilingPointFactory.class);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getDescription() {
        return LOADGEN_PP_DESCR;
    }

    public Icon getIcon() {
        return LOADGEN_PP_ICON;
    }

    public int getScope() {
        return 1;
    }

    public String getType() {
        return LOADGEN_PP_TYPE;
    }

    public ProfilingPoint create(Project project) {
        CodeProfilingPoint.Location[] locationArray;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((locationArray = Utils.getCurrentSelectionLocations()).length != 2) {
            CodeProfilingPoint.Location location = Utils.getCurrentLocation(Integer.MIN_VALUE);
            if (location.equals(CodeProfilingPoint.Location.EMPTY)) {
                String string = "";
                String string2 = Utils.getUniqueName(this.getType(), "", project);
                return new LoadGenProfilingPoint(string2, location, null, project);
            }
            String string = FileUtil.toFileObject((File)new File(location.getFile())).getName();
            String string3 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
            return new LoadGenProfilingPoint(string3, location, null, project);
        }
        CodeProfilingPoint.Location location = locationArray[0];
        CodeProfilingPoint.Location location2 = locationArray[1];
        String string = FileUtil.toFileObject((File)new File(location.getFile())).getName();
        String string4 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
        return new LoadGenProfilingPoint(string4, location, location2, project);
    }

    public boolean supportsCPU() {
        return true;
    }

    public boolean supportsMemory() {
        return true;
    }

    public boolean supportsMonitor() {
        return false;
    }

    protected Class getProfilingPointsClass() {
        return LoadGenProfilingPoint.class;
    }

    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.global.ProfilingPointServerHandler";
    }

    protected ValidityAwarePanel createCustomizer() {
        return new LoadGeneratorCustomizer(this.getType(), this.getIcon());
    }

    protected ProfilingPoint loadProfilingPoint(Project project, Properties properties, int n) {
        String string = properties.getProperty(n + "_" + "p_name", null);
        String string2 = properties.getProperty(n + "_" + "p_enabled", null);
        String string3 = properties.getProperty(n + "_" + "p_ScriptName", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, n, START_LOCATION_PREFIX, properties);
        CodeProfilingPoint.Location location2 = CodeProfilingPoint.Location.load(project, n, END_LOCATION_PREFIX, properties);
        if (string == null || string2 == null || location == null) {
            return null;
        }
        LoadGenProfilingPoint loadGenProfilingPoint = null;
        try {
            loadGenProfilingPoint = new LoadGenProfilingPoint(string, location, location2, project);
            loadGenProfilingPoint.setEnabled(Boolean.parseBoolean(string2));
            loadGenProfilingPoint.setSriptFileName(string3);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        return loadGenProfilingPoint;
    }

    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int n, Properties properties) {
        LoadGenProfilingPoint loadGenProfilingPoint = (LoadGenProfilingPoint)profilingPoint;
        properties.put(n + "_" + "p_name", loadGenProfilingPoint.getName());
        properties.put(n + "_" + "p_enabled", Boolean.toString(loadGenProfilingPoint.isEnabled()));
        properties.put(n + "_" + "p_ScriptName", loadGenProfilingPoint.getScriptFileName());
        loadGenProfilingPoint.getStartLocation().store(loadGenProfilingPoint.getProject(), n, START_LOCATION_PREFIX, properties);
        if (loadGenProfilingPoint.usesEndLocation()) {
            loadGenProfilingPoint.getEndLocation().store(loadGenProfilingPoint.getProject(), n, END_LOCATION_PREFIX, properties);
        }
    }
}

