/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class OpenHeapWalkerAction
extends SystemAction {
    private static final String ACTION_NAME = NbBundle.getMessage(OpenHeapWalkerAction.class, (String)"OpenHeapWalkerAction_ActionName");
    private static final String DIALOG_CAPTION = NbBundle.getMessage(OpenHeapWalkerAction.class, (String)"OpenHeapWalkerAction_DialogCaption");
    private static File importDir;

    public OpenHeapWalkerAction() {
        this.putValue("noIconInMenu", null);
        this.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png", (boolean)true)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenHeapWalkerAction.class);
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final File file = OpenHeapWalkerAction.getHeapDumpFile();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (file != null) {
                    HeapWalkerManager.getDefault().openHeapWalker(file);
                }
            }
        });
    }

    private static File getHeapDumpFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (importDir != null) {
            jFileChooser.setCurrentDirectory(importDir);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(DIALOG_CAPTION);
        if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0) {
            importDir = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

