/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.panels.ProgressDisplayer;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.OutputParameter;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class ProjectSensitiveAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    protected volatile boolean actionEnabled = false;
    private final Lookup lookup;
    private final Object initLock = new Object();
    private final Object refreshRequestLock = new Object();
    private final ProfilerProjectActionPerformer performer;
    private final String namePattern;
    private final LookupListener[] resultListeners;
    private final Class[] watch;
    private volatile boolean isCalculated = false;
    private int refreshRequested = 0;

    ProjectSensitiveAction(ProfilerProjectActionPerformer profilerProjectActionPerformer, String string, String string2, Icon icon, Lookup lookup) {
        super(string);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
        if (lookup == null) {
            lookup = Utilities.actionsGlobalContext();
        }
        this.lookup = lookup;
        this.watch = new Class[]{Project.class, DataObject.class};
        this.resultListeners = new LookupListener[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            Lookup.Result result = lookup.lookup(new Lookup.Template(this.watch[i]));
            result.addLookupListener((LookupListener)this);
        }
        this.performer = profilerProjectActionPerformer;
        this.namePattern = string2;
        this.init();
    }

    public final boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.actionPerformed(this.lookup);
    }

    public static ProjectSensitiveAction projectSensitiveAction(ProfilerProjectActionPerformer profilerProjectActionPerformer, String string, String string2, Icon icon) {
        return new ProjectSensitiveAction(profilerProjectActionPerformer, string, string2, icon, null);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ProjectSensitiveAction(this.getPerformer(), this.getName(), this.getNamePattern(), (Icon)this.getValue("SmallIcon"), lookup);
    }

    public final void resultChanged(LookupEvent lookupEvent) {
        this.isCalculated = false;
    }

    protected final void setDisplayName(String string) {
        this.putValue("Name", string);
    }

    protected final String getName() {
        return (String)this.getValue("Name");
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    protected final ProfilerProjectActionPerformer getPerformer() {
        return this.performer;
    }

    protected void actionPerformed(final Lookup lookup) {
        final Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length == 1 && this.performer != null) {
            new NBSwingWorker(false){
                private boolean isEnabled;
                private final OutputParameter<Boolean> isCancelled;
                private final OutputParameter<ProgressDisplayer> progress;
                {
                    super(bl);
                    this.isEnabled = false;
                    this.isCancelled = new OutputParameter<Boolean>(Boolean.FALSE);
                    this.progress = new OutputParameter<Object>(null);
                }

                protected void doInBackground() {
                    this.isEnabled = ProjectSensitiveAction.this.performer.enable(projectArray[0], lookup, false);
                }

                protected void done() {
                    if (this.progress.isSet()) {
                        this.progress.getValue().close();
                    }
                    if (this.isEnabled && !this.isCancelled.getValue().booleanValue()) {
                        ProjectSensitiveAction.this.performer.perform(projectArray[0], lookup);
                    } else if (!this.isCancelled.getValue().booleanValue()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResourceBundle.getBundle("org/netbeans/modules/profiler/actions/Bundle").getString("AntActions_LazyEnablementFailure"));
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    }
                }

                protected void nonResponding() {
                    this.progress.setValue(ProgressDisplayer.showProgress(ResourceBundle.getBundle("org/netbeans/modules/profiler/actions/Bundle").getString("AntActions_LazyEnablementProgressMessage"), new ProgressDisplayer.ProgressController(){

                        public boolean cancel() {
                            if (progress.isSet()) {
                                ((ProgressDisplayer)progress.getValue()).close();
                            }
                            progress.setValue(null);
                            isCancelled.setValue(true);
                            return true;
                        }
                    }));
                }
            }.execute();
        }
    }

    protected void doRefresh(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        this.setDisplayName(ActionsUtil.formatProjectSensitiveName(this.getNamePattern(), projectArray));
        if (projectArray != null && projectArray.length > 0) {
            this.setEnabled(this.getPerformer().enable(projectArray[0], lookup, true));
        } else {
            this.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.isCalculated) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.isCalculated) {
                return;
            }
            this.refresh(this.lookup);
            this.isCalculated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(final Lookup lookup) {
        Object object = this.refreshRequestLock;
        synchronized (object) {
            if (this.refreshRequested++ > 0) {
                return;
            }
            IDEUtils.runInEventDispatchThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n = -1;
                    int n2 = -1;
                    Object object = ProjectSensitiveAction.this.refreshRequestLock;
                    synchronized (object) {
                        n = ProjectSensitiveAction.this.refreshRequested;
                    }
                    ProjectSensitiveAction.this.doRefresh(ProjectSensitiveAction.this.lookup);
                    object = ProjectSensitiveAction.this.refreshRequestLock;
                    synchronized (object) {
                        n2 = ProjectSensitiveAction.this.refreshRequested;
                        ProjectSensitiveAction.this.refreshRequested = 0;
                    }
                    if (n != n2) {
                        ProjectSensitiveAction.this.refresh(lookup);
                    }
                }
            });
        }
    }

    public static final class ActionsUtil {
        public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            Collection collection = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
            for (DataObject dataObject : collection) {
                FileObject fileObject = dataObject.getPrimaryFile();
                Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project2 == null || !project2.equals(project)) continue;
                hashSet.add(fileObject);
            }
            FileObject[] fileObjectArray = new FileObject[hashSet.size()];
            hashSet.toArray(fileObjectArray);
            return fileObjectArray;
        }

        public static Project[] getProjectsFromLookup(Lookup lookup, String string) {
            Object object2;
            HashSet<Project> hashSet = new HashSet<Project>();
            Collection collection = lookup.lookup(new Lookup.Template(Project.class)).allInstances();
            for (Object object2 : collection) {
                hashSet.add((Project)object2);
            }
            Collection collection2 = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances();
            object2 = collection2.iterator();
            while (object2.hasNext()) {
                DataObject dataObject = (DataObject)object2.next();
                FileObject fileObject = dataObject.getPrimaryFile();
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project == null) continue;
                hashSet.add(project);
            }
            object2 = new Project[hashSet.size()];
            hashSet.toArray((T[])object2);
            if (string != null) {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (ActionsUtil.commandSupported((Project)object2[i], string, lookup)) continue;
                    return new Project[0];
                }
            }
            return object2;
        }

        public static boolean commandSupported(Project project, String string, Lookup lookup) {
            List<String> list;
            ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            return actionProvider != null && (list = Arrays.asList(actionProvider.getSupportedActions())).contains(string) && (lookup == null || actionProvider.isActionEnabled(string, lookup));
        }

        public static String formatName(String string, int n, String string2) {
            return MessageFormat.format(string, new Integer(n), string2 == null ? "" : string2);
        }

        public static String formatProjectSensitiveName(String string, Project[] projectArray) {
            if (projectArray == null || projectArray.length == 0) {
                return ActionsUtil.formatName(string, 0, null);
            }
            return ActionsUtil.formatName(string, projectArray.length, ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName());
        }
    }

    public static interface ProfilerProjectActionPerformer {
        public boolean enable(Project var1, Lookup var2, boolean var3);

        public void perform(Project var1, Lookup var2);
    }
}

