/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.CombinedPanel;
import org.netbeans.lib.profiler.ui.cpu.ReverseCallGraphPanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.ExportSnapshotAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class CPUSnapshotPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider {
    private static final String METHODS_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_MethodsString");
    private static final String CLASSES_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ClassesString");
    private static final String PACKAGES_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_PackagesString");
    private static final String CALLTREE_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CallTreeString");
    private static final String HOTSPOTS_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_HotSpotsString");
    private static final String COMBINED_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CombinedString");
    private static final String INFO_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_InfoString");
    private static final String CALLTREE_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CallTreeTabDescr");
    private static final String HOTSPOT_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_HotSpotTabDescr");
    private static final String COMBINED_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CombinedTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_InfoTabDescr");
    private static final String ALL_THREADS_ITEM = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AllThreadsItem");
    private static final String VIEW_LABEL_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ViewLabelString");
    private static final String TOGGLE_DOWN_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ToggleDownToolTip");
    private static final String TOGGLE_UP_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ToggleUpToolTip");
    private static final String PANEL_TITLE = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_PanelTitle");
    private static final String FIND_IN_STATEMENT = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_FindInStatement");
    private static final String AGGREGATION_COMBO_ACCESS_NAME = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AggregationComboAccessName");
    private static final String AGGREGATION_COMBO_ACCESS_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AggregationComboAccessDescr");
    private static final String THREADS_COMBO_ACCESS_NAME = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ThreadsComboAccessName");
    private static final String THREADS_COMBO_ACCESS_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ThreadsComboAccessDescr");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_FindActionTooltip");
    private static final String FIND_IN_HOTSPOTS_STRING = MessageFormat.format(FIND_IN_STATEMENT, HOTSPOTS_STRING);
    private static final String FIND_IN_CALLTREE_STRING = MessageFormat.format(FIND_IN_STATEMENT, CALLTREE_STRING);
    private static final ImageIcon CLASSES_ICON = Utils.CLASS_ICON;
    private static final ImageIcon METHODS_ICON = Utils.METHODS_ICON;
    private static final ImageIcon PACKAGES_ICON = Utils.PACKAGE_ICON;
    private static final ImageIcon CALL_TREE_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/callTreeTab.png"));
    private static final ImageIcon HOTSPOTS_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/hotspotsTab.png"));
    private static final ImageIcon COMBINED_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/combinedTab.png"));
    private static final ImageIcon INFO_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));
    private static final ImageIcon BACK_TRACES_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/backTracesTab.png"));
    private static final ImageIcon SUBTREE_TAB_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/subtree.png"));
    private static final ImageIcon SLAVE_DOWN_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/slaveDown.png"));
    private static final ImageIcon SLAVE_UP_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/slaveUp.png"));
    private static final double SPLIT_HALF = 0.5;
    private CCTDisplay cctPanel;
    private CCTDisplay combinedCCT;
    private CPUResultsSnapshot snapshot;
    private CombinedPanel combined;
    private CombinedViewTracker combinedViewTracker;
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private JComboBox aggregationCombo;
    private JComboBox threadsCombo;
    private JTabbedPane tabs = new JTabbedPane(3);
    private JToggleButton slaveToggleButtonDown;
    private JToggleButton slaveToggleButtonUp;
    private LoadedSnapshot loadedSnapshot;
    private ReverseCallGraphPanel backtraceView;
    private SaveSnapshotAction saveAction;
    private SnapshotFlatProfilePanel combinedFlat;
    private SnapshotFlatProfilePanel flatPanel;
    private SnapshotInfoPanel infoPanel;
    private SubtreeCallGraphPanel subtreeView;
    private int[] threadIds;
    private boolean internalChange = false;
    private boolean internalFilterChange = false;
    private boolean internalSelChange = false;
    private boolean slaveModeDown = true;
    private boolean slaveModeUp = true;
    private int currentAggregationMode;

    public CPUSnapshotPanel(LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        this.loadedSnapshot = loadedSnapshot;
        this.snapshot = (CPUResultsSnapshot)loadedSnapshot.getSnapshot();
        CPUActionsHandler cPUActionsHandler = new CPUActionsHandler();
        CPUSnapshotSelectionHandler cPUSnapshotSelectionHandler = new CPUSnapshotSelectionHandler(true);
        CPUSnapshotSelectionHandler cPUSnapshotSelectionHandler2 = new CPUSnapshotSelectionHandler(false);
        this.setLayout(new BorderLayout());
        this.flatPanel = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)cPUActionsHandler);
        this.cctPanel = new CCTDisplay((CPUResUserActionsHandler)cPUActionsHandler);
        this.infoPanel = new SnapshotInfoPanel(loadedSnapshot);
        this.combinedFlat = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)cPUActionsHandler, (CPUSelectionHandler)cPUSnapshotSelectionHandler2);
        this.combinedCCT = new CCTDisplay((CPUResUserActionsHandler)cPUActionsHandler, (CPUSelectionHandler)cPUSnapshotSelectionHandler);
        this.flatPanel.setSorting(n, bl);
        this.cctPanel.setSorting(n, bl);
        this.combinedFlat.setSorting(n, bl);
        this.combinedCCT.setSorting(n, bl);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(FIND_IN_HOTSPOTS_STRING);
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(FIND_IN_CALLTREE_STRING);
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        if (this.combinedFlat.getPopupFindItem() != null) {
            this.combinedFlat.getPopupFindItem().setText(FIND_IN_CALLTREE_STRING);
            this.combinedFlat.getPopupFindItem().setVisible(true);
        }
        if (this.combinedCCT.getPopupFindItem() != null) {
            this.combinedCCT.getPopupFindItem().setText(FIND_IN_HOTSPOTS_STRING);
            this.combinedCCT.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay(this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay(this.snapshot, 0);
        this.combinedFlat.setDataToDisplay(this.snapshot, -1, 0);
        this.combinedCCT.setDataToDisplay(this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.infoPanel.updateInfo();
        this.flatPanel.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.combinedFlat.setFilterValues(CPUSnapshotPanel.this.flatPanel.getFilterValue(), CPUSnapshotPanel.this.flatPanel.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combinedFlat.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.flatPanel.setFilterValues(CPUSnapshotPanel.this.combinedFlat.getFilterValue(), CPUSnapshotPanel.this.combinedFlat.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combined = new CombinedPanel(0, (Component)this.combinedCCT, (Component)this.combinedFlat){

            public void requestFocus() {
                if (CPUSnapshotPanel.this.combinedCCT != null) {
                    CPUSnapshotPanel.this.combinedCCT.requestFocus();
                }
            }
        };
        this.combined.setResizeWeight(0.5);
        this.combined.setBorder(BorderFactory.createEmptyBorder());
        this.combined.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                CPUSnapshotPanel.this.combined.setDividerLocation(0.5);
            }
        });
        this.tabs.addTab(CALLTREE_STRING, CALL_TREE_TAB_ICON, (Component)this.cctPanel, CALLTREE_TAB_DESCR);
        this.tabs.addTab(HOTSPOTS_STRING, HOTSPOTS_TAB_ICON, (Component)this.flatPanel, HOTSPOT_TAB_DESCR);
        this.tabs.addTab(COMBINED_STRING, COMBINED_TAB_ICON, (Component)this.combined, COMBINED_TAB_DESCR);
        this.tabs.addTab(INFO_STRING, INFO_TAB_ICON, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        JToolBar jToolBar = new JToolBar(){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        jToolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.saveAction = new SaveSnapshotAction(this.loadedSnapshot);
        jToolBar.add(this.saveAction);
        jToolBar.add(new ExportSnapshotAction(this.loadedSnapshot));
        jToolBar.add(new SaveViewAction(this));
        jToolBar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{METHODS_STRING, CLASSES_STRING, PACKAGES_STRING}){

            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(AGGREGATION_COMBO_ACCESS_NAME);
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(AGGREGATION_COMBO_ACCESS_DESCR);
        this.currentAggregationMode = 0;
        String[] stringArray = this.snapshot.getThreadNames();
        Object[] objectArray = new Object[stringArray.length + 1];
        objectArray[0] = new Object(){

            public String toString() {
                return ALL_THREADS_ITEM;
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            final String string = stringArray[i];
            objectArray[i + 1] = new Object(){

                public String toString() {
                    return string;
                }
            };
        }
        this.threadIds = this.snapshot.getThreadIds();
        this.threadsCombo = new JComboBox(objectArray){

            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 50, this.getPreferredSize().height);
            }
        };
        this.threadsCombo.getAccessibleContext().setAccessibleName(THREADS_COMBO_ACCESS_NAME);
        this.threadsCombo.getAccessibleContext().setAccessibleDescription(THREADS_COMBO_ACCESS_DESCR);
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object == METHODS_STRING) {
                    defaultListCellRenderer.setIcon(METHODS_ICON);
                } else if (object == CLASSES_STRING) {
                    defaultListCellRenderer.setIcon(CLASSES_ICON);
                } else if (object == PACKAGES_STRING) {
                    defaultListCellRenderer.setIcon(PACKAGES_ICON);
                }
                return defaultListCellRenderer;
            }
        });
        JLabel jLabel = new JLabel(VIEW_LABEL_STRING);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        jLabel.setLabelFor(this.aggregationCombo);
        int n2 = 0;
        jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n2));
        jLabel.setDisplayedMnemonicIndex(n2);
        jToolBar.add(jLabel);
        jToolBar.add(this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        jToolBar.addSeparator(new Dimension(6, 0));
        this.slaveToggleButtonDown = new JToggleButton(SLAVE_DOWN_ICON);
        this.slaveToggleButtonDown.setSelected(this.slaveModeDown);
        this.slaveToggleButtonDown.addActionListener(this);
        this.slaveToggleButtonDown.setToolTipText(TOGGLE_DOWN_TOOLTIP);
        this.slaveToggleButtonDown.getAccessibleContext().setAccessibleName(TOGGLE_DOWN_TOOLTIP);
        jToolBar.add(this.slaveToggleButtonDown);
        this.slaveToggleButtonUp = new JToggleButton(SLAVE_UP_ICON);
        this.slaveToggleButtonUp.setSelected(this.slaveModeUp);
        this.slaveToggleButtonUp.addActionListener(this);
        this.slaveToggleButtonUp.setToolTipText(TOGGLE_UP_TOOLTIP);
        this.slaveToggleButtonUp.getAccessibleContext().setAccessibleName(TOGGLE_UP_TOOLTIP);
        jToolBar.add(this.slaveToggleButtonUp);
        jToolBar.add(this.threadsCombo);
        this.threadsCombo.addActionListener(this);
        jToolBar.addSeparator();
        this.findActionPresenter = jToolBar.add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = jToolBar.add(new FindPreviousAction(this));
        this.findNextPresenter = jToolBar.add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton jButton = this.findActionPresenter;
            jButton.setIcon(Utils.FIND_ACTION_ICON);
            jButton.setText("");
            jButton.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add((Component)jToolBar, "North");
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.moveToNextSubTab();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.performFindNext();
            }
        });
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    public BufferedImage getViewImage(boolean bl) {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)this.tabs.getSelectedComponent()).getCurrentViewScreenshot(bl);
    }

    public String getViewName() {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return null;
        }
        String string = ((ScreenshotProvider)this.tabs.getSelectedComponent()).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.aggregationCombo) {
            Object object2 = this.aggregationCombo.getSelectedItem();
            if (object2 == METHODS_STRING) {
                this.changeView(0);
            } else if (object2 == CLASSES_STRING) {
                this.changeView(1);
            } else if (object2 == PACKAGES_STRING) {
                this.changeView(2);
            }
        } else if (object == this.threadsCombo) {
            assert (this.tabs.getSelectedComponent() == this.flatPanel);
            int n = -1;
            if (this.threadsCombo.getSelectedIndex() > 0) {
                n = this.threadIds[this.threadsCombo.getSelectedIndex() - 1];
            }
            if (this.flatPanel.getCurrentThreadId() != n) {
                this.flatPanel.setDataToDisplay(this.snapshot, n, this.flatPanel.getCurrentView());
                this.flatPanel.prepareResults();
            }
        } else if (object == this.slaveToggleButtonDown) {
            this.slaveModeDown = this.slaveToggleButtonDown.isSelected();
        } else if (object == this.slaveToggleButtonUp) {
            this.slaveModeUp = this.slaveToggleButtonUp.isSelected();
        }
    }

    public void changeView(int n) {
        if (this.currentAggregationMode == n) {
            return;
        }
        this.currentAggregationMode = n;
        this.flatPanel.changeView(n);
        this.cctPanel.changeView(n);
        this.combinedCCT.changeView(n);
        this.combinedFlat.changeView(n);
        this.viewChanged(n);
    }

    public boolean fitsVisibleArea() {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)this.tabs.getSelectedComponent()).fitsVisibleArea();
    }

    public boolean hasView() {
        return this.tabs.getSelectedComponent() != null && this.tabs.getSelectedComponent() instanceof ScreenshotProvider;
    }

    public void performFind() {
        if (this.tabs.getSelectedComponent() != this.infoPanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.setFindString(string);
            this.performFindFirst();
        }
    }

    public void performFindFirst() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findFirst();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findFirst();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findFirst();
        }
        if (!bl) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindNext() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findNext();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findNext();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findNext();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findNext();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findNext();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findNext();
        }
        if (!bl) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindPrevious() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findPrevious();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findPrevious();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findPrevious();
        }
        if (!bl) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
        if (this.tabs.getSelectedComponent() != null) {
            this.tabs.getSelectedComponent().requestFocus();
        }
    }

    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot resultsSnapshot) {
        return "snapshot-" + resultsSnapshot.getTimeTaken();
    }

    private void setFindString(String string) {
        this.cctPanel.setFindString(string);
        this.flatPanel.setFindString(string);
        this.combinedFlat.setFindString(string);
        this.combinedCCT.setFindString(string);
        if (this.backtraceView != null) {
            this.backtraceView.setFindString(string);
        }
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(string);
        }
    }

    private void closeReverseCallsGraphs() {
        if (this.backtraceView != null) {
            this.tabs.remove((Component)this.backtraceView);
            this.backtraceView = null;
        }
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
        this.threadsCombo.setVisible(this.tabs.getSelectedComponent() == this.flatPanel);
        this.slaveToggleButtonDown.setVisible(this.tabs.getSelectedComponent() == this.combined);
        this.slaveToggleButtonUp.setVisible(this.tabs.getSelectedComponent() == this.combined);
        this.aggregationCombo.setEnabled(this.tabs.getSelectedComponent() != this.backtraceView && this.tabs.getSelectedComponent() != this.infoPanel && this.tabs.getSelectedComponent() != this.subtreeView);
        boolean bl = this.tabs.getSelectedComponent() != this.infoPanel;
        this.findActionPresenter.setEnabled(bl);
        this.findPreviousPresenter.setEnabled(bl);
        this.findNextPresenter.setEnabled(bl);
    }

    private void viewChanged(int n) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (n) {
            case 2: {
                this.aggregationCombo.setSelectedItem(PACKAGES_STRING);
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(CLASSES_STRING);
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(METHODS_STRING);
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
    }

    private class CombinedViewTracker
    extends FocusAdapter {
        private Object lastFocusOwner;

        private CombinedViewTracker() {
        }

        public Object getLastFocusOwner() {
            return this.lastFocusOwner;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.lastFocusOwner = focusEvent.getSource();
        }
    }

    private final class CPUSnapshotSelectionHandler
    implements CPUSelectionHandler {
        private boolean cct;

        private CPUSnapshotSelectionHandler(boolean bl) {
            this.cct = bl;
        }

        public void methodSelected(int n, int n2, int n3) {
            if (CPUSnapshotPanel.this.internalSelChange) {
                return;
            }
            if (n2 == -1) {
                return;
            }
            if (this.cct) {
                if (n >= -1 && CPUSnapshotPanel.this.combinedFlat.getCurrentThreadId() != n) {
                    CPUSnapshotPanel.this.combinedFlat.setDataToDisplay(CPUSnapshotPanel.this.combinedFlat.getSnapshot(), n, n3);
                    CPUSnapshotPanel.this.combinedFlat.prepareResults();
                }
                if (CPUSnapshotPanel.this.slaveModeDown) {
                    if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                        CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(false);
                    }
                    CPUSnapshotPanel.this.internalSelChange = true;
                    CPUSnapshotPanel.this.combinedFlat.selectMethod(n2);
                    CPUSnapshotPanel.this.internalSelChange = false;
                } else if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(true);
                }
            } else if (CPUSnapshotPanel.this.slaveModeUp) {
                if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(false);
                }
                int n4 = CPUSnapshotPanel.this.combinedFlat.getCurrentView();
                String[] stringArray = CPUSnapshotPanel.this.snapshot.getMethodClassNameAndSig(n2, n4);
                CPUSnapshotPanel.this.combinedCCT.setFindString(MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(stringArray[0], stringArray[1], stringArray[2]).toFormatted());
                CPUSnapshotPanel.this.internalSelChange = true;
                CPUSnapshotPanel.this.combinedCCT.silentlyFindFirst();
                CPUSnapshotPanel.this.internalSelChange = false;
            } else if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(true);
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String string, String string2, String string3) {
            Project project = CPUSnapshotPanel.this.loadedSnapshot.getProject();
            ProfilingSettings profilingSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
            ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings profilingSettings2 : profilingSettings) {
                if (!org.netbeans.modules.profiler.ui.stp.Utils.isCPUSettings(profilingSettings2.getProfilingType())) continue;
                arrayList.add(profilingSettings2);
            }
            ProfilingSettings profilingSettings3 = IDEUtils.selectSettings(project, 16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
            if (profilingSettings3 == null) {
                return;
            }
            profilingSettings3.addRootMethod(string, string2, string3);
            if (arrayList.contains(profilingSettings3)) {
                ProfilingSettingsManager.getDefault().storeProfilingSettings((ProfilingSettings[])profilingSettings, profilingSettings3, project);
            } else {
                ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[((ProfilingSettings)profilingSettings).length + 1];
                System.arraycopy(profilingSettings, 0, profilingSettingsArray, 0, ((ProfilingSettings)profilingSettings).length);
                profilingSettingsArray[((ProfilingSettings)profilingSettings).length] = profilingSettings3;
                ProfilingSettingsManager.getDefault().storeProfilingSettings(profilingSettingsArray, profilingSettings3, project);
            }
        }

        public void find(Object object, String string) {
            if (object == CPUSnapshotPanel.this.cctPanel) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.flatPanel);
                CPUSnapshotPanel.this.flatPanel.selectMethod(string);
            } else if (object == CPUSnapshotPanel.this.flatPanel) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.cctPanel);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (object == CPUSnapshotPanel.this.combinedFlat) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (object == CPUSnapshotPanel.this.combinedCCT) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.combinedFlat.selectMethod(string);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2, int n3, int n4, boolean bl) {
            if (CPUSnapshotPanel.this.backtraceView != null) {
                CPUSnapshotPanel.this.tabs.remove((Component)CPUSnapshotPanel.this.backtraceView);
            }
            CPUSnapshotPanel.this.backtraceView = new ReverseCallGraphPanel((CPUResUserActionsHandler)this);
            CPUSnapshotPanel.this.backtraceView.setDataToDisplay(cPUResultsSnapshot, n, n3);
            CPUSnapshotPanel.this.backtraceView.setSelectedMethodId(n2);
            CPUSnapshotPanel.this.backtraceView.setSorting(n4, bl);
            CPUSnapshotPanel.this.backtraceView.prepareResults();
            CPUSnapshotPanel.this.backtraceView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.tabs.addTab(CPUSnapshotPanel.this.backtraceView.getShortTitle(), BACK_TRACES_TAB_ICON, (Component)CPUSnapshotPanel.this.backtraceView, CPUSnapshotPanel.this.backtraceView.getTitle());
            CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.backtraceView);
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            NetBeansProfiler.getDefaultNB().openJavaSource(CPUSnapshotPanel.this.loadedSnapshot.getProject(), string, string2, string3);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot cPUResultsSnapshot, CCTNode cCTNode, int n, int n2, boolean bl) {
            if (!(cCTNode instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUSnapshotPanel.this.subtreeView != null) {
                CPUSnapshotPanel.this.tabs.remove((Component)CPUSnapshotPanel.this.subtreeView);
            }
            CPUSnapshotPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this);
            CPUSnapshotPanel.this.subtreeView.setDataToDisplay(cPUResultsSnapshot, (PrestimeCPUCCTNode)cCTNode, n);
            CPUSnapshotPanel.this.subtreeView.setSorting(n2, bl);
            CPUSnapshotPanel.this.subtreeView.prepareResults();
            CPUSnapshotPanel.this.subtreeView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.tabs.addTab(CPUSnapshotPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, (Component)CPUSnapshotPanel.this.subtreeView, CPUSnapshotPanel.this.subtreeView.getTitle());
            CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.subtreeView);
        }
    }
}

