/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectTypeProfiler
implements ProjectTypeProfiler {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.spi.ProjectTypeProfiler");

    @Override
    public abstract String getProfilerTargetName(Project var1, FileObject var2, int var3, FileObject var4);

    @Override
    public abstract boolean isProfilingSupported(Project var1);

    @Override
    public JComponent getAdditionalConfigurationComponent(Project project) {
        return null;
    }

    @Override
    public boolean isAttachSupported(Project project) {
        return true;
    }

    @Override
    public ClientUtils.SourceCodeSelection[] getDefaultRootMethods(Project project, FileObject fileObject, boolean bl, String[][] stringArray) {
        if (bl) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        if (fileObject == null) {
            return ProjectUtilities.getProjectDefaultRoots((Project)project, (String[][])stringArray);
        }
        String string = SourceUtils.getToplevelClassName((FileObject)fileObject);
        return new ClientUtils.SourceCodeSelection[]{new ClientUtils.SourceCodeSelection(string, "<all>", "")};
    }

    @Override
    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        return true;
    }

    @Override
    public abstract boolean checkProjectCanBeProfiled(Project var1, FileObject var2);

    @Override
    public abstract boolean checkProjectIsModifiedForProfiler(Project var1);

    @Override
    public List<SimpleFilter> getPredefinedInstrumentationFilters(Project project) {
        return ProjectUtilities.getProjectDefaultInstrFilters((Project)project);
    }

    @Override
    public float getProfilingOverhead(ProfilingSettings profilingSettings) {
        float f = 0.0f;
        if (!Utils.isMonitorSettings(profilingSettings)) {
            if (Utils.isCPUSettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 8) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 16) {
                    f += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(profilingSettings.getSelectedInstrumentationFilter())) {
                    f += 0.5f;
                }
            } else if (Utils.isMemorySettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 2) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 4) {
                    f += 0.7f;
                }
                if (profilingSettings.getAllocStackTraceLimit() != 0) {
                    f += 0.3f;
                }
            }
        }
        return f;
    }

    @Override
    public FileObject getProjectBuildScript(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    @Override
    public JavaPlatform getProjectJavaPlatform(Project project) {
        return null;
    }

    @Override
    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        return DefaultSettingsConfigurator.SHARED_INSTANCE;
    }

    @Override
    public SimpleFilter computePredefinedInstrumentationFilter(Project project, SimpleFilter simpleFilter, String[][] stringArray) {
        return ProjectUtilities.computeProjectOnlyInstrumentationFilter((Project)project, (SimpleFilter)simpleFilter, (String[][])stringArray);
    }

    @Override
    public void computeProjectPackages(Project project, boolean bl, String[][] stringArray) {
        ProjectUtilities.computeProjectPackages((Project)project, (boolean)bl, (String[][])stringArray);
    }

    @Override
    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
    }

    @Override
    public void setupProjectSessionSettings(Project project, SessionSettings sessionSettings) {
    }

    @Override
    public boolean supportsSettingsOverride() {
        return false;
    }

    @Override
    public boolean supportsUnintegrate(Project project) {
        return false;
    }

    @Override
    public void unintegrateProfiler(Project project) {
    }

    @Override
    public boolean startProfilingSession(Project project, FileObject fileObject, boolean bl, Properties properties) {
        return false;
    }
}

