/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.support;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.identity.profile.ui.support.AbstractTask;
import org.netbeans.modules.identity.profile.ui.support.J2eeProjectHelper;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2ee15ProjectHelper
extends J2eeProjectHelper {
    private static final String SERVICE_SUFFIX = "Service";
    private static final String WEB_FOLDER = "web";
    private static final String JAVA_EXT = "java";
    private static final String CONF_FOLDER = "conf";
    private static final String TEST_FOLDER = "test";
    private String portComponentName;
    private String serviceDescriptionName;
    private List<String> serviceRefNames;
    private List<ServiceRef> serviceRefs;

    protected J2ee15ProjectHelper(Node node, JaxWsModel jaxWsModel) {
        super(node, jaxWsModel);
    }

    @Override
    public List<String> getAllServiceRefNames() {
        if (this.serviceRefNames == null) {
            this.serviceRefNames = new ArrayList<String>();
            this.serviceRefs = new ArrayList<ServiceRef>();
            List<ServiceRef> list = this.getServiceRefsFromSources();
            String string = this.getClient().getWsdlUrl();
            for (ServiceRef serviceRef : list) {
                if (!serviceRef.getWsdlLocation().equals(string)) continue;
                this.serviceRefNames.add(serviceRef.getName());
                this.serviceRefs.add(serviceRef);
            }
        }
        return this.serviceRefNames;
    }

    private String getClassName(JavaSource javaSource) {
        final String[] stringArray = new String[1];
        try {
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree classTree = J2ee15ProjectHelper.this.getTopLevelClassTree(compilationController);
                    stringArray[0] = classTree.getSimpleName().toString();
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray[0];
    }

    private String getServiceName(JavaSource javaSource) {
        final String[] stringArray = new String[1];
        try {
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = J2ee15ProjectHelper.this.getTopLevelClassElement(compilationController);
                    if (typeElement != null) {
                        List<? extends AnnotationMirror> list = compilationController.getElements().getAllAnnotationMirrors(typeElement);
                        for (AnnotationMirror annotationMirror : list) {
                            if (!annotationMirror.toString().startsWith("@javax.jws.WebService")) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (ExecutableElement executableElement : map.keySet()) {
                                if (!executableElement.getSimpleName().toString().equals("serviceName")) continue;
                                String string = ((Object)map.get(executableElement)).toString();
                                stringArray[0] = string.replace("\"", "");
                                return;
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray[0];
    }

    private List<ServiceRef> getServiceRefsFromSources() {
        FileObject[] fileObjectArray = this.getProvider().getSourceRoots();
        ArrayList<ServiceRef> arrayList = new ArrayList<ServiceRef>();
        for (FileObject fileObject : fileObjectArray) {
            String string = fileObject.getName();
            if (string.equals(CONF_FOLDER) || string.equals(WEB_FOLDER) || string.equals(TEST_FOLDER)) continue;
            Enumeration enumeration = fileObject.getData(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!fileObject2.getExt().equals(JAVA_EXT)) continue;
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
                arrayList.addAll(this.getServiceRefsFromSource(javaSource));
            }
        }
        return arrayList;
    }

    private List<ServiceRef> getServiceRefsFromSource(JavaSource javaSource) {
        final ArrayList<ServiceRef> arrayList = new ArrayList<ServiceRef>();
        try {
            javaSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = J2ee15ProjectHelper.this.getTopLevelClassElement(compilationController);
                    List<VariableElement> list = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
                    block0: for (VariableElement variableElement : list) {
                        List<? extends AnnotationMirror> list2 = variableElement.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : list2) {
                            if (!annotationMirror.toString().startsWith("@javax.xml.ws.WebServiceRef")) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (ExecutableElement executableElement : map.keySet()) {
                                if (!executableElement.getSimpleName().toString().equals("wsdlLocation")) continue;
                                String string = ((Object)map.get(executableElement)).toString().replace("\"", "");
                                String string2 = typeElement.getQualifiedName().toString() + "/" + variableElement.getSimpleName().toString();
                                String string3 = typeElement.getSimpleName().toString();
                                arrayList.add(new ServiceRef(string2, string, string3));
                            }
                            continue block0;
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private ClassTree getTopLevelClassTree(CompilationController compilationController) {
        String string = compilationController.getFileObject().getName();
        List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
        for (Tree tree : list) {
            ClassTree classTree;
            if (tree.getKind() != Tree.Kind.CLASS || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(string) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
            return classTree;
        }
        return null;
    }

    private TypeElement getTopLevelClassElement(CompilationController compilationController) {
        ClassTree classTree = this.getTopLevelClassTree(compilationController);
        Trees trees = compilationController.getTrees();
        TreePath treePath = trees.getPath(compilationController.getCompilationUnit(), classTree);
        return (TypeElement)trees.getElement(treePath);
    }

    private static class ServiceRef {
        private String name;
        private String wsdlLocation;
        private String className;

        public ServiceRef(String string, String string2, String string3) {
            this.name = string;
            this.wsdlLocation = string2;
            this.className = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getWsdlLocation() {
            return this.wsdlLocation;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

