/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEBaseVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.J2EEVersion;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.ddloaders.DDType;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.appclient.SunAppClientOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.EnvironmentMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.SecurityRoleMappingMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.EjbMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb.SunEjbOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.jms.JmsMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.ServletMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.web.SunWebOverviewMultiViewElement;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice.WebServiceMultiViewElement;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class DDViewFactory
implements Serializable {
    private static final long serialVersionUID = -8759598009819101743L;
    public static final String OVERVIEW = "Overview";
    public static final String SERVLET = "Servlet";
    public static final String EJB = "EJB";
    public static final String SECURITY = "Security";
    public static final String WSSERVICE = "WSService";
    public static final String JMS = "JMS";
    public static final String ENVIRONMENT = "Environment";
    private static transient Map<DDType, DDViewFactory> factoryMap = new HashMap<DDType, DDViewFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDViewFactory getViewFactory(DDType dDType) {
        DDViewFactory dDViewFactory = null;
        Map<DDType, DDViewFactory> map = factoryMap;
        synchronized (map) {
            dDViewFactory = factoryMap.get(dDType);
            if (dDViewFactory == null) {
                dDViewFactory = dDType.createViewFactory();
                factoryMap.put(dDType, dDViewFactory);
            }
        }
        return dDViewFactory;
    }

    public abstract DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject var1);

    public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
        if (string.equals(SECURITY)) {
            return new SecurityRoleMappingMultiViewElement(sunDescriptorDataObject);
        }
        if (string.equals(ENVIRONMENT)) {
            return new EnvironmentMultiViewElement(sunDescriptorDataObject);
        }
        if (string.equals(WSSERVICE)) {
            return new WebServiceMultiViewElement(sunDescriptorDataObject);
        }
        if (string.equals(JMS)) {
            return new JmsMultiViewElement(sunDescriptorDataObject);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    class DDView
    extends DesignMultiViewDesc
    implements Serializable {
        private static final long serialVersionUID = -8759598009819101741L;
        private String name;

        DDView(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            super((XmlMultiViewDataObject)sunDescriptorDataObject, string);
            this.name = string;
        }

        public MultiViewElement createElement() {
            SunDescriptorDataObject sunDescriptorDataObject = (SunDescriptorDataObject)this.getDataObject();
            return DDViewFactory.this.createElement(sunDescriptorDataObject, this.name);
        }

        public HelpCtx getHelpCtx() {
            SunDescriptorDataObject sunDescriptorDataObject = (SunDescriptorDataObject)this.getDataObject();
            return new HelpCtx(sunDescriptorDataObject.getActiveMVElement().getSectionView().getClass());
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon.gif");
        }

        public String preferredID() {
            return "sundd_multiview_" + this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DDViewFactory.class, (String)("LBL_" + this.name));
        }
    }

    public static class SunResourceDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101753L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            return new DDView[0];
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            return super.createElement(sunDescriptorDataObject, string);
        }
    }

    public static class SunCmpMappingsDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101753L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            return new DDView[0];
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            return super.createElement(sunDescriptorDataObject, string);
        }
    }

    public static class SunAppClientDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101751L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            J2EEBaseVersion j2EEBaseVersion;
            ASDDVersion aSDDVersion = sunDescriptorDataObject.getASDDVersion();
            ArrayList<DDView> arrayList = new ArrayList<DDView>();
            if (ASDDVersion.SUN_APPSERVER_9_0.compareTo((Object)aSDDVersion) <= 0) {
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.OVERVIEW));
            }
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.ENVIRONMENT));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)aSDDVersion) <= 0 && ((j2EEBaseVersion = sunDescriptorDataObject.getJ2eeModuleVersion()) == null || j2EEBaseVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.WSSERVICE));
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.JMS));
            }
            return arrayList.toArray(new DDView[arrayList.size()]);
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            if (string.equals(DDViewFactory.OVERVIEW)) {
                return new SunAppClientOverviewMultiViewElement(sunDescriptorDataObject);
            }
            return super.createElement(sunDescriptorDataObject, string);
        }
    }

    public static class SunApplicationDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101749L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            return new DDView[]{new DDView(sunDescriptorDataObject, DDViewFactory.SECURITY)};
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            return super.createElement(sunDescriptorDataObject, string);
        }
    }

    public static class SunEjbJarDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101747L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            J2EEBaseVersion j2EEBaseVersion;
            ASDDVersion aSDDVersion = sunDescriptorDataObject.getASDDVersion();
            ArrayList<DDView> arrayList = new ArrayList<DDView>(6);
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.OVERVIEW));
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.EJB));
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.SECURITY));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)aSDDVersion) <= 0 && ((j2EEBaseVersion = sunDescriptorDataObject.getJ2eeModuleVersion()) == null || j2EEBaseVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.WSSERVICE));
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.JMS));
            }
            return arrayList.toArray(new DDView[arrayList.size()]);
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            if (string.equals(DDViewFactory.OVERVIEW)) {
                return new SunEjbOverviewMultiViewElement(sunDescriptorDataObject);
            }
            if (string.equals(DDViewFactory.EJB)) {
                return new EjbMultiViewElement(sunDescriptorDataObject);
            }
            return super.createElement(sunDescriptorDataObject, string);
        }
    }

    public static class SunWebDDViewFactory
    extends DDViewFactory {
        private static final long serialVersionUID = -8759598009819101745L;

        public DesignMultiViewDesc[] getMultiViewDesc(SunDescriptorDataObject sunDescriptorDataObject) {
            J2EEBaseVersion j2EEBaseVersion;
            ASDDVersion aSDDVersion = sunDescriptorDataObject.getASDDVersion();
            ArrayList<DDView> arrayList = new ArrayList<DDView>(8);
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.OVERVIEW));
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.SERVLET));
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.SECURITY));
            if (ASDDVersion.SUN_APPSERVER_8_0.compareTo((Object)aSDDVersion) <= 0 && ((j2EEBaseVersion = sunDescriptorDataObject.getJ2eeModuleVersion()) == null || j2EEBaseVersion.compareSpecification((J2EEBaseVersion)J2EEVersion.J2EE_1_4) >= 0)) {
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.WSSERVICE));
                arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.JMS));
            }
            arrayList.add(new DDView(sunDescriptorDataObject, DDViewFactory.ENVIRONMENT));
            return arrayList.toArray(new DDView[arrayList.size()]);
        }

        public MultiViewElement createElement(SunDescriptorDataObject sunDescriptorDataObject, String string) {
            if (string.equals(DDViewFactory.OVERVIEW)) {
                return new SunWebOverviewMultiViewElement(sunDescriptorDataObject);
            }
            if (string.equals(DDViewFactory.SERVLET)) {
                return new ServletMultiViewElement(sunDescriptorDataObject);
            }
            return super.createElement(sunDescriptorDataObject, string);
        }
    }
}

