/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.netbeans.modules.css.visual.model.ColorModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.openide.util.NbBundle;

public class ColorSelectionField
extends JPanel {
    private PropertyChangeSupport propertyChangeSupport;
    ColorModel colorModel = new ColorModel();
    String currentColor = null;
    String oldColor = null;
    private JButton colorButton;
    private JComboBox colorComboBox;

    public ColorSelectionField() {
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        DefaultComboBoxModel defaultComboBoxModel = this.colorModel.getColorList();
        this.colorComboBox.setModel(defaultComboBoxModel);
        this.colorComboBox.setSelectedIndex(0);
    }

    private void initComponents() {
        this.colorButton = new ColorSelectionButton();
        this.colorComboBox = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.colorButton.setToolTipText(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_CHOOSER_BTN_LABEL"));
        this.colorButton.setPreferredSize(new Dimension(20, 20));
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSelectionField.this.colorButtonActionPerformed(actionEvent);
            }
        });
        this.add((Component)this.colorButton, "East");
        this.colorButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_EDITOR_BTN_ACCESS_NAME"));
        this.colorButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_EDITOR_BTN_ACCESS_DESC"));
        this.colorComboBox.setEditable(true);
        this.colorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSelectionField.this.colorComboBoxActionPerformed(actionEvent);
            }
        });
        this.colorComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ColorSelectionField.this.colorComboBoxFocusLost(focusEvent);
            }
        });
        this.colorComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ColorSelectionField.this.colorComboBoxItemStateChanged(itemEvent);
            }
        });
        this.add((Component)this.colorComboBox, "Center");
        this.colorComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_SELECTION_COMBO_ACCESS_NAME"));
        this.colorComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_SELECTION_COMBO_ACCESS_Desc"));
    }

    private void colorComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setColor();
    }

    private void colorComboBoxFocusLost(FocusEvent focusEvent) {
        this.setColor();
    }

    private void colorComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setColor();
    }

    private void colorButtonActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, NbBundle.getMessage(ColorSelectionField.class, (String)"COLOR_CHOOSER_TITLE"), this.colorModel.getColor());
        if (color != null) {
            this.colorModel.setColor(color);
            this.colorComboBox.setSelectedItem(this.colorModel.getHexColor());
        }
    }

    private void setColor() {
        PropertyData propertyData = new PropertyData();
        this.currentColor = (String)this.colorComboBox.getSelectedItem();
        propertyData.setValue(this.currentColor);
        this.colorModel.setColor(this.currentColor);
        this.repaint();
        this.firePropertyChange("color", this.oldColor, propertyData.toString());
        this.oldColor = propertyData.toString();
    }

    public void setColorString(String string) {
        this.currentColor = string;
        if (string == null || string.equals("")) {
            this.colorComboBox.setSelectedIndex(0);
        } else {
            this.colorComboBox.setSelectedItem(this.currentColor);
        }
        this.repaint();
    }

    public String getColorString() {
        return this.currentColor;
    }

    class ColorSelectionButton
    extends JButton {
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = ColorSelectionField.this.colorModel.getColor();
            if (color == null) {
                color = Color.BLACK;
            }
            graphics2D.setColor(color);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillRoundRect(4, 4, n - 9, n2 - 9, 5, 5);
            graphics2D.setColor(color.darker());
            graphics2D.drawRoundRect(4, 4, n - 9, n2 - 9, 5, 5);
        }
    }
}

