/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.BackgroundModel;
import org.netbeans.modules.css.visual.model.BackgroundPositionData;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.model.Utils;
import org.netbeans.modules.css.visual.ui.BackgroundImageUrlDialog;
import org.netbeans.modules.css.visual.ui.ColorSelectionField;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class BackgroundStyleEditor
extends StyleEditor {
    ColorSelectionField colorField = new ColorSelectionField();
    BackgroundPositionData bgPositionData = new BackgroundPositionData();
    private JButton browseButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel colorSelectionPanel;
    private JLabel errorLabel;
    private JPanel errorPanel;
    private JComboBox horizontalPosComboBox;
    private JLabel horizontalPosLabel;
    private JComboBox horizontalUnitComboBox;
    private JTextField imageFileField;
    private JLabel imageScrollLabel;
    private JLabel imageTileLabel;
    private JLabel lineHeightLabel;
    private JComboBox repeatComboBox;
    private JComboBox scrollComboBox;
    private JComboBox verticalPosComboBox;
    private JLabel verticalPosLabel;
    private JComboBox verticalUnitComboBox;

    public BackgroundStyleEditor() {
        this.setName("backgroundStyleEditor");
        this.setDisplayName(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_EDITOR_DISPNAME"));
        this.initComponents();
        this.colorSelectionPanel.add((Component)this.colorField, "Center");
        this.colorField.addPropertyChangeListener("color", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BackgroundStyleEditor.this.setBackgroundColor();
            }
        });
        this.initialize();
        final JTextField jTextField = (JTextField)this.horizontalPosComboBox.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundStyleEditor.this.horizontalUnitComboBox.setEnabled(Utils.isInteger(jTextField.getText()));
                        BackgroundStyleEditor.this.enablePositionCombo();
                    }
                });
            }
        });
        final JTextField jTextField2 = (JTextField)this.verticalPosComboBox.getEditor().getEditorComponent();
        jTextField2.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundStyleEditor.this.verticalUnitComboBox.setEnabled(Utils.isInteger(jTextField2.getText()));
                    }
                });
            }
        });
    }

    protected void initialize() {
        BackgroundModel backgroundModel = new BackgroundModel();
        DefaultComboBoxModel defaultComboBoxModel = backgroundModel.getBackgroundRepeatList();
        this.repeatComboBox.setModel(defaultComboBoxModel);
        DefaultComboBoxModel defaultComboBoxModel2 = backgroundModel.getBackgroundScrollList();
        this.scrollComboBox.setModel(defaultComboBoxModel2);
        this.horizontalPosComboBox.setModel(backgroundModel.getBackgroundPositionList());
        this.verticalPosComboBox.setModel(backgroundModel.getBackgroundPositionList());
        this.horizontalUnitComboBox.setModel(backgroundModel.getBackgroundPositionUnitList());
        this.verticalUnitComboBox.setModel(backgroundModel.getBackgroundPositionUnitList());
    }

    protected void setCssPropertyValues(CssRuleContent cssRuleContent) {
        String string;
        this.removeCssPropertyChangeListener();
        String string2 = cssRuleContent.getProperty("background-color");
        if (string2 != null) {
            this.colorField.setColorString(string2);
        } else {
            this.colorField.setColorString(CssRuleContent.NOT_SET);
        }
        String string3 = cssRuleContent.getProperty("background-image");
        if (string3 != null && !string3.trim().equals("")) {
            int n = string3.indexOf("(");
            int n2 = string3.indexOf(")");
            if (n >= 0 && n2 >= 0) {
                string = string3.substring(n + 1, n2);
                this.imageFileField.setText(string);
            } else {
                this.imageFileField.setText(string3);
            }
        } else {
            this.imageFileField.setText(CssRuleContent.NOT_SET);
        }
        String string4 = cssRuleContent.getProperty("background-repeat");
        if (string4 != null) {
            this.repeatComboBox.setSelectedItem(string4);
        } else {
            this.repeatComboBox.setSelectedIndex(0);
        }
        String string5 = cssRuleContent.getProperty("background-attachment");
        if (string5 != null) {
            this.scrollComboBox.setSelectedItem(string5);
        } else {
            this.scrollComboBox.setSelectedIndex(0);
        }
        string = cssRuleContent.getProperty("background-position");
        if (string != null) {
            this.bgPositionData.setBackgroundPosition(string);
            this.horizontalPosComboBox.setSelectedItem(this.bgPositionData.getHorizontalValue());
            this.horizontalUnitComboBox.setSelectedItem(this.bgPositionData.getHorizontalUnit());
            this.verticalPosComboBox.setSelectedItem(this.bgPositionData.getVerticalValue());
            this.verticalUnitComboBox.setSelectedItem(this.bgPositionData.getVerticalUnit());
        } else {
            this.horizontalPosComboBox.setSelectedIndex(0);
            this.verticalPosComboBox.setSelectedIndex(0);
        }
        this.setCssPropertyChangeListener(cssRuleContent);
    }

    private void initComponents() {
        this.colorPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.browseButton = new JButton();
        this.imageFileField = new JTextField();
        this.lineHeightLabel = new JLabel();
        this.imageTileLabel = new JLabel();
        this.imageScrollLabel = new JLabel();
        this.scrollComboBox = new JComboBox();
        this.repeatComboBox = new JComboBox();
        this.horizontalPosLabel = new JLabel();
        this.verticalPosLabel = new JLabel();
        this.horizontalPosComboBox = new JComboBox();
        this.verticalPosComboBox = new JComboBox();
        this.horizontalUnitComboBox = new JComboBox();
        this.verticalUnitComboBox = new JComboBox();
        this.colorSelectionPanel = new JPanel();
        this.errorPanel = new JPanel();
        this.errorLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_COLOR").charAt(0));
        this.colorLabel.setLabelFor(this.colorPanel);
        this.colorLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_COLOR"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.colorPanel.add((Component)this.colorLabel, gridBagConstraints);
        this.browseButton.setText("...");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.colorPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(null);
        this.browseButton.getAccessibleContext().setAccessibleDescription(null);
        this.imageFileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundStyleEditor.this.imageFileFieldActionPerformed(actionEvent);
            }
        });
        this.imageFileField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BackgroundStyleEditor.this.imageFileFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.colorPanel.add((Component)this.imageFileField, gridBagConstraints);
        this.imageFileField.getAccessibleContext().setAccessibleName(null);
        this.imageFileField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_IMG_TEXTFIELD_ACCESS_DESC"));
        this.lineHeightLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_IMAGE").charAt(0));
        this.lineHeightLabel.setLabelFor(this.imageFileField);
        this.lineHeightLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_IMAGE"));
        this.lineHeightLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.lineHeightLabel, gridBagConstraints);
        this.imageTileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUNDTILE").charAt(0));
        this.imageTileLabel.setLabelFor(this.repeatComboBox);
        this.imageTileLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUNDTILE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageTileLabel, gridBagConstraints);
        this.imageScrollLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BACKGROUND_SCROLL").charAt(0));
        this.imageScrollLabel.setLabelFor(this.scrollComboBox);
        this.imageScrollLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BACKGROUND_SCROLL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.imageScrollLabel, gridBagConstraints);
        this.scrollComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.scrollComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.scrollComboBox, gridBagConstraints);
        this.scrollComboBox.getAccessibleContext().setAccessibleName(null);
        this.scrollComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.repeatComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.repeatComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.repeatComboBox, gridBagConstraints);
        this.repeatComboBox.getAccessibleContext().setAccessibleName(null);
        this.repeatComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.horizontalPosLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BG_HORIZONTAL_POS").charAt(0));
        this.horizontalPosLabel.setLabelFor(this.horizontalPosComboBox);
        this.horizontalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_HORIZONTAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.horizontalPosLabel, gridBagConstraints);
        this.verticalPosLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/css/visual/ui/Bundle").getString("MNE_BG_VERTICAL_POS").charAt(0));
        this.verticalPosLabel.setLabelFor(this.verticalPosComboBox);
        this.verticalPosLabel.setText(NbBundle.getMessage(BackgroundStyleEditor.class, (String)"BG_VERTICAL_POS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.colorPanel.add((Component)this.verticalPosLabel, gridBagConstraints);
        this.horizontalPosComboBox.setEditable(true);
        this.horizontalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.horizontalPosComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.horizontalPosComboBox, gridBagConstraints);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleName(null);
        this.horizontalPosComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.verticalPosComboBox.setEditable(true);
        this.verticalPosComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.verticalPosComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.colorPanel.add((Component)this.verticalPosComboBox, gridBagConstraints);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleName(null);
        this.verticalPosComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.horizontalUnitComboBox.setEnabled(false);
        this.horizontalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.horizontalUnitComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.horizontalUnitComboBox, gridBagConstraints);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleName(null);
        this.horizontalUnitComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.verticalUnitComboBox.setEnabled(false);
        this.verticalUnitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BackgroundStyleEditor.this.verticalUnitComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.colorPanel.add((Component)this.verticalUnitComboBox, gridBagConstraints);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleName(null);
        this.verticalUnitComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.colorSelectionPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.colorPanel.add((Component)this.colorSelectionPanel, gridBagConstraints);
        this.add((Component)this.colorPanel, "North");
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 1));
        this.errorPanel.setLayout(new BorderLayout());
        this.errorLabel.setForeground(new Color(0, 0, 153));
        this.errorPanel.add((Component)this.errorLabel, "North");
        this.add((Component)this.errorPanel, "Center");
    }

    private void verticalUnitComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setVerticalUnit((String)this.verticalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalUnitComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setHorizontalUnit((String)this.horizontalUnitComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void verticalPosComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setVerticalValue((String)this.verticalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void horizontalPosComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.bgPositionData.setHorizontalValue((String)this.horizontalPosComboBox.getSelectedItem());
            this.setBackgroundPosition();
        }
    }

    private void scrollComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBackgroundAttachment();
        }
    }

    private void repeatComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBackgroundRepeat();
        }
    }

    private void imageFileFieldFocusLost(FocusEvent focusEvent) {
        this.setBackgroundImage();
    }

    private void imageFileFieldActionPerformed(ActionEvent actionEvent) {
        this.setBackgroundImage();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        BackgroundImageUrlDialog backgroundImageUrlDialog = new BackgroundImageUrlDialog(this.content().base());
        if (backgroundImageUrlDialog.show(this)) {
            this.imageFileField.setText(backgroundImageUrlDialog.getImageUrl());
        }
        this.setBackgroundImage();
    }

    private void setBackgroundColor() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.colorField.getColorString());
        this.cssPropertyChangeSupport().firePropertyChange("background-color", null, propertyData.toString());
    }

    private void setBackgroundImage() {
        PropertyData propertyData = new PropertyData();
        String string = this.imageFileField.getText();
        if (string == null || string.equals("")) {
            string = CssRuleContent.NOT_SET;
            this.imageFileField.setText(string);
        }
        if (!string.equals(CssRuleContent.NOT_SET)) {
            propertyData.setValue("url(" + string + ")");
        } else {
            propertyData.setValue(CssRuleContent.NOT_SET);
        }
        this.cssPropertyChangeSupport().firePropertyChange("background-image", null, propertyData.toString());
    }

    private void setBackgroundRepeat() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.repeatComboBox.getSelectedItem().toString());
        this.cssPropertyChangeSupport().firePropertyChange("background-repeat", null, propertyData.toString());
    }

    private void setBackgroundAttachment() {
        PropertyData propertyData = new PropertyData();
        propertyData.setValue(this.scrollComboBox.getSelectedItem().toString());
        this.cssPropertyChangeSupport().firePropertyChange("background-attachment", null, propertyData.toString());
    }

    private void setBackgroundPosition() {
        this.cssPropertyChangeSupport().firePropertyChange("background-position", null, this.bgPositionData.toString());
        this.enablePositionCombo();
    }

    private void enablePositionCombo() {
        String string = this.bgPositionData.getHorizontalValue();
        if (Utils.isInteger(string)) {
            this.horizontalUnitComboBox.setEnabled(true);
        } else {
            this.horizontalUnitComboBox.setEnabled(false);
        }
        String string2 = this.bgPositionData.getVerticalValue();
        if (Utils.isInteger(string2)) {
            this.verticalUnitComboBox.setEnabled(true);
        } else {
            this.verticalUnitComboBox.setEnabled(false);
        }
    }
}

