/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.sql;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.DataSourceResolver;
import org.netbeans.modules.visualweb.dataconnectivity.naming.ContextPersistance;
import org.netbeans.modules.visualweb.dataconnectivity.naming.ObjectChangeEvent;
import org.netbeans.modules.visualweb.dataconnectivity.naming.ObjectChangeListener;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DatabaseMetaDataHelper;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeConnection;
import org.netbeans.modules.visualweb.dataconnectivity.sql.Log;
import org.openide.util.RequestProcessor;

public class DesignTimeDataSource
implements DataSource,
ContextPersistance,
Runnable {
    protected static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.sql.Bundle", Locale.getDefault());
    private boolean schemasInitialized;
    private SortedSet schemas;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String validationQuery;
    private PrintWriter logWriter;
    private int loginTimeout;
    private SQLException testSQLException;
    private boolean testConnectionSucceeded;
    private int testSQLRowsReturned;
    private ArrayList objectChangeListeners;
    private Driver driver;
    private Connection designtimeConnection;
    private static boolean isConnectionAttempted = false;
    private DatabaseConnection dbConn;
    private static URL[] urls;
    private RequestProcessor.Task task = null;
    private final RequestProcessor CONNECT_RP = new RequestProcessor("DataSourceResolver.WAIT_FOR_MODELING_RP");
    private static final String alphabet = "abcdefghijklmnopqrstuvwxyz";
    private static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    private static final String SELECT_PHRASE = "select * from ";
    private static final String SELECT_PHRASE_APPSERVER8 = "select count(*) from ";
    public static final int SQL_NOT_RUN = -1;
    private static SecretKey secretKey;
    private static final char[] secretKeyHex;
    private String enableFastConnectFail = System.getProperty("rave.fastConnectFail", "true");
    private boolean lastConnectFail = false;
    private long lastConnectFailTime = 0L;
    private static long CONNECT_RETRY_MS;
    private SQLException failException = null;
    private static final char[] hexCharacters;
    private static final String hexString = "0123456789ABCDEF";

    private static SecretKey getSecretKey() {
        if (secretKey == null) {
            byte[] byArray = new byte[secretKeyHex.length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = DesignTimeDataSource.hexToByte(secretKeyHex[i * 2], secretKeyHex[i * 2 + 1]);
            }
            secretKey = new SecretKeySpec(byArray, "DES");
        }
        return secretKey;
    }

    public DesignTimeDataSource() {
        this((String)null, false, (String)null, (String)null, (String)null, (String)null, (String)null);
    }

    public DesignTimeDataSource(Boolean bl, String string, String string2, String string3, String string4, String string5) {
        this((String)null, bl, string, string2, string3, string4, string5);
    }

    public DesignTimeDataSource(String string, Boolean bl, String string2, String string3, String string4, String string5, String string6) {
        this(false, string, bl == null ? false : bl, string2, string3, string4, string5, string6);
    }

    public DesignTimeDataSource(Boolean bl, String string, Boolean bl2, String string2, String string3, String string4, String string5, String string6) {
        this(bl == null ? false : bl, string, bl2 == null ? false : bl2, string2, string3, string4, string5, string6);
    }

    public DesignTimeDataSource(String string, boolean bl, String string2, String string3, String string4, String string5, String string6) {
        this(false, string, bl, string2, string3, string4, string5, string6);
    }

    public DesignTimeDataSource(boolean bl, String string, boolean bl2, String string2, String string3, String string4, String string5, String string6) {
        this.schemasInitialized = bl;
        this.schemas = DesignTimeDataSource.parseSchemas(string);
        this.driverClassName = string2;
        this.url = string3;
        this.username = string5;
        this.password = null;
        if (string6 != null) {
            this.password = bl2 ? DesignTimeDataSource.decryptPassword(string6) : string6;
        }
        this.logWriter = null;
        this.loginTimeout = 0;
        this.validationQuery = string4;
        this.testSQLException = null;
        this.testConnectionSucceeded = false;
        this.testSQLRowsReturned = -1;
        this.objectChangeListeners = new ArrayList();
        this.driver = null;
    }

    public void clearConnectFailFlag() {
        this.lastConnectFail = false;
    }

    private void setLastConnectFail(SQLException sQLException) {
        this.lastConnectFail = true;
        this.lastConnectFailTime = System.currentTimeMillis();
        if (sQLException != null) {
            this.failException = sQLException;
        }
    }

    private void checkLastConnectFail() throws SQLException {
        if (this.lastConnectFail) {
            if (System.currentTimeMillis() - this.lastConnectFailTime < CONNECT_RETRY_MS) {
                this.setLastConnectFail(null);
                SQLException sQLException = new SQLException("Connect Retry recent failure: " + this.failException.getLocalizedMessage());
                sQLException.setNextException(this.failException);
                if (this.enableFastConnectFail.equalsIgnoreCase("console")) {
                    System.out.println("DesignTimeDataSource connect retry auto-failure for " + this.getUrl());
                }
                throw sQLException;
            }
            this.lastConnectFail = false;
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.designtimeConnection == null) {
            this.designtimeConnection = this.getConnection(this.username, this.password);
        }
        return this.designtimeConnection;
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        if (this.designtimeConnection == null) {
            Log.getLogger().entering(this.getClass().getName(), this.toString() + ".getConnection()", new Object[]{string, string2});
            this.checkLastConnectFail();
            DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                if (!this.url.equalsIgnoreCase(databaseConnectionArray[i].getDatabaseURL())) continue;
                this.dbConn = databaseConnectionArray[i];
                this.url = databaseConnectionArray[i].getDatabaseURL();
                break;
            }
            if (this.dbConn != null) {
                JDBCDriver jDBCDriver = DataSourceResolver.getInstance().findMatchingDriver(this.dbConn.getDriverClass());
                urls = jDBCDriver.getURLs();
                this.driverClassName = this.dbConn.getDriverClass();
                this.loadDriver();
            }
            Properties properties = new Properties();
            if (string != null) {
                properties.put("user", string);
            }
            if (string2 != null) {
                properties.put("password", string2);
            }
            try {
                Connection connection;
                if (this.driverClassName.equals(DRIVER_CLASS_NET) && !isConnectionAttempted) {
                    isConnectionAttempted = true;
                    this.ensureConnection();
                }
                if ((connection = this.driver.connect(this.url, properties)) == null) {
                    SQLException sQLException = new SQLException(MessageFormat.format(rb.getString("WRONG_DRIVER_FOR_URL"), this.driverClassName, this.url));
                    this.setLastConnectFail(sQLException);
                    throw sQLException;
                }
                this.designtimeConnection = new DesignTimeConnection(this, connection);
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    this.setLastConnectFail((SQLException)exception);
                    throw (SQLException)exception;
                }
                SQLException sQLException = new SQLException(exception.getLocalizedMessage());
                sQLException.initCause(exception);
                this.setLastConnectFail(sQLException);
                throw sQLException;
            }
        }
        return this.designtimeConnection;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
        this.driver = null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public String getValidationTable() {
        String string = DesignTimeDataSource.parseForValidationTable(this.getValidationQuery());
        return string == null ? "" : string;
    }

    public void setValidationTable(String string) {
        this.setValidationQuery(DesignTimeDataSource.composeValidationQuery(string));
    }

    protected static String composeValidationQuery(String string) {
        return SELECT_PHRASE + string;
    }

    protected static String parseForValidationTable(String string) {
        String string2;
        block4: {
            block3: {
                string2 = null;
                if (string == null) {
                    return null;
                }
                String string3 = string.toLowerCase();
                if (string3 == null || !string3.startsWith(SELECT_PHRASE.toLowerCase())) break block3;
                if (string3.length() <= SELECT_PHRASE.length()) break block4;
                string2 = string.substring(SELECT_PHRASE.length());
                break block4;
            }
            if (string != null && !string.trim().equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().toUpperCase().equals("FROM")) continue;
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = stringTokenizer.nextToken();
                    break;
                }
            }
        }
        return string2;
    }

    public boolean test() {
        this.testSQLException = null;
        this.testConnectionSucceeded = false;
        this.testSQLRowsReturned = -1;
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.testConnectionSucceeded = true;
        }
        catch (SQLException sQLException) {
            this.testSQLException = sQLException;
        }
        if (this.testConnectionSucceeded && this.validationQuery != null && !this.validationQuery.equals("")) {
            try {
                Statement statement = connection.createStatement();
                String string = SELECT_PHRASE_APPSERVER8 + this.getValidationTable();
                ResultSet resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    this.testSQLRowsReturned = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                this.testSQLException = sQLException;
                return false;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.testConnectionSucceeded;
    }

    public SQLException getTestException() {
        return this.testSQLException;
    }

    public int getTestRowsReturned() {
        return this.testSQLRowsReturned;
    }

    public boolean getTestConnectionSucceeded() {
        return this.testConnectionSucceeded;
    }

    public String[] getSchemas() {
        return this.schemas.toArray(new String[0]);
    }

    public void setSchemas(Collection collection) {
        this.clearSchemas();
        this.schemas.addAll(collection);
    }

    public synchronized void initSchemas() throws SQLException, NamingException {
        if (this.getSchemasInitialized()) {
            return;
        }
        this.clearSchemas();
        DatabaseMetaDataHelper databaseMetaDataHelper = new DatabaseMetaDataHelper(this);
        String[] stringArray = databaseMetaDataHelper.getSchemas();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().equals(this.username.toLowerCase())) continue;
            String string = databaseMetaDataHelper.getValidationQuery(stringArray[i]);
            if (string != null) {
                if (this.validationQuery == null) {
                    this.validationQuery = string;
                }
                this.addSchema(stringArray[i]);
                break;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                this.addSchema(stringArray[j]);
            }
            break;
        }
        if (this.validationQuery == null) {
            this.validationQuery = databaseMetaDataHelper.getValidationQuery(null);
        }
        this.setSchemasInitialized(true);
        this.save();
    }

    public boolean getSchemasInitialized() {
        return this.schemasInitialized;
    }

    public void setSchemasInitialized(boolean bl) {
        this.schemasInitialized = bl;
    }

    public void clearSchemas() {
        this.schemas.clear();
    }

    public void addSchema(String string) {
        this.schemas.add(string);
    }

    public void removeSchema(String string) {
        this.schemas.remove(string);
    }

    public String getTag(String string, int n, int n2) {
        return this.getSpaces(n, n2) + "<object name=\"" + string + "\" class=\"" + this.getClass().getName() + "\">\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.Boolean\" value=\"" + (this.getSchemasInitialized() ? "true" : "false") + "\"/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + this.getSchemaValueAttribute() + "/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.Boolean\" value=\"true\"/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + (this.driverClassName == null ? "" : " value=\"" + this.driverClassName + "\"") + "/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + (this.url == null ? "" : " value=\"" + DesignTimeDataSource.escapeXML(this.url) + "\"") + "/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + (this.validationQuery == null ? "" : " value=\"" + DesignTimeDataSource.escapeXML(this.validationQuery) + "\"") + "/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + (this.username == null ? "" : " value=\"" + this.username + "\"") + "/>\n" + this.getSpaces(n + 1, n2) + "<arg class=\"java.lang.String\"" + (this.password == null ? "" : " value=\"" + DesignTimeDataSource.encryptPassword(this.password) + "\"") + "/>\n" + this.getSpaces(n, n2) + "</object>\n";
    }

    protected static String escapeXML(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("'", "&apos;");
        return string2;
    }

    public void addObjectChangeListener(ObjectChangeListener objectChangeListener) {
        this.objectChangeListeners.add(objectChangeListener);
    }

    public void removeObjectChangeListener(ObjectChangeListener objectChangeListener) {
        this.objectChangeListeners.remove(objectChangeListener);
    }

    public void save() throws NamingException {
        if (!this.objectChangeListeners.isEmpty()) {
            ObjectChangeEvent objectChangeEvent = new ObjectChangeEvent(this);
            Iterator iterator = this.objectChangeListeners.iterator();
            while (iterator.hasNext()) {
                ((ObjectChangeListener)iterator.next()).objectChanged(objectChangeEvent);
            }
        }
    }

    private static SortedSet parseSchemas(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string != null && !string.trim().equals("")) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().equals("")) continue;
                treeSet.add(stringArray[i]);
            }
        }
        return treeSet;
    }

    private String getSchemaValueAttribute() {
        String string = "";
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            if (!string.equals("")) {
                string = string + ",";
            }
            string = string + (String)iterator.next();
        }
        return string.equals("") ? "" : " value=\"" + string + "\"";
    }

    public static String encryptPassword(String string) {
        if (string == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, DesignTimeDataSource.getSecretKey());
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = cipher.doFinal(byArray);
            char[] cArray = new char[byArray2.length * 2];
            for (int i = 0; i < byArray2.length; ++i) {
                cArray[i * 2] = DesignTimeDataSource.nibbleToHex((byArray2[i] & 0xF0) >> 4);
                cArray[i * 2 + 1] = DesignTimeDataSource.nibbleToHex(byArray2[i] & 0xF);
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String composeSelect(String string, DatabaseMetaData databaseMetaData) {
        SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)databaseMetaData);
        String[] stringArray = string.split("\\.");
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + quoter.quoteIfNeeded(stringArray[i]);
        }
        return "SELECT * FROM " + string2;
    }

    private static char nibbleToHex(int n) {
        return hexCharacters[n];
    }

    private static byte hexToByte(char c, char c2) {
        return (byte)((hexString.indexOf(c) << 4) + hexString.indexOf(c2));
    }

    static String decryptPassword(String string) {
        if (string == null) {
            return null;
        }
        try {
            char[] cArray = string.toCharArray();
            byte[] byArray = new byte[cArray.length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = DesignTimeDataSource.hexToByte(cArray[i * 2], cArray[i * 2 + 1]);
            }
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, DesignTimeDataSource.getSecretKey());
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    protected String getSpaces(int n, int n2) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                string = string + " ";
            }
        }
        return string;
    }

    private void loadDriver() throws SQLException {
        Log.getLogger().entering(this.getClass().getName(), this.toString() + ".loadDriver");
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverClassName, true, DesignTimeDataSource.getDriverClassLoader(this.getClass().getClassLoader()));
                this.driver = (Driver)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException.getClass().getName() + ": " + classNotFoundException.getLocalizedMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException.getClass().getName() + ": " + instantiationException.getLocalizedMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException.getClass().getName() + ": " + illegalAccessException.getLocalizedMessage());
            }
        }
    }

    private static URLClassLoader getDriverClassLoader(ClassLoader classLoader) {
        Log.getLogger().entering("DesignTimeDataSource", "getDriverClassLoader()");
        return URLClassLoader.newInstance(urls, classLoader);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('(');
        boolean bl = true;
        if (this.driverClassName != null) {
            stringBuffer.append(this.driverClassName);
            bl = false;
        }
        if (this.url != null) {
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.url);
            bl = false;
        }
        if (this.username != null) {
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.username);
            bl = false;
        }
        if (this.validationQuery != null) {
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.validationQuery);
            bl = false;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        throw new RuntimeException(rb.getString("NOT_IMPLEMENTED"));
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new RuntimeException(rb.getString("NOT_IMPLEMENTED"));
    }

    public synchronized void run() {
        JDBCDriver jDBCDriver = DataSourceResolver.getInstance().findMatchingDriver(this.driverClassName);
        DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriver, (String)this.url, (String)this.username, (String)this.username.toUpperCase(), (String)this.password, (boolean)true);
        ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
    }

    public void ensureConnection() {
        if (this.task == null) {
            this.task = this.CONNECT_RP.create((Runnable)this);
        }
        this.task.schedule(10);
    }

    static {
        secretKey = null;
        secretKeyHex = new char[]{'D', '6', '0', '7', '5', 'E', '2', '9', '8', 'A', '4', '9', '6', '2', '5', '1'};
        CONNECT_RETRY_MS = 2690L;
        hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

