/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.naming;

import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.visualweb.dataconnectivity.naming.DatabaseSettingsImporter;
import org.netbeans.modules.visualweb.dataconnectivity.utils.SampleDatabaseCreator;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class DerbyWaiter {
    private static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    private boolean registered;
    private boolean isMigration;
    private final JDBCDriverListener jdbcDriverListener = new JDBCDriverListener(){

        public void driversChanged() {
            DerbyWaiter.this.createDatabase("travel", "startup/samples/travel.zip");
            DerbyWaiter.this.createDatabase("vir", "startup/samples/vir.zip");
            DerbyWaiter.this.registerConnections();
        }
    };

    public DerbyWaiter(boolean bl) {
        this.isMigration = bl;
        String string = NbPreferences.forModule(SampleDatabaseCreator.class).get("VISUALWEB_SAMPLE_DATABASE_REGISTERED", "");
        if (!bl && string.equals("")) {
            if (JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET).length == 0) {
                JDBCDriverManager.getDefault().addDriverListener(this.jdbcDriverListener);
            } else {
                this.createDatabase("travel", "startup/samples/travel.zip");
                this.createDatabase("vir", "startup/samples/vir.zip");
                this.registerConnections();
            }
        }
    }

    private void createDatabase(String string, String string2) {
        if (!DerbyDatabases.databaseExists((String)string)) {
            SampleDatabaseCreator.createDatabase(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConnections() {
        DerbyWaiter derbyWaiter = this;
        synchronized (derbyWaiter) {
            if (this.registered) {
                return;
            }
            this.registered = true;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DerbyWaiter.class, (String)"REGISTERING_JAVADB_DATABASES"));
                progressHandle.start();
                JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(DerbyWaiter.DRIVER_CLASS_NET);
                if (DerbyWaiter.this.isMigration) {
                    DatabaseSettingsImporter.getInstance().locateAndRegisterDrivers();
                    DatabaseSettingsImporter.getInstance().locateAndRegisterConnections(true);
                    if (jDBCDriverArray.length > 0) {
                        SampleDatabaseCreator.createAll("travel", "travel", "travel", "TRAVEL", "startup/samples/travel.zip", true, "localhost", 1527);
                        SampleDatabaseCreator.createAll("vir", "vir", "vir", "VIR", "startup/samples/vir.zip", true, "localhost", 1527);
                    }
                } else if (jDBCDriverArray.length > 0) {
                    SampleDatabaseCreator.createAll("travel", "travel", "travel", "TRAVEL", "startup/samples/travel.zip", true, "localhost", 1527);
                    SampleDatabaseCreator.createAll("vir", "vir", "vir", "VIR", "startup/samples/vir.zip", true, "localhost", 1527);
                    JDBCDriverManager.getDefault().removeDriverListener(DerbyWaiter.this.jdbcDriverListener);
                }
                progressHandle.finish();
            }
        });
    }
}

