/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import org.netbeans.modules.visualweb.dataconnectivity.model.DatasourceConnectionListener;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DatabaseMetaDataHelper;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSourceAlias;
import org.openide.util.NbBundle;

public class DataSourceInfo {
    private String name;
    private DesignTimeDataSource dataSource;
    private DatabaseMetaDataHelper dbmdh;
    String dataSourceId;
    Set listeners = new HashSet();
    boolean connected = false;
    boolean connectionTested = false;
    String connectionMsg = null;
    long connectionTimeout = 30000L;
    private String alias = null;
    private String previousAlias = null;
    private TestConnectionResults lastTestConnectionResults = null;

    public DataSourceInfo(String string, DesignTimeDataSource designTimeDataSource) {
        this.name = string;
        this.setDataSource(designTimeDataSource);
        this.dbmdh = null;
        if (this.isAlias()) {
            this.connectionMsg = "Alias to " + this.getAlias() + "(" + this.connectionMsg + ")";
            this.connectionMsg = NbBundle.getMessage(DataSourceInfo.class, (String)"CONNECTION_MSG_FOR_ALIAS", (Object)this.getAlias(), (Object)this.getUrl());
        } else {
            this.connectionMsg = this.getUrl();
        }
    }

    public DataSourceInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        this.setDataSource(new DesignTimeDataSource(null, false, string2, string3, string4, string5, string6));
        this.dbmdh = null;
    }

    public DataSourceInfo(String string, String string2) {
        this.name = string;
        this.setDataSource(new DesignTimeDataSourceAlias(string2));
        this.dbmdh = null;
    }

    private void setDataSource(DesignTimeDataSource designTimeDataSource) {
        this.dataSource = designTimeDataSource;
        if (this.isAlias()) {
            this.alias = ((DesignTimeDataSourceAlias)designTimeDataSource).getAlias();
        }
    }

    public String getAlias() {
        if (this.isAlias()) {
            return ((DesignTimeDataSourceAlias)this.dataSource).getAlias();
        }
        return null;
    }

    public boolean isAlias() {
        return this.dataSource instanceof DesignTimeDataSourceAlias;
    }

    public void setAlias(String string) {
        this.previousAlias = ((DesignTimeDataSourceAlias)this.dataSource).getAlias();
        ((DesignTimeDataSourceAlias)this.dataSource).setAlias(string);
    }

    public void swapAlias() {
        ((DesignTimeDataSourceAlias)this.dataSource).setAlias(this.previousAlias);
    }

    public boolean isInfoEqual(DataSourceInfo dataSourceInfo) {
        if (this.getUsername() == null ? dataSourceInfo.getUsername() != null : !this.getUsername().equals(dataSourceInfo.getUsername())) {
            return false;
        }
        if (this.getPassword() == null ? dataSourceInfo.getPassword() != null : !this.getPassword().equals(dataSourceInfo.getPassword())) {
            return false;
        }
        if (this.getUrl() == null ? dataSourceInfo.getUrl() != null : !this.getUrl().equals(dataSourceInfo.getUrl())) {
            return false;
        }
        if (this.getValidationTable() == null ? dataSourceInfo.getValidationTable() != null : !this.getValidationTable().equals(dataSourceInfo.getValidationTable())) {
            return false;
        }
        return !(this.getDriverClassName() == null ? dataSourceInfo.getDriverClassName() != null : !this.getDriverClassName().equals(dataSourceInfo.getDriverClassName()));
    }

    public String toString() {
        String string = "Name: " + this.name + "\nUrl: " + this.getUrl() + "\nUser: " + this.getUsername();
        return string;
    }

    public void addConnectionListener(DatasourceConnectionListener datasourceConnectionListener) {
        this.listeners.add(datasourceConnectionListener);
    }

    public void removeConnectionListener(DatasourceConnectionListener datasourceConnectionListener) {
        this.listeners.remove(datasourceConnectionListener);
    }

    public boolean containsSchema(String string) {
        boolean bl = false;
        String[] stringArray = this.getSchemas();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void initSchemas() throws SQLException, NamingException {
        this.dataSource.initSchemas();
    }

    public String[] getSchemas() {
        return this.dataSource.getSchemas();
    }

    public void setSchemas(String[] stringArray) {
        this.dataSource.setSchemas(Arrays.asList(stringArray));
    }

    public void clearSchemas() {
        this.dataSource.clearSchemas();
    }

    public void setSchemasInitialized(boolean bl) {
        this.dataSource.setSchemasInitialized(bl);
    }

    public void addSchema(String string) {
        this.dataSource.addSchema(string);
    }

    public void removeSchema(String string) {
        this.dataSource.removeSchema(string);
    }

    public String getId() {
        return this.dataSourceId;
    }

    public void setId(String string) {
        this.dataSourceId = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDriverClassName() {
        return this.dataSource.getDriverClassName();
    }

    public void setDriverClassName(String string) {
        this.dataSource.setDriverClassName(string);
    }

    public String getUrl() {
        return this.dataSource.getUrl();
    }

    public void setUrl(String string) {
        this.dataSource.setUrl(string);
    }

    public String getUsername() {
        return this.dataSource.getUsername();
    }

    public void setUsername(String string) {
        this.dataSource.setUsername(string);
    }

    public String getPassword() {
        return this.dataSource.getPassword();
    }

    public void setPassword(String string) {
        this.dataSource.setPassword(string);
    }

    public String getValidationQuery() {
        return this.dataSource.getValidationQuery();
    }

    public void setValidationQuery(String string) {
        this.dataSource.setValidationQuery(string);
    }

    public void setValidationTable(String string) {
        this.dataSource.setValidationTable(string);
    }

    public String getValidationTable() {
        return this.dataSource.getValidationTable();
    }

    public DatabaseMetaDataHelper getDatabaseMetaDataHelper() {
        if (this.dbmdh == null) {
            try {
                this.dbmdh = new DatabaseMetaDataHelper(this.dataSource);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.dbmdh;
    }

    public DesignTimeDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean testConnection() {
        return this.testConnection(this.connectionTimeout);
    }

    public boolean testConnection(long l) {
        TestConnectionResults testConnectionResults = this.testConnectionAndValidation(l);
        return testConnectionResults.connected;
    }

    public TestConnectionResults getLastTestResults() {
        if (this.lastTestConnectionResults == null) {
            return null;
        }
        return this.lastTestConnectionResults.cloneResults();
    }

    public TestConnectionResults testConnectionAndValidation() {
        return this.testConnectionAndValidation(this.connectionTimeout);
    }

    public TestConnectionResults testConnectionAndValidation(long l) {
        this.lastTestConnectionResults = null;
        this.connectionTested = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                DataSourceInfo.this.connected = DataSourceInfo.this.dataSource.test();
            }
        });
        thread.start();
        TestConnectionResults testConnectionResults = new TestConnectionResults();
        try {
            thread.join(l);
            if (thread.isAlive()) {
                testConnectionResults.connected = false;
                testConnectionResults.sqlException = NbBundle.getMessage(DataSourceInfo.class, (String)"CONNECTION_TIMEDOUT_MSG", (Object)this.getUrl());
                testConnectionResults.rows = -1;
                return testConnectionResults;
            }
        }
        catch (InterruptedException interruptedException) {
            testConnectionResults.connected = false;
            testConnectionResults.sqlException = NbBundle.getMessage(DataSourceInfo.class, (String)"CONNECTION_INTERRUPTED", (Object)this.getUrl());
            testConnectionResults.rows = -1;
            return testConnectionResults;
        }
        testConnectionResults.connected = this.dataSource.getTestConnectionSucceeded();
        testConnectionResults.sqlException = this.dataSource.getTestException() == null ? null : this.dataSource.getTestException().getMessage();
        testConnectionResults.rows = this.dataSource.getTestRowsReturned();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((DatasourceConnectionListener)iterator.next()).dataSourceConnectionModified();
        }
        this.lastTestConnectionResults = testConnectionResults;
        return testConnectionResults.cloneResults();
    }

    public void reset() {
        this.getDatabaseMetaDataHelper().refresh();
        this.testConnectionAndValidation();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isConnectionTested() {
        return this.connectionTested;
    }

    public String getConnectionMsg() {
        return this.connectionMsg;
    }

    public void setDbmdh(DatabaseMetaDataHelper databaseMetaDataHelper) {
        this.dbmdh = databaseMetaDataHelper;
    }

    public static class TestConnectionResults {
        public boolean connected = false;
        public String sqlException = null;
        public SQLException sqlExceptionRootCause = null;
        public int rows = -1;

        public TestConnectionResults cloneResults() {
            TestConnectionResults testConnectionResults = new TestConnectionResults();
            testConnectionResults.connected = this.connected;
            testConnectionResults.rows = this.rows;
            testConnectionResults.sqlException = this.sqlException;
            testConnectionResults.sqlExceptionRootCause = this.sqlExceptionRootCause;
            return testConnectionResults;
        }
    }
}

