/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.customizers;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.impl.BasicCustomizer2;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditor;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorFactory;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.visualweb.dataconnectivity.Log;
import org.netbeans.modules.visualweb.dataconnectivity.customizers.VisualSQLEditorMetaDataImpl;
import org.netbeans.modules.visualweb.dataconnectivity.sql.DesignTimeDataSource;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SqlCommandCustomizer
extends BasicCustomizer2 {
    public String customizerClassName = "";
    private OpenProjectsListener openProjectsListener = new OpenProjectsListener();
    private static HashMap<DesignBean, QBPair> queryEditors = new HashMap();
    private static HashMap<Project, ArrayList<DesignBean>> projectBeans = new HashMap();
    private PropertyChangeListener vseListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Log.log("VSE property change: " + string);
            if (string.equals("STATEMENT")) {
                VisualSQLEditor visualSQLEditor = (VisualSQLEditor)propertyChangeEvent.getSource();
                for (DesignBean designBean : queryEditors.keySet()) {
                    QBPair qBPair = (QBPair)queryEditors.get(designBean);
                    if (qBPair == null || qBPair.vse != visualSQLEditor) continue;
                    Log.err.log(" newValue=" + visualSQLEditor.getStatement());
                    designBean.getProperty("command").setValue((Object)visualSQLEditor.getStatement());
                    break;
                }
            }
        }
    };

    public SqlCommandCustomizer(String string) {
        super(null, NbBundle.getMessage(SqlCommandCustomizer.class, (String)"EDIT_QUERY"));
        this.customizerClassName = string;
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this.openProjectsListener);
        Log.err.log("Customizer for " + string);
    }

    public Component getCustomizerPanel(DesignBean designBean) {
        Object object;
        Object object2;
        FacesModelSet facesModelSet;
        Object object3;
        Log.err.log("Customizer panel requested for " + designBean.getInstanceName());
        QBPair qBPair = queryEditors.get(designBean);
        if (qBPair != null) {
            TopComponent topComponent = qBPair.qb;
            if (!topComponent.isOpened()) {
                topComponent.open();
            }
            topComponent.requestActive();
            return topComponent;
        }
        Project project = null;
        DesignContext designContext = designBean.getDesignContext();
        if (designContext instanceof LiveUnit) {
            object3 = ((LiveUnit)designContext).getModel();
            facesModelSet = object3.getFacesModelSet();
            project = facesModelSet.getProject();
        }
        if (project != null) {
            object3 = projectBeans.get(project);
            if (object3 == null) {
                object3 = new ArrayList();
                projectBeans.put(project, (ArrayList<DesignBean>)object3);
            }
            object3.add(designBean);
        }
        object3 = null;
        object3 = (String)designBean.getProperty("dataSourceName").getValue();
        facesModelSet = null;
        try {
            facesModelSet = VisualSQLEditorMetaDataImpl.getDataSourceCache((String)object3);
        }
        catch (SQLException sQLException) {
        }
        catch (NamingException namingException) {
            Exceptions.printStackTrace((Throwable)namingException);
        }
        DatabaseConnection databaseConnection = null;
        try {
            object2 = this.lookupDataSource((String)object3);
            object = ConnectionManager.getDefault().getConnections();
            for (int i = 0; i < ((DatabaseConnection[])object).length; ++i) {
                if (!object[i].getDatabaseURL().equals(((DesignTimeDataSource)object2).getUrl())) continue;
                databaseConnection = object[i];
                break;
            }
        }
        catch (NamingException namingException) {
            Exceptions.printStackTrace((Throwable)namingException);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        object2 = null;
        try {
            if (databaseConnection == null) {
                throw new NamingException(NbBundle.getMessage(SqlCommandCustomizer.class, (String)"NAME_NOT_FOUND") + " " + (String)object3);
            }
            object = (String)designBean.getProperty("command").getValue();
            VisualSQLEditor visualSQLEditor = VisualSQLEditorFactory.createVisualSQLEditor(databaseConnection, (String)object, (VisualSQLEditorMetaData)facesModelSet);
            visualSQLEditor.addPropertyChangeListener(this.vseListener);
            object2 = visualSQLEditor.open();
            if (object2 instanceof TopComponent) {
                queryEditors.put(designBean, new QBPair((TopComponent)object2, visualSQLEditor));
            }
        }
        catch (NamingException namingException) {
            Exceptions.printStackTrace((Throwable)namingException);
        }
        return object2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_editors_about_query_editor");
    }

    private DesignTimeDataSource lookupDataSource(String string) throws NamingException, SQLException {
        if (string == null) {
            throw new NamingException(NbBundle.getMessage(SqlCommandCustomizer.class, (String)"NAME_NOT_FOUND") + " " + string);
        }
        InitialContext initialContext = new InitialContext();
        String string2 = !string.startsWith("java:comp/env/jdbc/") ? "java:comp/env/jdbc/" + string : string;
        DesignTimeDataSource designTimeDataSource = (DesignTimeDataSource)initialContext.lookup(string2);
        if (designTimeDataSource == null) {
            throw new NamingException(NbBundle.getMessage(SqlCommandCustomizer.class, (String)"NAME_NOT_FOUND") + " " + string);
        }
        return designTimeDataSource;
    }

    private class QBPair {
        TopComponent qb;
        VisualSQLEditor vse;

        QBPair(TopComponent topComponent, VisualSQLEditor visualSQLEditor) {
            this.qb = topComponent;
            this.vse = visualSQLEditor;
        }
    }

    private class OpenProjectsListener
    implements PropertyChangeListener {
        private OpenProjectsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                List<Project> list = Arrays.asList((Project[])propertyChangeEvent.getOldValue());
                List<Project> list2 = Arrays.asList((Project[])propertyChangeEvent.getNewValue());
                LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>(list);
                linkedHashSet.removeAll(list2);
                for (Project project : linkedHashSet) {
                    ArrayList arrayList = (ArrayList)projectBeans.get(project);
                    if (arrayList != null) {
                        for (DesignBean designBean : arrayList) {
                            QBPair qBPair = (QBPair)queryEditors.get(designBean);
                            if (qBPair != null) {
                                qBPair.qb.close();
                            }
                            queryEditors.remove(designBean);
                        }
                    }
                    projectBeans.remove(project);
                }
            }
        }
    }
}

