/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.wizard.ConsolidationStrategyWizard;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectModeWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectObjectFilesWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderWizard;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryWizardAction
extends NodeAction {
    public static final String HELP_CONTEXT_SELECT_MODE = "CodeAssistanceWizardP1";
    public static final String HELP_CONTEXT_SIMPLE_CONFIGURATION = "CodeAssistanceWizardP6";
    public static final String HELP_CONTEXT_SELECT_PROVIDER = "CodeAssistanceWizardP2";
    public static final String HELP_CONTEXT_SELECT_OBJECT_FILES = "CodeAssistanceWizardP3";
    public static final String HELP_CONTEXT_CONSOLIDATION_STRATEGY = "CodeAssistanceWizardP4";
    public static final String HELP_CONTEXT_SELECT_CONFIGURATION = "CodeAssistanceWizardP5";

    public DiscoveryWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodeArray) {
        Collection<Project> collection = this.getMakeProjects(nodeArray);
        if (collection == null || collection.size() != 1) {
            return;
        }
        this.invokeWizard(collection.iterator().next());
    }

    protected boolean enable(Node[] nodeArray) {
        Collection<Project> collection = this.getMakeProjects(nodeArray);
        return collection != null && collection.size() == 1;
    }

    private void invokeWizard(Project project) {
        boolean bl;
        DiscoveryWizardDescriptor discoveryWizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
        discoveryWizardDescriptor.setProject(project);
        discoveryWizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
        discoveryWizardDescriptor.setBuildResult(DiscoveryWizardAction.findBuildResult(project));
        discoveryWizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        discoveryWizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)discoveryWizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = discoveryWizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            // empty if block
        }
        dialog.dispose();
    }

    static String findBuildResult(Project project) {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider == null) {
            return null;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
        Configuration configuration = makeConfigurationDescriptor.getConfs().getActive();
        if (configuration instanceof MakeConfiguration) {
            String string = ((MakeConfiguration)configuration).getMakefileConfiguration().getOutput().getValue();
            if (string == null || string.length() == 0) {
                return null;
            }
            if (new File(string).isAbsolute()) {
                return string;
            }
            String string2 = DiscoveryWizardAction.getProjectDirectoryPath(project);
            string = FileUtil.normalizeFile((File)new File(string2 + '/' + string)).getAbsolutePath();
            return string;
        }
        return null;
    }

    static String getProjectDirectoryPath(Project project) {
        String string = project.getProjectDirectory().getPath();
        string = Utilities.isWindows() ? string.replace('\\', '/') : File.separator + project.getProjectDirectory().getPath();
        return string;
    }

    static String findSourceRoot(Project project) {
        String string = DiscoveryWizardAction.getProjectDirectoryPath(project);
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider != null) {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
            Folder folder = makeConfigurationDescriptor.getLogicalFolders();
            Vector vector = folder.getFolders();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object4 : vector) {
                object3 = (Folder)object4;
                if (!object3.isProjectFiles()) continue;
                if ("SourceFiles".equals(object3.getName())) {
                    serializable = object3.getFolders();
                    object2 = ((Vector)serializable).iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        Folder folder2 = (Folder)object;
                        if (!folder2.isProjectFiles()) continue;
                        arrayList.add(folder2.getName());
                    }
                    continue;
                }
                if ("HeaderFiles".equals(object3.getName()) || "ResourceFiles".equals(object3.getName())) continue;
                arrayList.add(object3.getName());
            }
            if (arrayList.size() > 0) {
                Object object4;
                String string2 = (String)arrayList.get(0);
                object4 = makeConfigurationDescriptor.getProjectItems();
                if (((E)object4).length > 0) {
                    object3 = object4[0].getPath();
                    serializable = null;
                    serializable = ((String)object3).startsWith("..") ? new StringBuilder(string) : new StringBuilder();
                    object2 = new StringTokenizer((String)object3, "/\\");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        ((StringBuilder)serializable).append(File.separator);
                        ((StringBuilder)serializable).append((String)object);
                        if (!string2.equals(object) || !((StringTokenizer)object2).hasMoreTokens()) continue;
                        return FileUtil.normalizeFile((File)new File(((StringBuilder)serializable).toString())).getAbsolutePath();
                    }
                }
            }
        }
        return string;
    }

    private Collection<Project> getMakeProjects(Node[] nodeArray) {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Project project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            if (project == null) {
                return null;
            }
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (configurationDescriptorProvider == null) {
                return null;
            }
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptorProvider.getConfigurationDescriptor();
            if (makeConfigurationDescriptor == null) {
                return null;
            }
            Configurations configurations = makeConfigurationDescriptor.getConfs();
            if (configurations == null) {
                return null;
            }
            Configuration configuration = configurations.getActive();
            if (!(configuration instanceof MakeConfiguration) || !((MakeConfiguration)configuration).isMakefileConfiguration()) {
                return null;
            }
            arrayList.add(project);
        }
        return arrayList;
    }

    private WizardDescriptor.InstantiatingIterator getPanels() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new SelectModeWizard(), new SelectProviderWizard(), new SelectObjectFilesWizard(), new ConsolidationStrategyWizard(), new SelectConfigurationWizard()};
        WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[]{panelArray[0], new SimpleConfigurationWizard()};
        String[] stringArray = new String[panelArray.length];
        String[] stringArray2 = new String[panelArray2.length];
        String[] stringArray3 = new String[]{panelArray[0].getComponent().getName(), "..."};
        for (int i = 0; i < panelArray.length; ++i) {
            Component component = panelArray[i].getComponent();
            stringArray[i] = component.getName();
            DiscoveryWizardAction.setupComponent(stringArray, stringArray3, i, component);
            if (i >= stringArray2.length) continue;
            component = panelArray2[i].getComponent();
            stringArray2[i] = component.getName();
            if (i <= 0 || i >= stringArray2.length) continue;
            DiscoveryWizardAction.setupComponent(stringArray2, null, i, component);
        }
        return new DiscoveryWizardIterator(panelArray, panelArray2);
    }

    static void setupComponent(String[] stringArray, String[] stringArray2, int n, Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
            if (n == 0) {
                jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
            } else {
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            }
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public String getName() {
        return this.getString("ACTION_TITLE_TXT");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getString(String string) {
        return NbBundle.getBundle(DiscoveryWizardAction.class).getString(string);
    }
}

