/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.project.PathCache;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarisLogReader {
    private static boolean TRACE = false;
    private static final String ENV_ROOT = "ROOT=";
    private static final String ENV_SRC = "SRC=";
    private String workingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private List<InstallLine> copyHeader;
    private Map<String, List<String>> findBase;
    private TreeMap<String, Set<String>> libraries;
    private String buidMashinePrototype;
    private String buidMashineSources;
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_SUN_CC = "CC ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_CC = "g++ ";
    private static final String MAKE_DELIMITER = ";";

    public SolarisLogReader(String string, String string2) {
        this.root = string2;
        this.fileName = string;
        this.setWorkingDir(string2);
    }

    private void run() {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        this.copyHeader = new ArrayList<InstallLine>();
        this.libraries = new TreeMap();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    string = string.trim();
                    if (this.buidMashinePrototype == null || this.buidMashineSources == null) {
                        if (string.startsWith(ENV_ROOT)) {
                            this.buidMashinePrototype = string.substring(ENV_ROOT.length());
                            if (!TRACE) continue;
                            System.out.println("Environment variable path to prototype: " + this.buidMashinePrototype);
                            continue;
                        }
                        if (string.startsWith(ENV_SRC)) {
                            this.buidMashineSources = string.substring(ENV_SRC.length());
                            if (!TRACE) continue;
                            System.out.println("Environment variable path to sources: " + this.buidMashineSources);
                            continue;
                        }
                    }
                    while (string.endsWith("\\") && (stringArray = bufferedReader.readLine()) != null) {
                        string = string.substring(0, string.length() - 1) + " " + stringArray.trim();
                    }
                    string = SolarisLogReader.trimBackApostropheCalls(string);
                    stringArray = pattern.split(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (this.parseLine(stringArray[i])) {
                            ++n;
                            continue;
                        }
                        InstallLine installLine = this.testInstall(stringArray[i]);
                        if (installLine == null) continue;
                        installLine.destination = this.relocate(installLine.destination);
                        installLine.source = this.relocate(installLine.source);
                        File file2 = new File(installLine.source);
                        if (!file2.exists() || file2.isDirectory()) continue;
                        this.copyHeader.add(installLine);
                    }
                }
                if (TRACE) {
                    System.out.println("Files found: " + n);
                    System.out.println("Files included in result: " + this.result.size());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults() {
        if (this.result == null) {
            this.run();
            this.findBase.clear();
            this.findBase = null;
        }
        return this.result;
    }

    List<InstallLine> getInstalls() {
        return this.copyHeader;
    }

    private boolean checkDirectoryChange(String string) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith(CURRENT_DIRECTORY)) {
            string2 = string.substring(CURRENT_DIRECTORY.length() + 1).trim();
            if (TRACE) {
                string3 = "**>> by [Current working directory] ";
            }
        } else if (string.indexOf(ENTERING_DIRECTORY) >= 0) {
            String string4 = string.substring(string.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            string2 = string4.replaceAll("`|'|\"", "");
            if (TRACE) {
                string3 = "**>> by [Entering directory] ";
            }
        } else if (string.startsWith(LABEL_CD)) {
            int n = string.indexOf(MAKE_DELIMITER);
            string2 = (n == -1 ? string : string.substring(0, n)).substring(LABEL_CD.length()).trim();
            if (TRACE) {
                string3 = "**>> by [ cd ] ";
            }
        } else if (string.startsWith("/") && string.indexOf(" ") < 0) {
            string2 = string.trim();
            if (TRACE) {
                string3 = "**>> by [just path string] ";
            }
        }
        if (string2 == null) {
            return false;
        }
        if (new File(string2 = this.relocate(string2)).exists()) {
            if (TRACE) {
                System.err.print(string3);
            }
            this.setWorkingDir(string2);
            return true;
        }
        string2 = this.getWorkingDir() + File.separator + string2;
        if (new File(string2).exists()) {
            if (TRACE) {
                System.err.print(string3);
            }
            this.setWorkingDir(string2);
            return true;
        }
        return false;
    }

    private String relocate(String string) {
        int n;
        String string2 = string;
        if (this.buidMashineSources != null && this.root.length() > 0 && string2.startsWith(this.buidMashineSources)) {
            int n2 = this.buidMashineSources.lastIndexOf("/usr/src");
            if (n2 > 0) {
                string2 = this.root + string.substring(n2);
            }
        } else if (this.buidMashinePrototype != null && this.root.length() > 0 && string2.startsWith(this.buidMashinePrototype) && (n = this.buidMashinePrototype.lastIndexOf("/proto/")) > 0) {
            string2 = this.root + string.substring(n);
        }
        if (TRACE && !string.equals(string2)) {
            System.out.println("Relocate path from: " + string + " to " + string2);
        }
        return string2;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    private InstallLine testInstall(String string) {
        if ((string = string.trim()).startsWith("install ") && string.indexOf("/proto/") > 0 && (string.indexOf("/usr/include") > 0 || string.indexOf("/usr/ucbinclude") > 0 || string.indexOf("/usr/sfw/include") > 0)) {
            return this.parseInstall(string.substring(string.indexOf(32) + 1));
        }
        return null;
    }

    private InstallLine parseInstall(String string) {
        String string2;
        Iterator<String> iterator = DiscoveryUtils.scanCommandLine(string).iterator();
        String string3 = "";
        String string4 = null;
        while (iterator.hasNext()) {
            string2 = iterator.next();
            if (string2.equals("-c")) {
                if (string3.length() != 0 || !iterator.hasNext()) continue;
                string3 = iterator.next();
                continue;
            }
            if (string2.equals("-f")) {
                if (string3.length() != 0 || !iterator.hasNext()) continue;
                string3 = iterator.next();
                continue;
            }
            if (string2.equals("-n")) {
                if (string3.length() != 0 || !iterator.hasNext()) continue;
                string3 = iterator.next();
                continue;
            }
            if (string2.equals("-m")) {
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            if (string2.equals("-u")) {
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            if (string2.equals("-g")) {
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            if (string2.startsWith("-d") || string2.startsWith("-i") || string2.startsWith("-d") || string2.startsWith("-o") || string2.startsWith("-s")) continue;
            if (string4 == null) {
                string4 = string2;
                if (!string4.startsWith("\"") || !string4.endsWith("\"")) continue;
                string4 = string4.substring(1, string4.length() - 1);
                continue;
            }
            if (!TRACE) continue;
            System.err.println("What is " + string2 + " in line " + string);
        }
        if (string3.length() > 0 && string4 != null && this.getWorkingDir() != null) {
            string2 = this.getWorkingDir();
            if (this.getWorkingDir().endsWith("/usr/src/uts/common/sys/lvm")) {
                string2 = string2.substring(0, string2.lastIndexOf("/lvm"));
            }
            string2 = string4.startsWith("/") ? string4 : string2 + "/" + string4;
            int n = string4.lastIndexOf(47);
            if (n > 0) {
                string4 = string4.substring(n + 1);
            }
            String string5 = string3 + "/" + string4;
            if (TRACE) {
                File file = new File(string5);
                if (file.exists() && !file.isDirectory()) {
                    File file2 = new File(string2);
                    if (file2.exists() && !file2.isDirectory()) {
                        System.err.println("Ok " + string2 + "->" + string5);
                    } else {
                        System.err.println("No source " + string2 + "->" + string5);
                    }
                } else {
                    System.err.println("No destination " + string2 + "->" + string5);
                }
            }
            return new InstallLine(string2, string5);
        }
        return null;
    }

    private LineInfo testCompilerInvocation(String string) {
        LineInfo lineInfo = new LineInfo(string);
        int n = 0;
        int n2 = -1;
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            lineInfo.compilerFamily = CompilerFamily.GNU;
            n2 = n + INVOKE_GNU_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            lineInfo.compilerFamily = CompilerFamily.GNU;
            n2 = n + INVOKE_GNU_CC.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            lineInfo.compilerFamily = CompilerFamily.SUN;
            n2 = n + INVOKE_SUN_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            lineInfo.compilerFamily = CompilerFamily.SUN;
            n2 = n + INVOKE_SUN_CC.length();
        }
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            lineInfo.compileLine = string.substring(n);
            while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != '-') {
                lineInfo.compilerType = CompilerType.UNKNOWN;
            } else if (n > 0 && string.charAt(n - 1) != '/') {
                int n3;
                String string2 = string.substring(0, n - 1).trim();
                if (!(string.charAt(n - 1) == ' ' && (string2.equals("if") || string2.equals("then") || string2.equals("else")) || (n3 = string.substring(0, n).indexOf("libtool")) >= 0 && string.substring(n3, n).indexOf("compile") >= 0)) {
                    lineInfo.compilerType = CompilerType.UNKNOWN;
                    if (TRACE) {
                        System.err.println("Suspicious line: " + string);
                    }
                }
            }
        }
        return lineInfo;
    }

    private void setWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + string);
        }
        this.workingDir = string;
    }

    private boolean parseLine(String string) {
        if (this.checkDirectoryChange(string)) {
            return false;
        }
        if (this.getWorkingDir() == null) {
            return false;
        }
        if (!this.getWorkingDir().startsWith(this.root)) {
            return false;
        }
        LineInfo lineInfo = this.testCompilerInvocation(string);
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            return this.gatherLine(lineInfo.compileLine, string.startsWith("+"), lineInfo.compilerType == CompilerType.CPP, lineInfo.compilerFamily);
        }
        return false;
    }

    private static String trimBackApostropheCalls(String string) {
        int n = string.indexOf(96);
        if (string.lastIndexOf(96) == n) {
            return string;
        }
        if (n < 0 || n == string.length() - 1) {
            return string;
        }
        String string2 = string.substring(0, n - 1);
        int n2 = (string = string.substring(n + 1)).indexOf(96);
        if (n2 < 0) {
            return string;
        }
        string2 = string2 + string.substring(n2 + 1);
        return SolarisLogReader.trimBackApostropheCalls(string2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean gatherLine(String string, boolean bl, boolean bl2, CompilerFamily compilerFamily) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        Object object3 = DiscoveryUtils.gatherComlilerLine(string, bl, arrayList, hashMap, hashSet);
        if (hashSet.size() > 0) {
            object2 = this.libraries.get(this.getWorkingDir());
            if (object2 == null) {
                this.libraries.put(this.getWorkingDir(), hashSet);
            } else {
                object2.addAll(hashSet);
            }
        }
        if (object3 == null) {
            return false;
        }
        object2 = null;
        if (((String)object3).startsWith("/")) {
            object3 = object2 = this.relocate((String)object3);
        } else {
            object2 = this.getWorkingDir() + "/" + (String)object3;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (String string2 : arrayList) {
            String object4 = this.relocate(string2);
            arrayList2.add(PathCache.getString(object4));
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            if (entry.getValue() == null) {
                hashMap2.put(PathCache.getString((String)entry.getKey()), null);
                continue;
            }
            hashMap2.put(PathCache.getString((String)entry.getKey()), PathCache.getString((String)entry.getValue()));
        }
        File file = new File((String)object2);
        if (!file.exists() || !file.isFile()) {
            if (TRACE) {
                System.err.println("**** Not found " + (String)object2);
            }
            String string3 = "";
            if (!((String)object3).startsWith("/")) {
                void var13_20;
                String string4;
                int n = ((String)object3).lastIndexOf(47);
                if (n > 0) {
                    String string5 = ((String)object3).substring(0, n);
                    object3 = ((String)object3).substring(n + 1);
                    object2 = this.getWorkingDir() + "/" + (String)object3;
                    File file2 = new File((String)object2);
                    if (file2.exists() && file2.isFile()) {
                        this.addToResult(new CommandLineSource(bl2, compilerFamily == CompilerFamily.SUN, this.getWorkingDir(), (String)object3, arrayList2, hashMap2));
                        return true;
                    }
                }
                if ((string4 = this.findFiles((String)object3, this.getWorkingDir(), (String)var13_20)) != null) {
                    this.setWorkingDir(string4);
                    this.addToResult(new CommandLineSource(bl2, compilerFamily == CompilerFamily.SUN, this.getWorkingDir(), (String)object3, arrayList2, hashMap2));
                    if (TRACE) {
                        System.err.println("** Gotcha: " + string4 + File.separator + (String)object3);
                    }
                    return true;
                }
            }
            if (TRACE) {
                System.err.println("" + (string.length() > 120 ? string.substring(0, 117) + ">>>" : string) + " [" + (String)object3 + "]");
            }
            return false;
        }
        if (TRACE && TRACE) {
            System.err.println("**** Gotcha: " + (String)object2);
        }
        this.addToResult(new CommandLineSource(bl2, compilerFamily == CompilerFamily.SUN, this.getWorkingDir(), (String)object3, arrayList2, hashMap2));
        return true;
    }

    private void addToResult(CommandLineSource commandLineSource) {
        CommandLineSource commandLineSource2;
        if (this.result.size() > 0 && (commandLineSource2 = (CommandLineSource)this.result.get(this.result.size() - 1)).getItemPath().equals(commandLineSource.getItemPath())) {
            if (Utilities.getOperatingSystem() == 8) {
                if (!commandLineSource2.isSunCompiler && commandLineSource.isSunCompiler) {
                    this.result.set(this.result.size() - 1, commandLineSource);
                    return;
                }
            } else if (!commandLineSource2.isSunCompiler && commandLineSource.isSunCompiler) {
                return;
            }
        }
        this.result.add(commandLineSource);
    }

    private String findFiles(String string, String string2, String string3) {
        List<String> list = this.getFiles(string);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        if (list != null) {
            Iterator<String> iterator;
            if (TRACE) {
                System.out.println("More then one " + string);
            }
            if ((iterator = list.iterator()).hasNext()) {
                String string4 = iterator.next();
                if (string4.startsWith(string2)) {
                    return string4;
                }
                return null;
            }
        } else if (TRACE) {
            System.out.println("Not found " + string);
        }
        return null;
    }

    private List<String> getFiles(String string) {
        if (this.findBase == null) {
            this.findBase = this.initSearchMap();
        }
        return this.findBase.get(string);
    }

    private Map<String, List<String>> initSearchMap() {
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(this.root);
        this.gatherSubFolders(file, hashSet);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Iterator<String> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file2 = new File(iterator.next());
            if (!file2.exists() || !file2.isDirectory() || !file2.canRead()) continue;
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                List<String> list = hashMap.get(fileArray[i].getName());
                if (list == null) {
                    list = new ArrayList<String>();
                    hashMap.put(fileArray[i].getName(), list);
                }
                list.add(file2.getAbsolutePath());
            }
        }
        return hashMap;
    }

    private void gatherSubFolders(File file, HashSet<String> hashSet) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            if (DiscoveryUtils.ignoreFolder(file)) {
                return;
            }
            String string = file.getAbsolutePath();
            if (!hashSet.contains(string)) {
                hashSet.add(file.getAbsolutePath());
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.gatherSubFolders(fileArray[i], hashSet);
                }
            }
        }
    }

    TreeMap<String, Set<String>> getLibraries() {
        return this.libraries;
    }

    TreeMap<String, Set<String>> readMapFile() {
        List<String> list = this.getFiles("mapfile-vers");
        if (list != null) {
            TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
            Collections.sort(list);
            for (String string : list) {
                Set<String> set = this.readMapFile(string + "/mapfile-vers");
                if (set == null) continue;
                treeMap.put(string, set);
            }
            return treeMap;
        }
        return null;
    }

    private Set<String> readMapFile(String string) {
        File file = new File(string);
        if (file.exists() && file.canRead()) {
            try {
                String string2;
                HashSet<String> hashSet = new HashSet<String>();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                boolean bl = false;
                boolean bl2 = false;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("#")) continue;
                    if (string2.endsWith("{")) {
                        bl2 = false;
                        bl = true;
                        continue;
                    }
                    if (string2.startsWith("}")) {
                        bl2 = false;
                        bl = false;
                        continue;
                    }
                    if (bl && string2.endsWith("global:")) {
                        bl2 = true;
                        continue;
                    }
                    if (bl && string2.endsWith("local:")) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl || !bl2 || string2.indexOf(MAKE_DELIMITER) <= 0 || string2.indexOf("FILTER") >= 0) continue;
                    String string3 = string2.substring(0, string2.indexOf(MAKE_DELIMITER));
                    if (string3.indexOf("=") > 0) {
                        string3 = string3.substring(0, string3.indexOf("="));
                    }
                    if (string3.indexOf(".") >= 0) continue;
                    string3 = string3.trim();
                    hashSet.add(string3);
                }
                bufferedReader.close();
                if (hashSet.size() > 0) {
                    return hashSet;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    static class InstallLine {
        private String source;
        private String destination;

        private InstallLine(String string, String string2) {
            this.source = string;
            this.destination = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void install() {
            File file = new File(this.source);
            if (file.exists() && file.canRead() && !file.isDirectory()) {
                File file2 = new File(this.destination);
                if (file2.exists()) {
                    return;
                }
                FileOutputStream fileOutputStream = null;
                FileInputStream fileInputStream = null;
                try {
                    FileUtil.createFolder((File)file2.getParentFile());
                    fileOutputStream = new FileOutputStream(file2);
                    fileInputStream = new FileInputStream(file);
                    FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                    if (TRACE) {
                        System.err.println("Installed " + this.source + "->" + this.destination);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();
        private boolean isSunCompiler;

        private CommandLineSource(boolean bl, boolean bl2, String string, String string2, List<String> list, Map<String, String> map) {
            this.language = bl ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
            this.isSunCompiler = bl2;
            this.compilePath = string;
            this.sourceName = string2;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath(string, this.sourceName);
            } else {
                this.fullName = string + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = FileUtil.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = list;
            this.userMacros = map;
        }

        @Override
        public String getCompilePath() {
            return this.compilePath;
        }

        @Override
        public String getItemPath() {
            return this.fullName;
        }

        @Override
        public String getItemName() {
            return this.sourceName;
        }

        @Override
        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        @Override
        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        @Override
        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        @Override
        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        @Override
        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }
    }

    private class LineInfo {
        public String compileLine;
        public CompilerType compilerType = CompilerType.UNKNOWN;
        public CompilerFamily compilerFamily = CompilerFamily.UNKNOWN;

        LineInfo(String string) {
            this.compileLine = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompilerFamily {
        SUN,
        GNU,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompilerType {
        CPP,
        C,
        UNKNOWN;

    }
}

