/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.diff.DiffActionTooltipWindow;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class DiffTooltipActionsPanel
extends JToolBar
implements ActionListener {
    private final Icon iconPrevious = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/versioning/diff/diff-prev.png"));
    private final Icon iconNext = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/versioning/diff/diff-next.png"));
    private final Icon iconDiff = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/versioning/diff/diff.png"));
    private final Icon iconRollback = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/versioning/diff/rollback.png"));
    private final DiffActionTooltipWindow master;
    private final Difference diff;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JButton rollButton;
    private final JButton diffButton;

    public DiffTooltipActionsPanel(DiffActionTooltipWindow diffActionTooltipWindow, Difference difference) {
        this.master = diffActionTooltipWindow;
        this.diff = difference;
        Color color = UIManager.getColor("ToolTip.background");
        if (color == null) {
            color = Color.WHITE;
        }
        this.setRollover(true);
        this.setFloatable(false);
        this.setBackground(color);
        this.prevButton = new JButton(this.iconPrevious);
        this.nextButton = new JButton(this.iconNext);
        this.rollButton = new JButton(this.iconRollback);
        this.diffButton = new JButton(this.iconDiff);
        this.prevButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_GoToPreviousDifference"));
        this.nextButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_GoToNextDifference"));
        this.diffButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Open_Diff_Window"));
        if (difference.getType() == 1) {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Delete_Added_Text"));
        } else if (difference.getType() == 2) {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Replace_With_Original_Text"));
        } else {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Restore_Original_Text"));
        }
        this.prevButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.rollButton.addActionListener(this);
        this.diffButton.addActionListener(this);
        this.prevButton.setBackground(color);
        this.nextButton.setBackground(color);
        this.rollButton.setBackground(color);
        this.diffButton.setBackground(color);
        this.add(this.prevButton);
        this.add(this.nextButton);
        this.add(this.rollButton);
        this.add(this.diffButton);
        Difference[] differenceArray = diffActionTooltipWindow.getMaster().getCurrentDiff();
        this.prevButton.setEnabled(differenceArray[0] != difference);
        this.nextButton.setEnabled(differenceArray[differenceArray.length - 1] != difference);
        this.rollButton.setEnabled(diffActionTooltipWindow.getMaster().canRollback(difference));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.prevButton) {
            this.master.shutdown();
            this.master.getMaster().onPrevious(this.diff);
        } else if (actionEvent.getSource() == this.nextButton) {
            this.master.shutdown();
            this.master.getMaster().onNext(this.diff);
        }
        if (actionEvent.getSource() == this.rollButton) {
            this.master.shutdown();
            this.master.getMaster().onRollback(this.diff);
        } else if (actionEvent.getSource() == this.diffButton) {
            this.master.shutdown();
            this.master.getMaster().onDiff(this.diff);
        }
    }
}

