/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.deploy;

import com.nokia.phone.deploy.CONA;
import com.nokia.phone.deploy.Deployer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DeployerMain {
    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("usage: DeployerMain <jad file> <jar file> [list of device names to deploy to]");
        } else {
            List<String> list;
            Object object;
            String[] stringArray2;
            if (!CONA.getInstance().isOSSupportsDeployment()) {
                System.err.println("Deployment aborted, only supported on Windows operating system");
                System.exit(0);
            }
            if (!CONA.getInstance().isConnAPIDllFound()) {
                System.err.println("Deployment aborted, ConnAPI.dll not found.");
                System.exit(0);
            }
            if (!CONA.getInstance().isConnJNIDllFound()) {
                System.err.println("Deployment aborted, ConnJNI.dll not found.");
                System.exit(0);
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            File file = new File(string);
            File file2 = new File(string2);
            ArrayList<List<String>> arrayList = null;
            if (stringArray.length > 2) {
                stringArray2 = stringArray[2].split("\n");
                arrayList = new ArrayList<List<String>>();
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = stringArray2[i].trim();
                    if (((String)object).equals("")) continue;
                    arrayList.add((List<String>)object);
                }
            }
            stringArray2 = new Deployer();
            stringArray2.openConnectionLayer();
            if (!stringArray2.isConnected()) {
                System.err.println("Deployment aborted, connection failed.");
                System.exit(0);
            }
            if ((list = stringArray2.getTerminals()).size() == 0) {
                System.err.println("Deployment aborted, no devices found.");
                stringArray2.closeConnectionLayer();
                System.exit(0);
            }
            object = new ArrayList();
            if (arrayList != null) {
                for (String string3 : arrayList) {
                    if (!list.contains(string3)) {
                        System.err.println("Could not deploy. Selected terminal: " + string3 + " is not currently connected.");
                        object.add((String)string3);
                        continue;
                    }
                    System.out.println("Deploying to: '" + string3 + "' using " + stringArray2.getConnectionType(string3));
                    try {
                        boolean unsatisfiedLinkError = stringArray2.deploy(new File(string), new File(string2), string3);
                        if (unsatisfiedLinkError) {
                            System.out.println("Deployment succeeded!");
                            continue;
                        }
                        object.add((String)string3);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object.add((String)string3);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                        object.add((String)string3);
                    }
                }
                arrayList.removeAll((Collection<?>)object);
            } else {
                System.out.println("Deploying to all connected terminals.");
                object = stringArray2.deployToAllTerminals(file, file2);
            }
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                System.err.println("Could not deploy to terminal: " + string3);
            }
            System.out.println("Deployment done, closing connection layer");
            stringArray2.closeConnectionLayer();
        }
    }
}

