/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.javaee.codegen.model.Endpoint;
import org.netbeans.modules.compapp.javaee.codegen.model.EndpointCfg;
import org.netbeans.modules.compapp.javaee.codegen.model.JavaEEProject;
import org.netbeans.modules.compapp.javaee.util.ProjectUtil;

public class BuildJavaEESU
extends Task {
    private static final String ANT_PROP_BUILD_DIR = "build.dir";
    private static final String ANT_PROJ_BASE_DIR = "basedir";
    private String subprojJar = null;
    private String subprojDir = null;
    private String subprojResource = null;
    private String projName = null;
    private String suExtractDir = null;
    private String caBuildDir = "build";

    public void setProjectName(String name) {
        this.projName = name;
    }

    public void setSubprojJar(String s) {
        this.subprojJar = s;
    }

    public void setSubprojDir(String d) {
        this.subprojDir = d;
    }

    public void setSuExtractDir(String xDir) {
        this.suExtractDir = xDir;
    }

    public void setSubprojResource(String resource) {
        this.subprojResource = resource;
    }

    private void createDir(String bDir) {
        File buildDir = new File(bDir);
        if (!buildDir.exists()) {
            buildDir.mkdir();
        }
    }

    public void execute() throws BuildException {
        this.log("Starting build on JavaEE Project:" + this.subprojDir);
        Project p = null;
        String projPath = null;
        String confDir = null;
        String buildDir = null;
        String jbiExtractDir = null;
        Object obj = null;
        JavaEEProject javaeeProj = null;
        String instrumentedJarPath = null;
        try {
            p = this.getProject();
            projPath = p.getProperty(ANT_PROJ_BASE_DIR) + File.separator;
            if (p.getProperty("meta.inf") != null) {
                confDir = p.getProperty("meta.inf");
            }
            if (p.getProperty(ANT_PROP_BUILD_DIR) != null) {
                this.caBuildDir = p.getProperty(ANT_PROP_BUILD_DIR);
            }
            if (this.subprojJar != null && this.subprojJar.startsWith("..")) {
                this.subprojJar = projPath + this.subprojJar;
            }
            if (this.subprojResource != null && this.subprojResource.startsWith("..")) {
                this.subprojResource = projPath + this.subprojResource;
            }
            String cofigDirPath = projPath + File.separator + confDir + File.separator;
            File configDir = new File(cofigDirPath);
            javaeeProj = ProjectUtil.getJavaEEProject((String)this.projName, (String)this.subprojJar, (String)cofigDirPath, (String)this.subprojResource);
            buildDir = projPath + File.separator + this.caBuildDir;
            jbiExtractDir = projPath + File.separator + this.suExtractDir;
            this.createDir(buildDir);
            this.createDir(jbiExtractDir);
            List cfgs = ProjectUtil.getEndpointCfgs((File)configDir, (String)this.projName);
            javaeeProj.setEndpointOverrides(cfgs);
            instrumentedJarPath = javaeeProj.createJar(buildDir, jbiExtractDir);
            List epts = javaeeProj.getEndpoints();
            ArrayList<EndpointCfg> eptCfgs = javaeeProj.getEndpointOverrides();
            boolean newEPAdded = false;
            EndpointCfg epCfg = null;
            if (eptCfgs == null) {
                eptCfgs = new ArrayList<EndpointCfg>();
            }
            if (epts != null) {
                for (Endpoint ep : epts) {
                    if (eptCfgs.contains(ep)) continue;
                    newEPAdded = true;
                    epCfg = new EndpointCfg();
                    epCfg.setEndPointName(ep.getEndPointName());
                    epCfg.setEndPointType(ep.getEndPointType());
                    epCfg.setInterfaceName(ep.getInterfaceName());
                    epCfg.setServiceName(ep.getServiceName());
                    eptCfgs.add(epCfg);
                }
            }
            if (newEPAdded) {
                ProjectUtil.saveEndpointCfgs((File)configDir, (String)this.projName, eptCfgs);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException((Throwable)ex);
        }
    }
}

