/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class PushPopRemover
extends SimplifiedVisitor
implements InstructionVisitor {
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public PushPopRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(branchTargetFinder, codeAttributeEditor, null);
    }

    public PushPopRemover(BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 89: 
            case 92: {
                this.deleteWithSubsequentPop(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (variableInstruction.isLoad() && variableInstruction.opcode != -87) {
            this.deleteWithSubsequentPop(clazz, method, codeAttribute, n, variableInstruction);
        }
    }

    private void deleteWithSubsequentPop(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        boolean bl = instruction.isCategory2();
        int n2 = n + instruction.length(n);
        if (!(this.codeAttributeEditor.isModified(n) || this.codeAttributeEditor.isModified(n2) || this.branchTargetFinder.isTarget(n2))) {
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, n2);
            byte by = instruction2.opcode;
            if ((by == 87 || by == 88) && instruction2.isCategory2() == bl) {
                this.codeAttributeEditor.deleteInstruction(n);
                this.codeAttributeEditor.deleteInstruction(n2);
                if (this.extraInstructionVisitor != null) {
                    instruction.accept(clazz, method, codeAttribute, n, this.extraInstructionVisitor);
                }
            }
        }
    }
}

