/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificIntegerValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificLongValue
extends LongValue {
    private final long value;

    public SpecificLongValue(long l) {
        this.value = l;
    }

    public long value() {
        return this.value;
    }

    public LongValue generalize(LongValue longValue) {
        return longValue.generalize(this);
    }

    public LongValue add(LongValue longValue) {
        return longValue.add(this);
    }

    public LongValue subtract(LongValue longValue) {
        return longValue.subtractFrom(this);
    }

    public LongValue subtractFrom(LongValue longValue) {
        return longValue.subtract(this);
    }

    public LongValue multiply(LongValue longValue) {
        return longValue.multiply(this);
    }

    public LongValue divide(LongValue longValue) {
        return longValue.divideOf(this);
    }

    public LongValue divideOf(LongValue longValue) {
        return longValue.divide(this);
    }

    public LongValue remainder(LongValue longValue) {
        return longValue.remainderOf(this);
    }

    public LongValue remainderOf(LongValue longValue) {
        return longValue.remainder(this);
    }

    public LongValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public LongValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public LongValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public LongValue and(LongValue longValue) {
        return longValue.and(this);
    }

    public LongValue or(LongValue longValue) {
        return longValue.or(this);
    }

    public LongValue xor(LongValue longValue) {
        return longValue.xor(this);
    }

    public IntegerValue compare(LongValue longValue, ValueFactory valueFactory) {
        return longValue.compareReverse(this, valueFactory);
    }

    public LongValue negate() {
        return new SpecificLongValue(-this.value);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return valueFactory.createIntegerValue((int)this.value);
    }

    public FloatValue convertToFloat(ValueFactory valueFactory) {
        return valueFactory.createFloatValue(this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public LongValue generalize(SpecificLongValue specificLongValue) {
        return this.value == specificLongValue.value ? this : ValueFactory.LONG_VALUE;
    }

    public LongValue add(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value + specificLongValue.value);
    }

    public LongValue subtract(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value - specificLongValue.value);
    }

    public LongValue subtractFrom(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(specificLongValue.value - this.value);
    }

    public LongValue multiply(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value * specificLongValue.value);
    }

    public LongValue divide(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value / specificLongValue.value);
    }

    public LongValue divideOf(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(specificLongValue.value / this.value);
    }

    public LongValue remainder(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value % specificLongValue.value);
    }

    public LongValue remainderOf(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(specificLongValue.value % this.value);
    }

    public LongValue shiftLeft(SpecificIntegerValue specificIntegerValue) {
        return new SpecificLongValue(this.value << specificIntegerValue.value());
    }

    public LongValue shiftRight(SpecificIntegerValue specificIntegerValue) {
        return new SpecificLongValue(this.value >> specificIntegerValue.value());
    }

    public LongValue unsignedShiftRight(SpecificIntegerValue specificIntegerValue) {
        return new SpecificLongValue(this.value >>> specificIntegerValue.value());
    }

    public LongValue and(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value & specificLongValue.value);
    }

    public LongValue or(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value | specificLongValue.value);
    }

    public LongValue xor(SpecificLongValue specificLongValue) {
        return new SpecificLongValue(this.value ^ specificLongValue.value);
    }

    public IntegerValue compare(SpecificLongValue specificLongValue, ValueFactory valueFactory) {
        return this.value < specificLongValue.value ? valueFactory.createIntegerValue(-1) : (this.value == specificLongValue.value ? valueFactory.createIntegerValue(0) : valueFactory.createIntegerValue(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificLongValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return "l:" + this.value;
    }
}

