/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.trace.TraceXRef;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelui.trace.TestReparseAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProjectReferencesAction
extends TestProjectActionBase {
    private static boolean running = false;
    private final boolean allReferences;
    private final boolean analyzeStatistics;
    private Boolean reportUnresolved = Boolean.TRUE;

    public static Action getSmartCompletionAnalyzerAction() {
        return (Action)SharedClassObject.findObject(SmartCompletionAnalyzerAction.class, (boolean)true);
    }

    public static Action getTestReparseAction() {
        return (Action)SharedClassObject.findObject(TestReparseAction.class, (boolean)true);
    }

    public static Action getDirectUsageReferencesAction() {
        return (Action)SharedClassObject.findObject(DirectUsageAction.class, (boolean)true);
    }

    public static Action getAllReferencesAction() {
        return (Action)SharedClassObject.findObject(AllUsagesAction.class, (boolean)true);
    }

    protected TestProjectReferencesAction(boolean bl, boolean bl2) {
        this(bl, bl2, Boolean.TRUE);
    }

    protected TestProjectReferencesAction(boolean bl, boolean bl2, Boolean bl3) {
        this.allReferences = bl;
        this.analyzeStatistics = bl2;
        this.reportUnresolved = bl3;
    }

    public String getName() {
        String string = this.analyzeStatistics ? "CTL_TestProjectSmartCCDirectUsageReferencesAction" : (this.allReferences ? "CTL_TestProjectReferencesAction" : "CTL_TestProjectDirectUsageReferencesAction");
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string);
    }

    @Override
    protected void performAction(Collection<NativeProject> collection) {
        Boolean bl = this.reportUnresolved;
        if (this.reportUnresolved == null) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)"Report unresolved references?", "Test References"));
            if (object == NotifyDescriptor.YES_OPTION) {
                this.reportUnresolved = Boolean.TRUE;
            } else if (object == NotifyDescriptor.NO_OPTION) {
                this.reportUnresolved = Boolean.FALSE;
            } else {
                return;
            }
        }
        if (collection != null) {
            for (NativeProject nativeProject : collection) {
                this.testProject(nativeProject);
            }
        }
        this.reportUnresolved = bl;
    }

    private void testProject(NativeProject nativeProject) {
        String string = (this.allReferences ? "All " : "Direct usage ") + "xRef - " + nativeProject.getProjectDisplayName() + (this.analyzeStatistics ? " Statistics" : "");
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

            public boolean cancel() {
                atomicBoolean.set(true);
                return true;
            }
        });
        progressHandle.start();
        final OutputWriter outputWriter = inputOutput.getOut();
        final OutputWriter outputWriter2 = inputOutput.getErr();
        final long[] lArray = new long[2];
        lArray[0] = System.currentTimeMillis();
        EnumSet<CsmReferenceKind> enumSet = this.allReferences ? CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE : EnumSet.of(CsmReferenceKind.DIRECT_USAGE);
        TraceXRef.traceProjectRefsStatistics((NativeProject)nativeProject, (TraceXRef.StatisticsParameters)new TraceXRef.StatisticsParameters(enumSet, this.analyzeStatistics, this.reportUnresolved == null ? true : this.reportUnresolved), (PrintWriter)outputWriter, (OutputWriter)outputWriter2, (CsmProgressListener)new CsmProgressAdapter(){
            private int handled = 0;

            public void projectFilesCounted(CsmProject csmProject, int n) {
                outputWriter2.flush();
                outputWriter.println("Project " + csmProject.getName() + " has " + n + " files");
                outputWriter.flush();
                progressHandle.switchToDeterminate(n);
            }

            public void fileParsingStarted(CsmFile csmFile) {
                progressHandle.progress("Analyzing " + csmFile.getName(), this.handled++);
            }

            public void projectParsingFinished(CsmProject csmProject) {
                lArray[1] = System.currentTimeMillis();
            }
        }, (AtomicBoolean)atomicBoolean);
        progressHandle.finish();
        outputWriter.println("Analyzing " + nativeProject.getProjectDisplayName() + " took " + (lArray[1] - lArray[0]) + "ms");
        outputWriter2.flush();
        outputWriter.flush();
    }

    static final class AllUsagesAction
    extends TestProjectReferencesAction {
        AllUsagesAction() {
            super(true, false, null);
        }
    }

    static final class DirectUsageAction
    extends TestProjectReferencesAction {
        DirectUsageAction() {
            super(false, false);
        }
    }

    static final class SmartCompletionAnalyzerAction
    extends TestProjectReferencesAction {
        SmartCompletionAnalyzerAction() {
            super(false, true);
        }
    }
}

