/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class JarFileFilter
extends FileFilter {
    public static final String JAR_EXT = "jar";
    public static final String EAR_EXT = "ear";
    private boolean jarOnly = true;

    public JarFileFilter(boolean bl) {
        this.jarOnly = bl;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = this.getExtension(file);
        if (string != null) {
            if (this.jarOnly && string.equalsIgnoreCase(JAR_EXT)) {
                return true;
            }
            return !this.jarOnly && (string.equalsIgnoreCase(JAR_EXT) || string.equalsIgnoreCase(EAR_EXT));
        }
        return false;
    }

    public String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public String getDescription() {
        if (this.jarOnly) {
            return "JAR Files (.jar)";
        }
        return "EAR or JAR Files (.ear or .jar)";
    }
}

